/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.bendpoint;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.impl.DefaultRemoveBendpointFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class RemoveBendpointFeature
extends DefaultRemoveBendpointFeature {
    public RemoveBendpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canRemoveBendpoint(IRemoveBendpointContext context) {
        Shape connectionPointShape = AnchorUtil.getConnectionPointAt(context.getConnection(), context.getBendpoint());
        if (connectionPointShape != null) {
            return false;
        }
        return super.canRemoveBendpoint(context);
    }

    public void removeBendpoint(IRemoveBendpointContext context) {
        super.removeBendpoint(context);
        FreeFormConnection connection = context.getConnection();
        try {
            BaseElement element = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            BPMNEdge edge = DIUtils.findBPMNEdge((EObject)element);
            edge.getWaypoint().remove(context.getBendpointIndex() + 1);
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        BendpointConnectionRouter.setRemovedBendpoint((Connection)connection, context.getBendpointIndex());
        FeatureSupport.updateConnection(this.getFeatureProvider(), (Connection)connection);
    }
}

