/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.artifact;

import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNShapeFeature;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutTextAnnotationFeature
extends DefaultLayoutBPMNShapeFeature {
    public LayoutTextAnnotationFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        PictogramElement pictoElem = context.getPictogramElement();
        if (!(pictoElem instanceof ContainerShape)) {
            return false;
        }
        Object bo = this.getBusinessObjectForPictogramElement(pictoElem);
        return bo instanceof TextAnnotation;
    }

    @Override
    public boolean layout(ILayoutContext context) {
        boolean changed = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
        IGaService gaService = Graphiti.getGaService();
        if (ga.getWidth() < 100) {
            ga.setWidth(100);
            changed = true;
        }
        if (ga.getHeight() < 50) {
            ga.setHeight(50);
            changed = true;
        }
        int containerWidth = ga.getWidth();
        int containerHeight = ga.getHeight();
        DIUtils.updateDIShape((PictogramElement)containerShape);
        for (Shape shape : containerShape.getChildren()) {
            GraphicsAlgorithm shapeGa = shape.getGraphicsAlgorithm();
            IDimension size = gaService.calculateSize(shapeGa);
            if (containerWidth != size.getWidth() && shapeGa instanceof MultiText) {
                gaService.setWidth(shapeGa, containerWidth - 5);
                changed = true;
            }
            if (containerHeight == size.getHeight()) continue;
            if (shapeGa instanceof Polyline) {
                Polyline line = (Polyline)shapeGa;
                line.getPoints().set(2, (Object)this.getNewPoint(line, 2, containerHeight, gaService));
                line.getPoints().set(3, (Object)this.getNewPoint(line, 3, containerHeight, gaService));
                changed = true;
                continue;
            }
            if (!(shapeGa instanceof MultiText)) continue;
            gaService.setHeight(shapeGa, containerHeight - 5);
            changed = true;
        }
        return changed;
    }

    private Point getNewPoint(Polyline line, int pointIndex, int height, IGaService gaService) {
        Point p = (Point)line.getPoints().get(pointIndex);
        return gaService.createPoint(p.getX(), height);
    }
}

