/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.StandardLoopCharacteristics;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractUpdateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public class UpdateActivityLoopAndMultiInstanceMarkerFeature
extends AbstractUpdateMarkerFeature<Activity> {
    public static String IS_LOOP_OR_MULTI_INSTANCE = "marker.loop.or.multi";

    public UpdateActivityLoopAndMultiInstanceMarkerFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected String getPropertyKey() {
        return IS_LOOP_OR_MULTI_INSTANCE;
    }

    @Override
    protected boolean isPropertyChanged(Activity activity, String propertyValue) {
        return !UpdateActivityLoopAndMultiInstanceMarkerFeature.getLoopCharacteristicsValue(activity).getName().equals(propertyValue);
    }

    @Override
    protected void doUpdate(Activity activity, ContainerShape markerContainer) {
        switch (UpdateActivityLoopAndMultiInstanceMarkerFeature.getLoopCharacteristicsValue(activity)) {
            case LOOP: {
                GraphicsUtil.showActivityMarker(markerContainer, "activity.marker.lc.standard");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            case MULTI_PARALLEL: {
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                GraphicsUtil.showActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            case MULTI_SEQUENTIAL: {
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                GraphicsUtil.showActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            default: {
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                GraphicsUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
            }
        }
    }

    @Override
    protected String convertPropertyToString(Activity activity) {
        return UpdateActivityLoopAndMultiInstanceMarkerFeature.getLoopCharacteristicsValue(activity).getName();
    }

    public static LoopCharacteristicType getLoopCharacteristicsValue(Activity activity) {
        LoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
        LoopCharacteristicType type = LoopCharacteristicType.NULL;
        if (loopCharacteristics != null) {
            MultiInstanceLoopCharacteristics multi;
            type = loopCharacteristics instanceof MultiInstanceLoopCharacteristics ? ((multi = (MultiInstanceLoopCharacteristics)loopCharacteristics).isIsSequential() ? LoopCharacteristicType.MULTI_SEQUENTIAL : LoopCharacteristicType.MULTI_PARALLEL) : LoopCharacteristicType.LOOP;
        }
        return type;
    }

    static enum LoopCharacteristicType {
        NULL("null"),
        LOOP(StandardLoopCharacteristics.class.getSimpleName()),
        MULTI_PARALLEL(String.valueOf(MultiInstanceLoopCharacteristics.class.getSimpleName()) + ":parallel"),
        MULTI_SEQUENTIAL(String.valueOf(MultiInstanceLoopCharacteristics.class.getSimpleName()) + ":sequential");

        private String name;

        private LoopCharacteristicType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

