/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractBoundaryEventOperation;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutActivityFeature
extends DefaultLayoutBPMNShapeFeature {
    public LayoutActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        BaseElement bo = BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), BaseElement.class);
        return bo != null && bo instanceof Activity;
    }

    @Override
    public boolean layout(ILayoutContext context) {
        PictogramElement pe;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
        int newWidth = parentGa.getWidth();
        int newHeight = parentGa.getHeight();
        GraphicsUtil.setActivityMarkerOffest(containerShape, this.getMarkerContainerOffset());
        GraphicsUtil.layoutActivityMarkerContainer(containerShape);
        for (Shape shape : Graphiti.getPeService().getAllContainedShapes(containerShape)) {
            Object[] objects;
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            IGaService gaService = Graphiti.getGaService();
            Shape rectShape = FeatureSupport.getShape(containerShape, "activity", Boolean.toString(true));
            gaService.setSize(rectShape.getGraphicsAlgorithm(), newWidth, newHeight);
            this.layoutInRectangle((RoundedRectangle)rectShape.getGraphicsAlgorithm());
            Object[] objectArray = objects = this.getAllBusinessObjectsForPictogramElement((PictogramElement)shape);
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                this.layoutHook(shape, ga, bo, newWidth, newHeight);
                ++n2;
            }
        }
        Activity activity = BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        new AbstractBoundaryEventOperation(){

            @Override
            protected void doWorkInternal(ContainerShape container) {
                LayoutActivityFeature.this.layoutPictogramElement((PictogramElement)container);
            }
        }.doWork(activity, this.getDiagram());
        DIUtils.updateDIShape((PictogramElement)containerShape);
        this.layoutConnections((PictogramElement)containerShape);
        if (containerShape.eContainer() instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(pe = (PictogramElement)containerShape.eContainer(), SubProcess.class)) {
            this.layoutPictogramElement(pe);
        }
        return true;
    }

    protected int getMarkerContainerOffset() {
        return 0;
    }

    protected void layoutInRectangle(RoundedRectangle rect) {
    }

    protected boolean layoutHook(Shape shape, GraphicsAlgorithm ga, Object bo, int newWidth, int newHeight) {
        return false;
    }
}

