/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.UpdateActivityCompensateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.UpdateActivityLoopAndMultiInstanceMarkerFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractAddActivityFeature<T extends Activity>
extends AbstractBpmn2AddElementFeature<T> {
    public static final String ACTIVITY_DECORATOR = "activity-decorator";
    public static final String IS_ACTIVITY = "activity";
    protected final IGaService gaService = Graphiti.getGaService();
    protected final IPeService peService = Graphiti.getPeService();
    protected Bpmn2Preferences preferences;

    public AbstractAddActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        this.preferences = Bpmn2Preferences.getInstance((EObject)context.getNewObject());
        Activity businessObject = (Activity)this.getBusinessObject(context);
        int width = context.getWidth() > 0 ? context.getWidth() : this.getWidth();
        int height = context.getHeight() > 0 ? context.getHeight() : this.getHeight();
        GraphicsAlgorithm targetAlgorithm = context.getTargetContainer().getGraphicsAlgorithm();
        if (targetAlgorithm != null) {
            width = Math.min(targetAlgorithm.getWidth(), width);
            height = Math.min(targetAlgorithm.getHeight(), height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = this.peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = this.gaService.createInvisibleRectangle((PictogramElement)containerShape);
        this.gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
        Shape rectShape = this.peService.createShape(containerShape, false);
        RoundedRectangle rect = this.gaService.createRoundedRectangle((GraphicsAlgorithmContainer)rectShape, 5, 5);
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, (BaseElement)businessObject);
        this.gaService.setLocationAndSize((GraphicsAlgorithm)rect, 0, 0, width, height);
        this.link((PictogramElement)rectShape, businessObject);
        this.peService.setPropertyValue((PropertyContainer)rectShape, IS_ACTIVITY, Boolean.toString(true));
        boolean isImport = context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, UpdateActivityCompensateMarkerFeature.IS_COMPENSATE_PROPERTY, Boolean.toString(false));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, UpdateActivityLoopAndMultiInstanceMarkerFeature.IS_LOOP_OR_MULTI_INSTANCE, UpdateActivityLoopAndMultiInstanceMarkerFeature.LoopCharacteristicType.NULL.getName());
        for (PictogramElement pe : containerShape.getChildren()) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, ACTIVITY_DECORATOR, "true");
        }
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, businessObject);
        this.peService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)rect);
        for (PictogramElement pe : containerShape.getChildren()) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, ACTIVITY_DECORATOR, "true");
        }
        this.splitConnection(context, containerShape);
        this.updatePictogramElement((PictogramElement)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    protected int getMarkerContainerOffset() {
        return 0;
    }

    @Override
    public abstract int getWidth();

    @Override
    public abstract int getHeight();
}

