/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.features.RouteSolver;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ManhattanConnectionRouter
extends BendpointConnectionRouter {
    protected GraphicsUtil.LineSegment sourceTopEdge;
    protected GraphicsUtil.LineSegment sourceBottomEdge;
    protected GraphicsUtil.LineSegment sourceLeftEdge;
    protected GraphicsUtil.LineSegment sourceRightEdge;
    protected GraphicsUtil.LineSegment targetTopEdge;
    protected GraphicsUtil.LineSegment targetBottomEdge;
    protected GraphicsUtil.LineSegment targetLeftEdge;
    protected GraphicsUtil.LineSegment targetRightEdge;
    static final int offset = 20;
    static boolean testRouteSolver = false;

    public ManhattanConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected ConnectionRoute calculateRoute() {
        Point start;
        if (this.isSelfConnection()) {
            return super.calculateRoute();
        }
        GraphicsUtil.LineSegment[] sourceEdges = GraphicsUtil.getEdges(this.source);
        this.sourceTopEdge = sourceEdges[0];
        this.sourceBottomEdge = sourceEdges[1];
        this.sourceLeftEdge = sourceEdges[2];
        this.sourceRightEdge = sourceEdges[3];
        GraphicsUtil.LineSegment[] targetEdges = GraphicsUtil.getEdges(this.target);
        this.targetTopEdge = targetEdges[0];
        this.targetBottomEdge = targetEdges[1];
        this.targetLeftEdge = targetEdges[2];
        this.targetRightEdge = targetEdges[3];
        Point end = GraphicsUtil.createPoint(this.ffc.getEnd());
        Point middle = null;
        if (this.movedBendpoint != null) {
            middle = this.movedBendpoint;
            this.findAllShapes();
            for (ContainerShape shape : this.allShapes) {
                if (!GraphicsUtil.contains((Shape)shape, middle)) continue;
                middle = null;
                break;
            }
        }
        if (testRouteSolver) {
            this.findAllShapes();
            RouteSolver solver = new RouteSolver(this.fp, this.allShapes);
            solver.solve(this.source, this.target);
        }
        ArrayList<ConnectionRoute> allRoutes = new ArrayList<ConnectionRoute>();
        Map<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> sourceBoundaryAnchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)this.source);
        Map<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> targetBoundaryAnchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)this.target);
        if (this.sourceAnchor != null) {
            start = GraphicsUtil.createPoint(this.sourceAnchor);
            if (this.targetAnchor != null) {
                end = GraphicsUtil.createPoint(this.targetAnchor);
                this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.HORIZONTAL);
                this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.VERTICAL);
            } else {
                for (Map.Entry<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> targetEntry : targetBoundaryAnchors.entrySet()) {
                    end = GraphicsUtil.createPoint((Anchor)targetEntry.getValue().anchor);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.HORIZONTAL);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.VERTICAL);
                }
            }
        } else {
            for (Map.Entry<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> sourceEntry : sourceBoundaryAnchors.entrySet()) {
                if (!this.isValidBoundaryAnchor(sourceEntry.getValue(), this.source)) continue;
                start = GraphicsUtil.createPoint((Anchor)sourceEntry.getValue().anchor);
                if (this.targetAnchor != null) {
                    end = GraphicsUtil.createPoint(this.targetAnchor);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.HORIZONTAL);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.VERTICAL);
                    continue;
                }
                for (Map.Entry<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> targetEntry : targetBoundaryAnchors.entrySet()) {
                    if (!this.isValidBoundaryAnchor(targetEntry.getValue(), this.target)) continue;
                    end = GraphicsUtil.createPoint((Anchor)targetEntry.getValue().anchor);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.HORIZONTAL);
                    this.calculateRoute(allRoutes, this.source, start, middle, this.target, end, Orientation.VERTICAL);
                }
            }
        }
        ConnectionRoute route = null;
        if (allRoutes.size() == 1) {
            route = (ConnectionRoute)allRoutes.get(0);
            GraphicsUtil.dump("Only one valid route: " + route.toString());
        } else if (allRoutes.size() > 1) {
            GraphicsUtil.dump("Optimizing Routes:\n------------------");
            allRoutes.size();
            for (ConnectionRoute r : allRoutes) {
                r.optimize();
                int size = r.size();
                if (size <= 2) continue;
                int n = 1;
                Point p0 = r.get(n);
                AnchorUtil.BoundaryAnchor ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.source, p0);
                Point p1 = GraphicsUtil.createPoint(ba.location);
                if (p1.getX() == p0.getX() || p1.getY() == p0.getY()) {
                    r.getPoints().set(n - 1, p1);
                }
                n = size - 2;
                p0 = r.get(n);
                ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.target, p0);
                p1 = GraphicsUtil.createPoint(ba.location);
                if (p1.getX() != p0.getX() && p1.getY() != p0.getY()) continue;
                r.getPoints().set(n + 1, p1);
            }
            GraphicsUtil.dump("Calculating Crossings:\n------------------");
            for (ConnectionRoute r : allRoutes) {
                if (r.getPoints().size() > 1) {
                    Point p1 = r.getPoints().get(0);
                    int i = 1;
                    while (i < r.getPoints().size()) {
                        Point p2 = r.getPoints().get(i);
                        List<Connection> crossings = this.findCrossings(p1, p2);
                        for (Connection c : crossings) {
                            if (c == this.connection) continue;
                            r.addCrossing(c, p1, p2);
                        }
                        ContainerShape shape = this.getCollision(p1, p2);
                        if (shape != null) {
                            r.addCollision((Shape)shape, p1, p2);
                        }
                        p1 = p2;
                        ++i;
                    }
                }
                GraphicsUtil.dump("    " + r.toString());
            }
            GraphicsUtil.dump("Sorting Routes:\n------------------");
            Collections.sort(allRoutes);
            this.drawConnectionRoutes(allRoutes);
            route = (ConnectionRoute)allRoutes.get(0);
        }
        if (route != null) {
            route.optimize();
        }
        return route;
    }

    protected boolean isValidBoundaryAnchor(AnchorUtil.BoundaryAnchor ba, Shape shape) {
        BoundaryEventPositionHelper.PositionOnLine sp = BoundaryEventPositionHelper.getPositionOnLineProperty((PropertyContainer)shape);
        if (sp != null) {
            switch (sp.getLocationType()) {
                case BOTTOM: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.BOTTOM) break;
                    return false;
                }
                case BOTTOM_LEFT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.BOTTOM || ba.locationType == AnchorUtil.AnchorLocation.LEFT) break;
                    return false;
                }
                case BOTTOM_RIGHT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.BOTTOM || ba.locationType == AnchorUtil.AnchorLocation.RIGHT) break;
                    return false;
                }
                case LEFT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.LEFT) break;
                    return false;
                }
                case RIGHT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.RIGHT) break;
                    return false;
                }
                case TOP: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.TOP) break;
                    return false;
                }
                case TOP_LEFT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.TOP || ba.locationType == AnchorUtil.AnchorLocation.LEFT) break;
                    return false;
                }
                case TOP_RIGHT: {
                    if (ba.locationType == AnchorUtil.AnchorLocation.TOP || ba.locationType == AnchorUtil.AnchorLocation.RIGHT) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected ConnectionRoute calculateRoute(List<ConnectionRoute> allRoutes, Shape source, Point start, Point middle, Shape target, Point end, Orientation orientation) {
        ConnectionRoute route = new ConnectionRoute(this, allRoutes.size() + 1, source, target);
        if (middle != null) {
            List<Point> departure = this.calculateDeparture(source, start, middle);
            List<Point> approach = this.calculateApproach(middle, target, end);
            route.getPoints().addAll(departure);
            this.calculateEnroute(route, departure.get(departure.size() - 1), middle, orientation);
            route.getPoints().add(middle);
            this.calculateEnroute(route, middle, approach.get(0), orientation);
            route.getPoints().addAll(approach);
        } else {
            List<Point> departure = this.calculateDeparture(source, start, end);
            List<Point> approach = this.calculateApproach(start, target, end);
            route.getPoints().addAll(departure);
            this.calculateEnroute(route, departure.get(departure.size() - 1), approach.get(0), orientation);
            route.getPoints().addAll(approach);
        }
        if (route.isValid()) {
            allRoutes.add(route);
        }
        return route;
    }

    private Point getVertMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getY() - start.getY()));
        m.setY(start.getY() + d);
        return m;
    }

    private Point getHorzMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getX() - start.getX()));
        m.setX(start.getX() + d);
        return m;
    }

    protected List<Point> calculateDeparture(Shape source, Point start, Point end) {
        AnchorUtil.AnchorLocation sourceEdge = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)source, (Point)start).locationType;
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = GraphicsUtil.createPoint(start);
        Point m = end;
        switch (sourceEdge) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                while ((shape = this.getCollision(start, m = this.getVertMidpoint(start, m, 0.45))) != null && Math.abs(m.getY() - start.getY()) > 20) {
                }
                if (shape != null) {
                    if (sourceEdge == AnchorUtil.AnchorLocation.BOTTOM) {
                        m.setY(start.getY() + 20);
                    } else {
                        m.setY(start.getY() - 20);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                while ((shape = this.getCollision(start, m = this.getHorzMidpoint(start, m, 0.45))) != null && Math.abs(m.getX() - start.getX()) > 20) {
                }
                if (shape != null) {
                    if (sourceEdge == AnchorUtil.AnchorLocation.RIGHT) {
                        m.setX(start.getX() + 20);
                    } else {
                        m.setX(start.getX() - 20);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                return points;
            }
        }
        points.add(start);
        points.add(p);
        return points;
    }

    protected List<Point> calculateApproach(Point start, Shape target, Point end) {
        AnchorUtil.AnchorLocation targetEdge = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)target, (Point)end).locationType;
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = GraphicsUtil.createPoint(end);
        Point m = start;
        switch (targetEdge) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                while ((shape = this.getCollision(m = this.getVertMidpoint(m, end, 0.45), end)) != null && shape != target && Math.abs(m.getY() - end.getY()) > 20) {
                }
                if (shape != null) {
                    if (targetEdge == AnchorUtil.AnchorLocation.BOTTOM) {
                        m.setY(end.getY() + 20);
                    } else {
                        m.setY(end.getY() - 20);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                while ((shape = this.getCollision(m = this.getHorzMidpoint(m, end, 0.45), end)) != null && shape != target && Math.abs(m.getX() - end.getX()) > 20) {
                }
                if (shape != null) {
                    if (targetEdge == AnchorUtil.AnchorLocation.RIGHT) {
                        m.setX(end.getX() + 20);
                    } else {
                        m.setX(end.getX() - 20);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                points.add(p);
                return points;
            }
        }
        points.add(p);
        points.add(end);
        return points;
    }

    Point createPoint(int x, int y) {
        return GraphicsUtil.createPoint(x, y);
    }

    protected boolean calculateEnroute(ConnectionRoute route, Point start, Point end, Orientation orientation) {
        Point p;
        ContainerShape shape;
        if (GraphicsUtil.pointsEqual(start, end)) {
            return false;
        }
        if (!GraphicsUtil.isSlanted(start, end) && (shape = this.getCollision(start, end)) == null) {
            return true;
        }
        int dx = Math.abs(end.getX() - start.getX());
        int dy = Math.abs(end.getY() - start.getY());
        if (orientation == Orientation.NONE) {
            orientation = dx > dy ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        }
        if (orientation == Orientation.HORIZONTAL) {
            p = this.createPoint(end.getX(), start.getY());
            ContainerShape shape2 = this.getCollision(start, p);
            if (shape2 != null) {
                boolean detourUp;
                DetourPoints detour = this.getDetourPoints(shape2);
                boolean bl = detourUp = end.getY() - start.getY() < 0;
                if (p.getX() > start.getX()) {
                    p.setX(detour.topLeft.getX());
                    route.add(p);
                    if (detourUp) {
                        route.add(detour.topLeft);
                        route.add(detour.topRight);
                    } else {
                        route.add(detour.bottomLeft);
                        route.add(detour.bottomRight);
                    }
                } else {
                    p.setX(detour.topRight.getX());
                    route.add(p);
                    if (detourUp) {
                        route.add(detour.topRight);
                        route.add(detour.topLeft);
                    } else {
                        route.add(detour.bottomRight);
                        route.add(detour.bottomLeft);
                    }
                }
                p = route.get(route.size() - 1);
            } else {
                route.add(p);
            }
        } else {
            p = this.createPoint(start.getX(), end.getY());
            ContainerShape shape3 = this.getCollision(start, p);
            if (shape3 != null) {
                boolean detourLeft;
                DetourPoints detour = this.getDetourPoints(shape3);
                boolean bl = detourLeft = end.getX() - start.getX() < 0;
                if (p.getY() > start.getY()) {
                    p.setY(detour.topLeft.getY());
                    route.add(p);
                    if (detourLeft) {
                        route.add(detour.topLeft);
                        route.add(detour.bottomLeft);
                    } else {
                        route.add(detour.topRight);
                        route.add(detour.bottomRight);
                    }
                } else {
                    p.setY(detour.bottomLeft.getY());
                    route.add(p);
                    if (detourLeft) {
                        route.add(detour.bottomLeft);
                        route.add(detour.topLeft);
                    } else {
                        route.add(detour.bottomRight);
                        route.add(detour.topRight);
                    }
                }
                p = route.get(route.size() - 1);
            } else {
                route.add(p);
            }
        }
        if (route.isValid()) {
            if (!this.calculateEnroute(route, p, end, Orientation.NONE)) {
                return false;
            }
        } else {
            route.setValid();
            return false;
        }
        return route.isValid();
    }

    @Override
    protected DetourPoints getDetourPoints(ContainerShape shape) {
        DetourPoints detour = new DetourPoints(shape, 20);
        if (this.allShapes == null) {
            this.findAllShapes();
        }
        int i = 0;
        while (i < this.allShapes.size()) {
            DetourPoints d;
            ContainerShape s = (ContainerShape)this.allShapes.get(i);
            if (shape != s && detour.intersects(d = new DetourPoints(s, 20)) && !detour.contains(d)) {
                detour.merge(d);
                i = -1;
            }
            ++i;
        }
        return detour;
    }

    protected void finalizeConnection() {
    }

    protected boolean fixCollisions() {
        return false;
    }

    protected boolean calculateAnchors() {
        return false;
    }

    protected void updateConnection() {
        DIUtils.updateDIEdge((Connection)this.ffc);
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL,
        NONE;

    }
}

