/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DetourPoints {
    public int leftMargin = 10;
    public int rightMargin = 10;
    public int topMargin = 10;
    public int bottomMargin = 10;
    public Point topLeft;
    public Point topRight;
    public Point bottomLeft;
    public Point bottomRight;

    public DetourPoints(ContainerShape shape) {
        this.calculate((Shape)shape);
    }

    public DetourPoints(ContainerShape shape, int margin) {
        this(shape, margin, margin, margin, margin);
    }

    public DetourPoints(ContainerShape shape, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.calculate((Shape)shape);
    }

    protected void calculate(Shape shape) {
        ILocation loc = BendpointConnectionRouter.peService.getLocationRelativeToDiagram(shape);
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
        this.topLeft = GraphicsUtil.createPoint(loc.getX() - this.leftMargin, loc.getY() - this.topMargin);
        this.topRight = GraphicsUtil.createPoint(loc.getX() + size.getWidth() + this.rightMargin, loc.getY() - this.topMargin);
        this.bottomLeft = GraphicsUtil.createPoint(loc.getX() - this.leftMargin, loc.getY() + size.getHeight() + this.bottomMargin);
        this.bottomRight = GraphicsUtil.createPoint(loc.getX() + size.getWidth() + this.leftMargin, loc.getY() + size.getHeight() + this.bottomMargin);
    }

    public Point getNearest(Point p) {
        int d;
        Point nearest = this.topLeft;
        int dmin = (int)GraphicsUtil.getLength(p, this.topLeft);
        if (dmin == 0) {
            dmin = Integer.MAX_VALUE;
        }
        if ((d = (int)GraphicsUtil.getLength(p, this.topRight)) < dmin && d > 0) {
            dmin = d;
            nearest = this.topRight;
        }
        if ((d = (int)GraphicsUtil.getLength(p, this.bottomLeft)) < dmin && d > 0) {
            dmin = d;
            nearest = this.bottomLeft;
        }
        if ((d = (int)GraphicsUtil.getLength(p, this.bottomRight)) < dmin && d > 0) {
            dmin = d;
            nearest = this.bottomRight;
        }
        return nearest;
    }

    protected Point getDiagonal(Point p) {
        if (p == this.topLeft) {
            return this.bottomRight;
        }
        if (p == this.topRight) {
            return this.bottomLeft;
        }
        if (p == this.bottomLeft) {
            return this.topRight;
        }
        if (p == this.bottomRight) {
            return this.topLeft;
        }
        return null;
    }

    protected Point getHorzOpposite(Point p) {
        if (p == this.topLeft) {
            return this.topRight;
        }
        if (p == this.topRight) {
            return this.topLeft;
        }
        if (p == this.bottomLeft) {
            return this.bottomRight;
        }
        if (p == this.bottomRight) {
            return this.bottomLeft;
        }
        return null;
    }

    protected Point getVertOpposite(Point p) {
        if (p == this.topLeft) {
            return this.bottomLeft;
        }
        if (p == this.topRight) {
            return this.bottomRight;
        }
        if (p == this.bottomLeft) {
            return this.topLeft;
        }
        if (p == this.bottomRight) {
            return this.topRight;
        }
        return null;
    }

    protected boolean isTop(Point p) {
        return p == this.topLeft || p == this.topRight;
    }

    protected boolean isLeft(Point p) {
        return p == this.topLeft || p == this.bottomLeft;
    }

    protected int getSector(Point p) {
        int px = p.getX();
        int py = p.getY();
        int TLX = this.topLeft.getX();
        int TLY = this.topLeft.getY();
        int TRX = this.topRight.getX();
        int TRY = this.topRight.getY();
        int BLX = this.bottomLeft.getX();
        int BLY = this.bottomLeft.getY();
        int BRX = this.bottomRight.getX();
        int BRY = this.bottomRight.getY();
        if (px < TLX && py < TLY || px > TRX && py < TRY || px < BLX && py > BLY || px > BRX && py > BRY) {
            return 1;
        }
        if (px >= TLX && px <= TRX) {
            if (py <= TLY) {
                return 2;
            }
            if (py >= BLY) {
                return 3;
            }
        }
        int m = (BLY - TLY) / 2;
        if (TLY <= py && py <= TLY + m) {
            return 3;
        }
        if (TLY + m < py && py <= BLY) {
            return 2;
        }
        throw new IllegalArgumentException("Logic error in getSector()");
    }

    public List<Point> calculateDetour(Point p1, Point p2) {
        ArrayList<Point> detour = new ArrayList<Point>();
        Point np1 = this.getNearest(p1);
        Point np2 = this.getNearest(p2);
        if (np2 == np1) {
            detour.add(np1);
        } else if (np2 == this.getDiagonal(np1)) {
            int s1 = this.getSector(p1);
            int s2 = this.getSector(p2);
            if (s1 == 1) {
                if (s2 == 1) {
                    if (np1 == this.topLeft || np1 == this.bottomRight) {
                        double d2;
                        double d1 = GraphicsUtil.getLength(p1, this.topRight) + GraphicsUtil.getLength(this.topRight, p2);
                        if (d1 < (d2 = GraphicsUtil.getLength(p1, this.bottomLeft) + GraphicsUtil.getLength(this.bottomLeft, p2))) {
                            detour.add(this.topRight);
                        } else {
                            detour.add(this.bottomLeft);
                        }
                    } else {
                        double d2;
                        double d1 = GraphicsUtil.getLength(p1, this.topLeft) + GraphicsUtil.getLength(this.topLeft, p2);
                        if (d1 < (d2 = GraphicsUtil.getLength(p1, this.bottomRight) + GraphicsUtil.getLength(this.bottomRight, p2))) {
                            detour.add(this.topLeft);
                        } else {
                            detour.add(this.bottomRight);
                        }
                    }
                } else if (s2 == 2) {
                    if (np1 == this.topLeft || np1 == this.bottomRight) {
                        detour.add(this.topRight);
                    } else {
                        detour.add(this.topLeft);
                    }
                } else if (np1 == this.topLeft || np1 == this.bottomRight) {
                    detour.add(this.bottomLeft);
                } else {
                    detour.add(this.bottomRight);
                }
            } else if (s1 == 2) {
                if (s2 == 1) {
                    if (np1 == this.topLeft || np1 == this.bottomRight) {
                        detour.add(this.topRight);
                    } else {
                        detour.add(this.topLeft);
                    }
                } else if (s2 == 2) {
                    if (np1 == this.topLeft || np1 == this.bottomRight) {
                        detour.add(this.topRight);
                    } else {
                        detour.add(this.topLeft);
                    }
                } else if (np1 == this.topLeft) {
                    detour.add(this.topRight);
                    detour.add(this.bottomRight);
                } else if (np1 == this.topRight) {
                    detour.add(this.topRight);
                    detour.add(this.bottomRight);
                } else if (np1 == this.bottomRight) {
                    detour.add(this.topRight);
                    detour.add(this.topLeft);
                } else {
                    detour.add(this.topLeft);
                    detour.add(this.topRight);
                }
            } else if (s2 == 1) {
                if (np1 == this.topLeft || np1 == this.bottomRight) {
                    detour.add(this.bottomLeft);
                } else {
                    detour.add(this.bottomRight);
                }
            } else if (s2 == 2) {
                if (np1 == this.topLeft) {
                    detour.add(this.topLeft);
                    detour.add(this.topRight);
                } else if (np1 == this.topRight) {
                    detour.add(this.topRight);
                    detour.add(this.topLeft);
                } else if (np1 == this.bottomRight) {
                    detour.add(this.topRight);
                    detour.add(this.topLeft);
                } else {
                    detour.add(this.bottomLeft);
                    detour.add(this.topLeft);
                }
            } else if (np1 == this.topLeft || np1 == this.bottomRight) {
                detour.add(this.bottomLeft);
            } else {
                detour.add(this.bottomRight);
            }
        } else if (np2 == this.getHorzOpposite(np1)) {
            if (this.isTop(np2)) {
                if (p1.getY() > this.topLeft.getY() && p2.getY() > this.topLeft.getY()) {
                    detour.add(np1);
                    detour.add(np2);
                } else if (p1.getY() > this.topLeft.getY()) {
                    detour.add(np1);
                } else {
                    detour.add(np2);
                }
            } else if (p1.getY() < this.bottomLeft.getY() && p2.getY() < this.bottomLeft.getY()) {
                detour.add(np1);
                detour.add(np2);
            } else if (p1.getY() < this.bottomLeft.getY()) {
                detour.add(np1);
            } else {
                detour.add(np2);
            }
        } else if (np2 == this.getVertOpposite(np1)) {
            if (this.isLeft(np2)) {
                if (p1.getX() > this.topLeft.getX() && p2.getX() > this.topLeft.getX()) {
                    detour.add(np1);
                    detour.add(np2);
                } else if (p1.getX() > this.topLeft.getX()) {
                    detour.add(np1);
                } else {
                    detour.add(np2);
                }
            } else if (p1.getX() < this.topRight.getX() && p2.getX() < this.topRight.getX()) {
                detour.add(np1);
                detour.add(np2);
            } else if (p1.getX() < this.topRight.getX()) {
                detour.add(np1);
            } else {
                detour.add(np2);
            }
        }
        return detour;
    }

    public boolean intersects(DetourPoints d2) {
        return GraphicsUtil.intersects(this.topLeft.getX(), this.topLeft.getY(), this.topRight.getX() - this.topLeft.getX(), this.bottomLeft.getY() - this.topLeft.getY(), d2.topLeft.getX(), d2.topLeft.getY(), d2.topRight.getX() - d2.topLeft.getX(), d2.bottomLeft.getY() - d2.topLeft.getY());
    }

    public boolean contains(DetourPoints d2) {
        return this.topLeft.getX() <= d2.topLeft.getX() && this.topRight.getX() >= d2.topRight.getX() && this.topLeft.getY() <= d2.topLeft.getY() && this.bottomLeft.getY() >= d2.bottomLeft.getY();
    }

    public void merge(DetourPoints d2) {
        this.topLeft.setX(Math.min(this.topLeft.getX(), d2.topLeft.getX()));
        this.topLeft.setY(Math.min(this.topLeft.getY(), d2.topLeft.getY()));
        this.topRight.setX(Math.max(this.topRight.getX(), d2.topRight.getX()));
        this.topRight.setY(Math.min(this.topRight.getY(), d2.topRight.getY()));
        this.bottomLeft.setX(Math.min(this.bottomLeft.getX(), d2.bottomLeft.getX()));
        this.bottomLeft.setY(Math.max(this.bottomLeft.getY(), d2.bottomLeft.getY()));
        this.bottomRight.setX(Math.max(this.bottomRight.getX(), d2.bottomRight.getX()));
        this.bottomRight.setY(Math.max(this.bottomRight.getY(), d2.bottomRight.getY()));
    }
}

