/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DefaultResizeBPMNShapeFeature
extends DefaultResizeShapeFeature {
    public DefaultResizeBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        Shape shape = null;
        if (context.getPictogramElement() instanceof Shape) {
            shape = (Shape)context.getPictogramElement();
        }
        super.resizeShape(context);
        if (shape != null) {
            AnchorUtil.relocateFixPointAnchors(shape, context.getWidth(), context.getHeight());
        }
        DIUtils.updateDIShape(context.getPictogramElement());
        FeatureSupport.updateConnections(this.getFeatureProvider(), (AnchorContainer)shape);
        for (Connection connection : this.getDiagram().getConnections()) {
            if (!GraphicsUtil.intersects(shape, connection)) continue;
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
        }
        FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)shape);
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
            for (Connection c : a.getOutgoingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
        }
    }
}

