/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;

public class DefaultDeleteBPMNShapeFeature
extends DefaultDeleteFeature {
    public DefaultDeleteBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected boolean getUserDecision(IDeleteContext context) {
        return true;
    }

    public boolean canDelete(IDeleteContext context) {
        return !(context.getPictogramElement() instanceof Diagram);
    }

    protected void deleteBusinessObject(Object bo) {
        Object v;
        EStructuralFeature reference = ((EObject)bo).eClass().getEStructuralFeature("categoryValueRef");
        if (reference != null && (v = ((EObject)bo).eGet(reference)) instanceof EList) {
            ((EList)v).clear();
        }
        List pictElements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)bo);
        for (PictogramElement pe : pictElements) {
            this.deletePeEnvironment(pe);
            Graphiti.getPeService().deletePictogramElement(pe);
        }
        super.deleteBusinessObject(bo);
    }

    protected void deletePeEnvironment(PictogramElement pictogramElement) {
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cShape = (ContainerShape)pictogramElement;
            EList anchors = cShape.getAnchors();
            for (Anchor anchor : anchors) {
                this.deleteConnections(this.getFeatureProvider(), (EList<Connection>)anchor.getIncomingConnections());
                this.deleteConnections(this.getFeatureProvider(), (EList<Connection>)anchor.getOutgoingConnections());
            }
            this.deleteContainer(this.getFeatureProvider(), cShape);
        }
    }

    protected void deleteContainer(IFeatureProvider fp, ContainerShape cShape) {
        Object[] children;
        Object[] objectArray = children = cShape.getChildren().toArray();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object shape = objectArray[n2];
            if (shape instanceof ContainerShape) {
                DeleteContext context = new DeleteContext((PictogramElement)shape);
                fp.getDeleteFeature((IDeleteContext)context).delete((IDeleteContext)context);
            }
            ++n2;
        }
    }

    protected void deleteConnections(IFeatureProvider fp, EList<Connection> connections) {
        ArrayList<Connection> con = new ArrayList<Connection>();
        con.addAll((Collection<Connection>)connections);
        for (Connection connection : con) {
            DeleteContext conDelete = new DeleteContext((PictogramElement)connection);
            fp.getDeleteFeature((IDeleteContext)conDelete).delete((IDeleteContext)conDelete);
        }
    }
}

