/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractUpdateBaseElementFeature
extends AbstractUpdateFeature {
    public AbstractUpdateBaseElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IReason updateNeeded(final IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            boolean updateNeeded;
            String businessValue;
            String shapeValue = FeatureSupport.getShapeValue((IPictogramElementContext)context);
            if (shapeValue == null) {
                shapeValue = "";
            }
            if ((businessValue = FeatureSupport.getBusinessValue((IPictogramElementContext)context)) == null) {
                businessValue = "";
            }
            boolean bl = updateNeeded = !shapeValue.equals(businessValue);
            if (updateNeeded) {
                final boolean[] result = new boolean[1];
                TransactionalEditingDomain domain = this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        result[0] = AbstractUpdateBaseElementFeature.this.update(context);
                    }
                });
                if (!result[0]) {
                    return Reason.createTrueReason((String)Messages.AbstractUpdateBaseElementFeature_Name);
                }
            }
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pe;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                AbstractText text = (AbstractText)shape.getGraphicsAlgorithm();
                String value = FeatureSupport.getBusinessValue((IPictogramElementContext)context);
                if (value == null) {
                    value = "";
                }
                text.setValue(value);
                return true;
            }
        }
        return false;
    }
}

