/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.io.IOException;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;

public abstract class AbstractBpmn2AddElementFeature<T extends BaseElement>
extends AbstractBpmn2AddFeature<T> {
    public AbstractBpmn2AddElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected BPMNShape findDIShape(BaseElement elem) {
        try {
            return DIUtils.findBPMNShape(elem);
        }
        catch (Exception e) {
            Activator.logError(e);
            return null;
        }
    }

    protected BPMNShape createDIShape(Shape gShape, BaseElement elem, boolean applyDefaults) {
        return this.createDIShape(gShape, elem, this.findDIShape(elem), applyDefaults);
    }

    protected BPMNShape createDIShape(Shape shape, BaseElement elem, BPMNShape bpmnShape, boolean applyDefaults) {
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(shape);
        if (bpmnShape == null) {
            int x = loc.getX();
            int y = loc.getY();
            int w = shape.getGraphicsAlgorithm().getWidth();
            int h = shape.getGraphicsAlgorithm().getHeight();
            bpmnShape = DIUtils.createDIShape(shape, elem, x, y, w, h, this.getFeatureProvider(), this.getDiagram());
        } else {
            this.link((PictogramElement)shape, new Object[]{elem, bpmnShape});
        }
        if (applyDefaults && bpmnShape != null) {
            Bpmn2Preferences.getInstance(bpmnShape.eResource()).applyBPMNDIDefaults(bpmnShape, null);
        }
        return bpmnShape;
    }

    protected BPMNEdge createDIEdge(Connection connection, BaseElement conElement) {
        try {
            BPMNEdge edge = DIUtils.findBPMNEdge((EObject)conElement);
            return this.createDIEdge(connection, conElement, edge);
        }
        catch (IOException e) {
            Activator.logError(e);
            return null;
        }
    }

    protected BPMNEdge createDIEdge(Connection connection, BaseElement conElement, BPMNEdge edge) throws IOException {
        if (edge == null) {
            EList businessObjects = Graphiti.getLinkService().getLinkForPictogramElement((PictogramElement)this.getDiagram()).getBusinessObjects();
            for (EObject eObject : businessObjects) {
                if (!(eObject instanceof BPMNDiagram)) continue;
                BPMNDiagram bpmnDiagram = (BPMNDiagram)eObject;
                edge = BpmnDiFactory.eINSTANCE.createBPMNEdge();
                edge.setBpmnElement(conElement);
                if (conElement instanceof Association) {
                    edge.setSourceElement(DIUtils.findDiagramElement((EObject)((Association)conElement).getSourceRef()));
                    edge.setTargetElement(DIUtils.findDiagramElement((EObject)((Association)conElement).getTargetRef()));
                } else if (conElement instanceof MessageFlow) {
                    edge.setSourceElement(DIUtils.findDiagramElement((EObject)((BaseElement)((MessageFlow)conElement).getSourceRef())));
                    edge.setTargetElement(DIUtils.findDiagramElement((EObject)((BaseElement)((MessageFlow)conElement).getTargetRef())));
                } else if (conElement instanceof SequenceFlow) {
                    edge.setSourceElement(DIUtils.findDiagramElement((EObject)((SequenceFlow)conElement).getSourceRef()));
                    edge.setTargetElement(DIUtils.findDiagramElement((EObject)((SequenceFlow)conElement).getTargetRef()));
                }
                ILocation sourceLoc = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getStart());
                ILocation targetLoc = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getEnd());
                Point point = DcFactory.eINSTANCE.createPoint();
                point.setX((float)sourceLoc.getX());
                point.setY((float)sourceLoc.getY());
                edge.getWaypoint().add(point);
                point = DcFactory.eINSTANCE.createPoint();
                point.setX((float)targetLoc.getX());
                point.setY((float)targetLoc.getY());
                edge.getWaypoint().add(point);
                DIUtils.addShape((DiagramElement)edge, bpmnDiagram);
                ModelUtil.setID((EObject)edge);
            }
        }
        this.link((PictogramElement)connection, new Object[]{conElement, edge});
        return edge;
    }

    protected void prepareAddContext(IAddContext context, PictogramElement labelOwner, int width, int height) {
        context.putProperty((Object)"labelContext", (Object)true);
        context.putProperty((Object)"width", (Object)width);
        context.putProperty((Object)"height", (Object)height);
        context.putProperty((Object)"businessObject", this.getBusinessObject(context));
        context.putProperty((Object)"labelOwner", (Object)labelOwner);
    }

    protected void adjustLocation(IAddContext context, int width, int height) {
        if (context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null) {
            return;
        }
        int x = context.getX();
        int y = context.getY();
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        ((AddContext)context).setY(y -= height / 2);
        ((AddContext)context).setX(x -= width / 2);
    }

    protected void splitConnection(IAddContext context, ContainerShape containerShape) {
        if (context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null) {
            return;
        }
        T newObject = this.getBusinessObject(context);
        Connection connection = context.getTargetConnection();
        if (connection != null) {
            ReconnectionContext rc;
            FixPointAnchor anchor;
            ILayoutService layoutService = Graphiti.getLayoutService();
            Anchor a0 = connection.getStart();
            Anchor a1 = connection.getEnd();
            double x0 = layoutService.getLocationRelativeToDiagram(a0).getX();
            double y0 = layoutService.getLocationRelativeToDiagram(a0).getY();
            double x1 = layoutService.getLocationRelativeToDiagram(a1).getX();
            double y1 = layoutService.getLocationRelativeToDiagram(a1).getY();
            double dx = x0 - (double)context.getX();
            double dy = y0 - (double)context.getY();
            double len0 = Math.sqrt(dx * dx + dy * dy);
            dx = (double)context.getX() - x1;
            dy = (double)context.getY() - y1;
            double len1 = Math.sqrt(dx * dx + dy * dy);
            AnchorContainer oldSourceContainer = connection.getStart().getParent();
            AnchorContainer oldTargetContainer = connection.getEnd().getParent();
            BaseElement baseElement = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            ILocation targetLocation = layoutService.getLocationRelativeToDiagram((Shape)containerShape);
            if (newObject instanceof StartEvent || len0 < len1 && !(newObject instanceof EndEvent)) {
                anchor = AnchorUtil.findNearestAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                rc = new ReconnectionContext(connection, connection.getStart(), (Anchor)anchor, targetLocation);
                rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                rc.setTargetPictogramElement((PictogramElement)containerShape);
            } else {
                anchor = AnchorUtil.findNearestAnchor(oldTargetContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                rc = new ReconnectionContext(connection, connection.getEnd(), (Anchor)anchor, targetLocation);
                rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                rc.setTargetPictogramElement((PictogramElement)containerShape);
            }
            IReconnectionFeature rf = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)rc);
            rf.reconnect((IReconnectionContext)rc);
            if (!(newObject instanceof EndEvent) && !(newObject instanceof StartEvent)) {
                CreateConnectionContext ccc = new CreateConnectionContext();
                if (len0 < len1) {
                    ccc.setSourcePictogramElement((PictogramElement)oldSourceContainer);
                    ccc.setTargetPictogramElement((PictogramElement)containerShape);
                    anchor = AnchorUtil.findNearestAnchor(oldSourceContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                    ccc.setSourceAnchor((Anchor)anchor);
                    anchor = AnchorUtil.findNearestAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                    ccc.setTargetAnchor((Anchor)anchor);
                } else {
                    ccc.setSourcePictogramElement((PictogramElement)containerShape);
                    ccc.setTargetPictogramElement((PictogramElement)oldTargetContainer);
                    anchor = AnchorUtil.findNearestAnchor((AnchorContainer)containerShape, GraphicsUtil.getShapeCenter(oldTargetContainer));
                    ccc.setSourceAnchor((Anchor)anchor);
                    anchor = AnchorUtil.findNearestAnchor(oldTargetContainer, GraphicsUtil.getShapeCenter((AnchorContainer)containerShape));
                    ccc.setTargetAnchor((Anchor)anchor);
                }
                Connection newConnection = null;
                ICreateConnectionFeature[] iCreateConnectionFeatureArray = this.getFeatureProvider().getCreateConnectionFeatures();
                int n = iCreateConnectionFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCreateFlowFeature acf;
                    ICreateConnectionFeature cf = iCreateConnectionFeatureArray[n2];
                    if (cf instanceof AbstractCreateFlowFeature && (acf = (AbstractCreateFlowFeature)cf).getBusinessObjectClass().isInstance((Object)baseElement)) {
                        newConnection = acf.create((ICreateConnectionContext)ccc);
                        DIUtils.updateDIEdge(newConnection);
                        break;
                    }
                    ++n2;
                }
            }
            DIUtils.updateDIEdge(connection);
        }
    }

    protected int getHeight(IAddContext context) {
        Bounds b;
        Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
        if (copiedBpmnShape instanceof BPMNShape && (b = ((BPMNShape)copiedBpmnShape).getBounds()) != null) {
            return (int)b.getHeight();
        }
        return context.getHeight() > 0 ? context.getHeight() : (this.isHorizontal((ITargetContext)context) ? this.getHeight() : this.getWidth());
    }

    protected int getWidth(IAddContext context) {
        Bounds b;
        Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
        if (copiedBpmnShape instanceof BPMNShape && (b = ((BPMNShape)copiedBpmnShape).getBounds()) != null) {
            return (int)b.getWidth();
        }
        return context.getWidth() > 0 ? context.getWidth() : (this.isHorizontal((ITargetContext)context) ? this.getWidth() : this.getHeight());
    }

    protected boolean isHorizontal(ITargetContext context) {
        if (context.getProperty((Object)DIImport.IMPORT_PROPERTY) == null) {
            Lane targetLane;
            BPMNShape laneShape;
            Object copiedBpmnShape = context.getProperty((Object)"copied.bpmn.shape");
            if (copiedBpmnShape instanceof BPMNShape) {
                return ((BPMNShape)copiedBpmnShape).isIsHorizontal();
            }
            if (FeatureSupport.isTargetParticipant(context)) {
                Participant targetParticipant = FeatureSupport.getTargetParticipant(context);
                BPMNShape participantShape = this.findDIShape((BaseElement)targetParticipant);
                if (participantShape != null) {
                    return participantShape.isIsHorizontal();
                }
            } else if (FeatureSupport.isTargetLane(context) && (laneShape = this.findDIShape((BaseElement)(targetLane = FeatureSupport.getTargetLane(context)))) != null) {
                return laneShape.isIsHorizontal();
            }
        }
        return Bpmn2Preferences.getInstance((EObject)context.getTargetContainer()).isHorizontalDefault();
    }

    public abstract int getHeight();

    public abstract int getWidth();

    @Override
    public T getBusinessObject(IAddContext context) {
        Object businessObject = context.getProperty((Object)"businessObject");
        if (businessObject instanceof BaseElement) {
            return (T)((BaseElement)businessObject);
        }
        return (T)((BaseElement)context.getNewObject());
    }

    @Override
    public void putBusinessObject(IAddContext context, T businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
    }
}

