/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.Messages;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListDialog;

public class ImportDiagnostics
implements IStructuredContentProvider,
ILabelProvider {
    private Resource resource;
    private TargetRuntime runtime;
    private List<ImportDiagnostic> entries;

    public ImportDiagnostics(Resource resource) {
        this.resource = resource;
        this.runtime = TargetRuntime.getCurrentRuntime();
    }

    public void add(int severity, EObject element, String message) {
        if (this.entries == null) {
            this.entries = new ArrayList<ImportDiagnostic>();
        }
        this.entries.add(new ImportDiagnostic(severity, element, message));
    }

    public List<ImportDiagnostic> get(EObject element) {
        if (this.entries != null) {
            ArrayList<ImportDiagnostic> list = new ArrayList<ImportDiagnostic>();
            for (ImportDiagnostic d : this.entries) {
                if (d.element != element) continue;
                list.add(d);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return null;
    }

    public void report() {
        if (this.entries != null) {
            ListDialog dlg = new ListDialog(Display.getDefault().getActiveShell());
            dlg.setContentProvider((IStructuredContentProvider)this);
            dlg.setLabelProvider((ILabelProvider)this);
            for (ImportDiagnostic d : this.entries) {
                Activator.logStatus((IStatus)new Status(d.severity, "org.eclipse.bpmn2.modeler.core", this.getText(d)));
            }
            dlg.setInput(this.entries);
            dlg.setMessage(Messages.ImportDiagnostics_Message);
            dlg.setAddCancelButton(false);
            dlg.setTitle(Messages.ImportDiagnostics_Title);
            dlg.open();
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        ImportDiagnostic d = (ImportDiagnostic)element;
        String text = "";
        if (d.element == null) {
            return d.message;
        }
        text = this.getText(d.element);
        text = String.valueOf(text) + ": " + d.message;
        return text;
    }

    public String getText(EObject element) {
        String text = "";
        String type = "";
        String id = "";
        String name = "";
        String customTaskId = "";
        if (this.runtime != null) {
            for (CustomTaskDescriptor tc : this.runtime.getCustomTasks()) {
                customTaskId = tc.getFeatureContainer().getId(element);
                if (customTaskId != null) continue;
                customTaskId = "";
            }
        }
        type = element.eClass().getName();
        EStructuralFeature f = element.eClass().getEStructuralFeature("id");
        if (f != null && (id = (String)element.eGet(f)) == null) {
            id = "";
        }
        if (id.isEmpty()) {
            id = "unknown";
        }
        if ((f = element.eClass().getEStructuralFeature("name")) != null && (name = (String)element.eGet(f)) == null) {
            name = "";
        }
        text = !customTaskId.isEmpty() ? String.valueOf(type) + " Custom Task " + customTaskId : type;
        text = name.isEmpty() ? String.valueOf(text) + " id=\"" + id + "\"" : String.valueOf(text) + " \"" + name + "\"";
        return text;
    }

    public Object[] getElements(Object inputElement) {
        return this.entries.toArray();
    }

    private static class ImportDiagnostic {
        public EObject element;
        public String message;
        public int severity;

        public ImportDiagnostic(int severity, EObject element, String message) {
            this.severity = severity;
            this.element = element;
            this.message = message;
        }
    }
}

