/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public class ObjectDescriptor<T extends EObject> {
    protected T object;
    protected String label;
    protected String name;
    protected AdapterFactory adapterFactory;

    public ObjectDescriptor(AdapterFactory adapterFactory, T object) {
        this.object = object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel(Object context) {
        EClass eclass;
        Object object = context instanceof EObject ? (EObject)context : this.object;
        EClass eClass = eclass = object instanceof EClass ? (EClass)object : object.eClass();
        if (this.label == null) {
            this.label = ModelUtil.toDisplayName(eclass.getName());
        }
        return this.label;
    }

    public void setDisplayName(String name) {
        this.name = name;
    }

    public String getDisplayName(Object context) {
        if (this.name == null) {
            T object = this.adopt(context);
            String text = ModelUtil.toDisplayName(object.eClass().getName());
            Object value = null;
            EStructuralFeature f = null;
            f = object.eClass().getEStructuralFeature("name");
            if (f != null && ((value = object.eGet(f)) == null || value.toString().isEmpty())) {
                value = null;
            }
            if (value == null && (f = object.eClass().getEStructuralFeature("id")) != null && ((value = object.eGet(f)) == null || value.toString().isEmpty())) {
                value = null;
            }
            if (value == null) {
                value = NLS.bind((String)Messages.ObjectDescriptor_Unnamed, (Object)text);
            }
            return (String)value;
        }
        return this.name;
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(EStructuralFeature feature) {
        return this.getPropertyDescriptor(this.object, feature);
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(T object, EStructuralFeature feature) {
        ItemProviderAdapter adapter = null;
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ItemProviderAdapter)) continue;
            adapter = (ItemProviderAdapter)a;
            break;
        }
        if (adapter != null) {
            return adapter.getPropertyDescriptor(object, (Object)feature);
        }
        return null;
    }

    protected EObject clone(T oldObject) {
        EObject newObject = null;
        if (oldObject != null) {
            EClass eClass = oldObject.eClass();
            newObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
            for (EStructuralFeature f : eClass.getEAllAttributes()) {
                newObject.eSet(f, oldObject.eGet(f));
            }
        }
        return newObject;
    }

    public boolean equals(Object otherObject) {
        T thisObject = this.object;
        if (otherObject instanceof EObject) {
            return ObjectDescriptor.compare(thisObject, (EObject)otherObject, false);
        }
        return super.equals(otherObject);
    }

    public boolean similar(Object otherObject) {
        T thisObject = this.object;
        if (otherObject instanceof EObject) {
            return ObjectDescriptor.compare(thisObject, (EObject)otherObject, true);
        }
        return super.equals(otherObject);
    }

    public static boolean compare(EObject thisObject, EObject otherObject, boolean similar) {
        for (EStructuralFeature f : thisObject.eClass().getEAllStructuralFeatures()) {
            ExtendedPropertiesAdapter adapter;
            if (similar && "id".equals(f.getName())) continue;
            Object v1 = otherObject.eGet(f);
            Object v2 = thisObject.eGet(f);
            if (v1 == null && v2 == null) continue;
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            if (ModelUtil.isStringWrapper(v1) && ModelUtil.isStringWrapper(v2)) {
                v1 = ModelUtil.getStringWrapperValue(v1);
                v2 = ModelUtil.getStringWrapperValue(v2);
                if (v1 == null && v2 == null) continue;
                if (v1 == null || v2 == null) {
                    return false;
                }
                if (v1.equals(v2)) {
                    continue;
                }
            } else if (v1 instanceof EObject && v2 instanceof EObject && (adapter = ExtendedPropertiesAdapter.adapt((EObject)v1)) != null) {
                adapter.getObjectDescriptor();
                if (ObjectDescriptor.compare((EObject)v1, (EObject)v2, similar)) continue;
            }
            return false;
        }
        return true;
    }

    protected T adopt(Object context) {
        Object result = this.object.getClass().isInstance(context) ? (EObject)context : this.object;
        return (T)result;
    }

    public TransactionalEditingDomain getEditingDomain(Object context) {
        T object = this.adopt(context);
        EditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor(object);
        if (result == null) {
            ComposeableAdapterFactory rootAdapterFactory;
            if (this.adapterFactory instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)this.adapterFactory).getEditingDomain();
            }
            if (result == null && this.adapterFactory instanceof ComposeableAdapterFactory && (rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)rootAdapterFactory).getEditingDomain();
            }
        }
        if (result instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)result;
        }
        return null;
    }

    public T createObject(Object context) {
        return this.createObject(null, context);
    }

    public T createObject(Resource resource, Object context) {
        EClass eClass = null;
        if (context instanceof EClass) {
            eClass = (EClass)context;
        } else if (context instanceof EObject) {
            eClass = ((EObject)context).eClass();
            if (resource == null) {
                resource = ((EObject)context).eResource();
            }
        } else {
            eClass = this.object.eClass();
        }
        Assert.isTrue((boolean)this.object.eClass().isSuperTypeOf(eClass));
        EObject newObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (resource == null) {
            resource = this.object.eResource();
        }
        String id = ModelUtil.setID(newObject, resource);
        EStructuralFeature feature = newObject.eClass().getEStructuralFeature("name");
        if (feature != null && !newObject.eIsSet(feature)) {
            if (id != null) {
                newObject.eSet(feature, (Object)ModelUtil.toDisplayName(id));
            } else {
                String name = ModelUtil.toDisplayName(newObject.eClass().getName());
                newObject.eSet(feature, (Object)NLS.bind((String)Messages.ObjectDescriptor_New, (Object)name));
            }
        }
        return (T)newObject;
    }
}

