/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.lang.reflect.Field;
import java.util.Hashtable;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.JavaReflectionUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExtendedPropertiesAdapter<T extends EObject>
extends AdapterImpl {
    public static final String LONG_DESCRIPTION = "long.description";
    public static final String CUSTOM_DESCRIPTION = "custom.description";
    public static final String UI_CAN_EDIT = "ui.can.edit";
    public static final String UI_CAN_EDIT_INLINE = "ui.can.edit.inline";
    public static final String UI_CAN_CREATE_NEW = "ui.can.create.new";
    public static final String UI_CAN_SET_NULL = "ui.can.set.null";
    public static final String UI_IS_MULTI_CHOICE = "ui.is.multi.choice";
    public static final String PROPERTY_DESCRIPTOR = "property.descriptor";
    public static final String LINE_NUMBER = "line.number";
    protected static Hashtable<EClass, EObject> dummyObjects = new Hashtable();
    protected Hashtable<EStructuralFeature, Hashtable<String, Object>> featureProperties = new Hashtable();
    protected Hashtable<String, Object> objectProperties = new Hashtable();
    protected AdapterFactory adapterFactory;

    public ExtendedPropertiesAdapter(AdapterFactory adapterFactory, T object) {
        this.adapterFactory = adapterFactory;
        this.setTarget((Notifier)object);
    }

    public static ExtendedPropertiesAdapter adapt(Object object) {
        return ExtendedPropertiesAdapter.adapt(object, null);
    }

    public static ExtendedPropertiesAdapter adapt(Object object, EStructuralFeature feature) {
        ExtendedPropertiesAdapter adapter = null;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            ExtendedPropertiesAdapter genericAdapter = null;
            for (Adapter a : eObject.eAdapters()) {
                if (!(a instanceof ExtendedPropertiesAdapter) || !((ExtendedPropertiesAdapter)a).canAdapt(eObject, feature)) continue;
                if (a.getClass() == ExtendedPropertiesAdapter.class) {
                    genericAdapter = (ExtendedPropertiesAdapter)a;
                    continue;
                }
                adapter = (ExtendedPropertiesAdapter)a;
            }
            if (adapter == null && genericAdapter != null) {
                adapter = genericAdapter;
            }
            EObject eclass = ExtendedPropertiesAdapter.getFeatureClass(eObject, feature);
            if (adapter == null) {
                adapter = AdapterUtil.adapt((Object)eclass, ExtendedPropertiesAdapter.class);
            }
            if (adapter != null) {
                EObject dummy;
                if (eObject instanceof EClass && (dummy = ExtendedPropertiesAdapter.getDummyObject((EClass)eObject)) != null) {
                    eObject = dummy;
                }
                adapter.setTarget((Notifier)eObject);
                adapter.getObjectDescriptor().setObject(eObject);
                if (feature != null) {
                    adapter.getFeatureDescriptor(feature).setObject(eObject);
                }
                adapter.initializeDescription();
            }
        }
        return adapter;
    }

    public static EObject getDummyObject(EClass eclass) {
        EObject object = dummyObjects.get(eclass);
        if (object == null && eclass.eContainer() instanceof EPackage && !eclass.isAbstract()) {
            EPackage pkg = (EPackage)eclass.eContainer();
            object = pkg.getEFactoryInstance().create(eclass);
            dummyObjects.put(eclass, object);
        }
        return object;
    }

    public void setObjectDescriptor(ObjectDescriptor<T> pd) {
        this.setProperty(PROPERTY_DESCRIPTOR, pd);
    }

    private static EObject getFeatureClass(EObject object, EStructuralFeature feature) {
        EClass eclass = null;
        if (feature != null && feature.eContainer() instanceof EClass) {
            eclass = (EClass)feature.eContainer();
        }
        if (eclass == null || eclass.isAbstract()) {
            return object;
        }
        return eclass;
    }

    public ObjectDescriptor<T> getObjectDescriptor() {
        ObjectDescriptor<EObject> pd = (ObjectDescriptor<EObject>)this.getProperty(PROPERTY_DESCRIPTOR);
        if (pd == null) {
            pd = new ObjectDescriptor<EObject>(this.adapterFactory, (EObject)this.getTarget());
            this.setProperty(PROPERTY_DESCRIPTOR, pd);
        }
        return pd;
    }

    public FeatureDescriptor<T> getFeatureDescriptor(EStructuralFeature feature) {
        FeatureDescriptor<EObject> pd = (FeatureDescriptor<EObject>)this.getProperty(feature, PROPERTY_DESCRIPTOR);
        if (pd == null) {
            pd = new FeatureDescriptor<EObject>(this.adapterFactory, (EObject)this.getTarget(), feature);
            this.setProperty(feature, PROPERTY_DESCRIPTOR, pd);
        }
        return pd;
    }

    public void setFeatureDescriptor(EStructuralFeature feature, FeatureDescriptor<T> pd) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        props.put(PROPERTY_DESCRIPTOR, pd);
    }

    public Object getProperty(String key) {
        return this.objectProperties.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Object result = this.getProperty(key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public void setProperty(String key, Object value) {
        this.objectProperties.put(key, value);
    }

    public Object getProperty(EStructuralFeature feature, String key) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        return props.get(key);
    }

    public boolean getBooleanProperty(EStructuralFeature feature, String key) {
        Object result = this.getProperty(feature, key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public void setProperty(EStructuralFeature feature, String key, Object value) {
        Hashtable<String, Object> props = this.featureProperties.get(feature);
        if (props == null) {
            props = new Hashtable();
            this.featureProperties.put(feature, props);
        }
        props.put(key, value);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget instanceof EObject && !(newTarget instanceof EClass)) {
            EObject object = (EObject)newTarget;
            for (Adapter a : object.eAdapters()) {
                if (!(a instanceof ExtendedPropertiesAdapter)) continue;
                return;
            }
            object.eAdapters().add((Object)this);
        }
    }

    public boolean canAdapt(EObject object, EStructuralFeature feature) {
        if (object != null && this.getObjectDescriptor().object.eClass() == object.eClass()) {
            if (feature == null) {
                return true;
            }
            Hashtable<String, Object> props = this.featureProperties.get(feature);
            if (props != null) {
                return true;
            }
        }
        return false;
    }

    protected String initializeDescription() {
        Participant participant;
        EObject container;
        EObject object = (EObject)this.target;
        String name = "";
        String description = "";
        if (object instanceof BPMNDiagram) {
            switch (ModelUtil.getDiagramType(object)) {
                case NONE: {
                    name = "UnknownDiagram";
                    break;
                }
                case PROCESS: {
                    name = "Process";
                    break;
                }
                case CHOREOGRAPHY: {
                    name = "Choreography";
                    break;
                }
                case COLLABORATION: {
                    name = "Collaboration";
                }
            }
        } else if (object instanceof Participant && (container = (participant = (Participant)this.target).eContainer()) instanceof Choreography) {
            for (FlowElement fe : ((Choreography)container).getFlowElements()) {
                ChoreographyActivity ca;
                if (!(fe instanceof ChoreographyActivity) || !(ca = (ChoreographyActivity)fe).getParticipantRefs().contains(participant)) continue;
                name = "ParticipantBand";
                break;
            }
        }
        if (name.isEmpty()) {
            name = object.eClass().getName().replaceAll("Impl$", "");
        }
        try {
            String fieldName = "UI_" + name + "_long_description";
            Class messages = JavaReflectionUtil.findClass(this.adapterFactory, "Messages");
            Field field = messages.getField(fieldName);
            description = (String)field.get(null);
            this.setProperty(LONG_DESCRIPTION, description);
        }
        catch (Exception exception) {}
        return description;
    }
}

