/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class AddModuleToServerCommand
extends AbstractDataModelOperation {
    private String serverInstanceId;
    private String moduleProjectName = null;
    private String earProjectName = null;
    private String module = null;
    private String earModule = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        IServer server = null;
        if (this.serverInstanceId != null) {
            server = ServerCore.findServer((String)this.serverInstanceId);
        }
        if (server == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_INSTANCE_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return status;
        }
        IServerWorkingCopy serverwc = null;
        try {
            block17: {
                try {
                    IModule moduleToAdd;
                    IProject moduleProject = ProjectUtilities.getProject((String)this.moduleProjectName);
                    if (J2EEUtils.isJavaComponent((IProject)moduleProject)) break block17;
                    IProject projectToAdd = null;
                    if (this.earProjectName != null && this.earModule != null && this.earProjectName.length() > 0 && this.earModule.length() > 0) {
                        projectToAdd = ProjectUtilities.getProject((String)this.earProjectName);
                        moduleToAdd = ServerUtils.getModule((IProject)projectToAdd, (String)this.earModule);
                    } else {
                        projectToAdd = moduleProject;
                        moduleToAdd = ServerUtils.getModule((IProject)projectToAdd, (String)this.module);
                    }
                    if (moduleToAdd == null) {
                        projectToAdd.build(10, null);
                        moduleToAdd = ServerUtils.getModule((IProject)projectToAdd);
                        if (moduleToAdd == null) {
                            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}));
                            env.getStatusHandler().reportError(status);
                            IStatus iStatus = status;
                            Object var11_13 = null;
                            try {
                                if (serverwc == null) return iStatus;
                                serverwc.save(true, null);
                                return iStatus;
                            }
                            catch (CoreException ce) {
                                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                                env.getStatusHandler().reportError(status);
                                return status;
                            }
                        }
                    }
                    if (!ServerUtil.containsModule((IServer)server, (IModule)moduleToAdd, null)) {
                        IModule[] imodules = new IModule[]{moduleToAdd};
                        serverwc = server.createWorkingCopy();
                        ServerUtil.modifyModules((IServerWorkingCopy)serverwc, (IModule[])imodules, null, null);
                    }
                }
                catch (CoreException e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)e);
                    env.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    Object var11_14 = null;
                    try {}
                    catch (CoreException ce) {
                        status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                        env.getStatusHandler().reportError(status);
                        return status;
                    }
                    if (serverwc == null) return iStatus;
                    serverwc.save(true, null);
                    return iStatus;
                }
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {}
            catch (CoreException ce) {
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                env.getStatusHandler().reportError(status);
                return status;
            }
            if (serverwc == null) throw throwable;
            serverwc.save(true, null);
            throw throwable;
        }
        try {}
        catch (CoreException ce) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (serverwc == null) return status;
        serverwc.save(true, null);
        return status;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setProject(String project) {
        this.moduleProjectName = project;
    }

    public void setEarProject(String earProject) {
        this.earProjectName = earProject;
    }

    public void setEarModule(String earModule) {
        this.earModule = earModule;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

