/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fabric8.core.server.subsystems;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.server.subsystems.Karaf2xStartupLaunchConfigurator;

public class Fabric81xStartupLaunchConfigurator
extends Karaf2xStartupLaunchConfigurator {
    public Fabric81xStartupLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    protected void doConfigure(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IKarafRuntime runtime = null;
        if (this.server.getRuntime() != null) {
            runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        }
        if (runtime != null) {
            String karafInstallDir = runtime.getLocation().toOSString();
            String mainProgram = null;
            String vmArguments = null;
            String version = runtime.getVersion();
            if (version != null) {
                if (version.startsWith("1.")) {
                    vmArguments = this.getVMArguments(karafInstallDir);
                    mainProgram = this.getMainProgram();
                } else {
                    System.err.println("Unhandled JBoss Fuse Version (" + version + ")!");
                }
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, karafInstallDir);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainProgram);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
            LinkedList<String> classPathList = new LinkedList<String>();
            String[] classPathEntries = this.getClassPathEntries(karafInstallDir);
            if (classPathEntries != null && classPathEntries.length > 0) {
                String[] stringArray = classPathEntries;
                int n = classPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName = stringArray[n2];
                    Path jarPath = new Path(jarName);
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath);
                    classPathList.add(entry.getMemento());
                    ++n2;
                }
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPathList);
        }
    }

    protected String getVMArguments(String karafInstallDir) {
        StringBuilder vmArguments = new StringBuilder();
        String endorsedDirs = System.getProperty("java.endorsed.dirs");
        String extDirs = System.getProperty("java.ext.dirs");
        vmArguments.append("-server -Xms128M  -Xmx512M -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass ");
        vmArguments.append(" -XX:PermSize=16M -XX:MaxPermSize=128M ");
        vmArguments.append(" -Dcom.sun.management.jmxremote ");
        vmArguments.append(" -Djava.endorsed.dirs=\"" + endorsedDirs + File.pathSeparatorChar + karafInstallDir + SEPARATOR + "lib" + SEPARATOR + "endorsed" + "\"");
        vmArguments.append(" -Djava.ext.dirs=\"" + extDirs + File.pathSeparatorChar + karafInstallDir + SEPARATOR + "lib" + SEPARATOR + "ext" + "\"");
        vmArguments.append(" -Dkaraf.instances=\"" + karafInstallDir + SEPARATOR + "instances" + "\"");
        vmArguments.append(" -Dkaraf.home=\"" + karafInstallDir + "\"");
        vmArguments.append(" -Dkaraf.base=\"" + karafInstallDir + "\"");
        vmArguments.append(" -Dkaraf.data=\"" + karafInstallDir + SEPARATOR + "data" + "\"");
        vmArguments.append(" -Dkaraf.etc=\"" + karafInstallDir + SEPARATOR + "etc" + "\"");
        vmArguments.append(" -Djava.io.tmpdir=\"" + karafInstallDir + SEPARATOR + "data" + SEPARATOR + "tmp" + "\"");
        vmArguments.append(" -Djava.util.logging.config.file=\"" + karafInstallDir + SEPARATOR + "etc" + SEPARATOR + "java.util.logging.properties" + "\"");
        vmArguments.append(" -Dkaraf.startLocalConsole=false");
        vmArguments.append(" -Dkaraf.startRemoteShell=true");
        vmArguments.append(" -Densemble.auto.start=true");
        vmArguments.append(" -Dagent.auto.start=true");
        return vmArguments.toString();
    }

    protected void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        super.doOverrides(launchConfig);
    }
}

