/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fabric8.core.server.subsystems;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.fusesource.ide.server.fabric8.core.Activator;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;

public class Fabric81xPublishController
extends AbstractSubsystemController
implements IPublishController {
    public static final List<String> BUILD_GOALS = Arrays.asList("clean", "package");
    public static final List<String> DEPLOY_GOALS = Arrays.asList("io.fabric8:fabric8-maven-plugin:1.1.0-SNAPSHOT:deploy");

    public IStatus canPublish() {
        return Status.OK_STATUS;
    }

    public boolean canPublishModule(IModule[] module) {
        IModule[] iModuleArray = module;
        int n = module.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (!m.getModuleType().getId().equals("fuse.camel") && !m.getModuleType().getVersion().equals("1.0")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.validate();
        int status = 0;
        int publishType = KarafUtils.getPublishType((IServer)this.getServer(), (IModule[])module, (int)kind, (int)deltaKind);
        Properties serverProperties = this.getServerProperties((KarafServerDelegate)this.getServer().loadAdapter(KarafServerDelegate.class, monitor));
        if (serverProperties == null || serverProperties.isEmpty()) {
            return status;
        }
        switch (publishType) {
            case 2: {
                boolean deployed = KarafUtils.runBuild(DEPLOY_GOALS, (Properties)serverProperties, (IModule)module[0], (IProgressMonitor)monitor);
                status = deployed ? 2 : 0;
                ((Server)this.getServer()).setServerPublishState(1);
                ((Server)this.getServer()).setModuleState(module, status);
                break;
            }
            case 1: {
                boolean deployed = KarafUtils.runBuild(DEPLOY_GOALS, (Properties)serverProperties, (IModule)module[0], (IProgressMonitor)monitor);
                status = deployed ? 2 : 0;
                ((Server)this.getServer()).setServerPublishState(1);
                ((Server)this.getServer()).setModuleState(module, status);
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                boolean done = this.uninstall(this.getServer(), module);
                if (!done) break;
                ((Server)this.getServer()).setServerPublishState(1);
                ((Server)this.getServer()).setModuleState(module, 0);
                break;
            }
            default: {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.fusesource.ide.server.fabric8.core", "Unknown publish type " + publishType));
            }
        }
        return status;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.validate();
    }

    protected Properties getServerProperties(KarafServerDelegate delegate) {
        Properties props = new Properties();
        if (delegate != null) {
            props.setProperty("fabric8-server-id", "fabric8.upload.repo");
            props.setProperty("fabric8-server-user", delegate.getUserName());
            props.setProperty("fabric8-server-password", delegate.getPassword());
        }
        return props;
    }

    protected boolean uninstall(IServer server, IModule[] module) {
        Activator.getLogger().warning("Uninstalling bundles from Fabric8 profiles is currently unsupported. Please do that inside the Fabric8 shell.");
        return false;
    }
}

