/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class XMLContentAssistText {
    private String fText;
    private int fStartOffset;

    private XMLContentAssistText(String text, int startOffset) {
        this.fText = text;
        this.fStartOffset = startOffset;
    }

    public static XMLContentAssistText parse(int offset, IDocument document) {
        char currentChar;
        boolean writeCAText = true;
        int lastCATextOffset = -1;
        StringBuffer buffer = new StringBuffer();
        int endOffset = offset - 1;
        if (offset <= 0) {
            return null;
        }
        try {
            currentChar = document.getChar(endOffset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (!XMLContentAssistText.isContentAssistText(currentChar)) {
            return null;
        }
        buffer.append(currentChar);
        lastCATextOffset = endOffset;
        int i = endOffset - 1;
        while (i > 0) {
            try {
                currentChar = document.getChar(i);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (XMLContentAssistText.isContentAssistText(currentChar)) {
                if (writeCAText) {
                    buffer.append(currentChar);
                    lastCATextOffset = i;
                }
            } else if (Character.isWhitespace(currentChar)) {
                writeCAText = false;
            } else {
                if (currentChar == '>') {
                    if (buffer.length() > 0) {
                        return new XMLContentAssistText(buffer.reverse().toString(), lastCATextOffset);
                    }
                    return null;
                }
                return null;
            }
            --i;
        }
        return null;
    }

    private static boolean isContentAssistText(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    public String getText() {
        return this.fText;
    }

    public int getStartOffset() {
        return this.fStartOffset;
    }

    public String toString() {
        return "Start Offset: " + this.fStartOffset + " Text: |" + this.fText + "|\n";
    }
}

