/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.server.nodejs.core.IDENodejsProcessHelper;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.FileComboFieldEditor;
import tern.eclipse.ide.ui.ImageResource;
import tern.utils.StringUtils;

public class TernNodejsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FileComboFieldEditor nativeNodePath;
    private Text nodePath;

    public TernNodejsPreferencesPage() {
        super(1);
        this.setDescription(TernNodejsUIMessages.TernNodejsPreferencesPage_desc);
        this.setImageDescriptor(ImageResource.getImageDescriptor((String)"logo"));
    }

    protected void createFieldEditors() {
        IntegerFieldEditor timeoutField = new IntegerFieldEditor("nodeJSTimeout", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTimeout, this.getFieldEditorParent());
        this.addField((FieldEditor)timeoutField);
        IntegerFieldEditor testNumberField = new IntegerFieldEditor("nodeJSTestNumber", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTestNumber, this.getFieldEditorParent());
        this.addField((FieldEditor)testNumberField);
        BooleanFieldEditor persistentField = new BooleanFieldEditor("nodeJSPersistent", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPersistent, this.getFieldEditorParent());
        this.addField((FieldEditor)persistentField);
        INodejsInstall[] installs = TernNodejsCorePlugin.getNodejsInstallManager().getNodejsInstalls();
        String[][] data = new String[installs.length + 1][2];
        data[0][0] = TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall_emptyValue;
        data[0][1] = "";
        int i = 0;
        while (i < installs.length) {
            data[i + 1][0] = installs[i].getName();
            data[i + 1][1] = installs[i].getId();
            ++i;
        }
        ComboFieldEditor nodeJSInstallField = new ComboFieldEditor("nodeJSInstall", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall, data, this.getFieldEditorParent()){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                INodejsInstall install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(newValue.toString());
                if (install == null || install.isNative()) {
                    TernNodejsPreferencesPage.this.nativeNodePath.setEnabled(true, TernNodejsPreferencesPage.this.getFieldEditorParent());
                    String defaultPath = IDENodejsProcessHelper.getNodejsPath();
                    TernNodejsPreferencesPage.this.nativeNodePath.setStringValue(defaultPath);
                    TernNodejsPreferencesPage.this.nodePath.setText(defaultPath);
                } else {
                    TernNodejsPreferencesPage.this.nativeNodePath.setEnabled(false, TernNodejsPreferencesPage.this.getFieldEditorParent());
                    TernNodejsPreferencesPage.this.nodePath.setText(install.getPath().getAbsolutePath());
                }
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
        this.addField((FieldEditor)nodeJSInstallField);
        String[] defaultPaths = IDENodejsProcessHelper.getDefaultNodejsPaths();
        this.nativeNodePath = new FileComboFieldEditor("nodeJSPath", TernNodejsUIMessages.TernNodejsPreferencesPage_nativeNodeJSPath, defaultPaths, this.getFieldEditorParent()){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                TernNodejsPreferencesPage.this.nodePath.setText(newValue.toString());
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
        this.addField(this.nativeNodePath);
        Label nodePathTitle = new Label(this.getFieldEditorParent(), 0);
        nodePathTitle.setText(TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPath);
        GridData gridData = new GridData(2);
        nodePathTitle.setLayoutData((Object)gridData);
        this.nodePath = new Text(this.getFieldEditorParent(), 72);
        this.nodePath.setText("");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.nodePath.setLayoutData((Object)gridData);
    }

    protected void initialize() {
        super.initialize();
        this.updateNodePath(false);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        InstanceScope scope = new InstanceScope();
        return new ScopedPreferenceStore((IScopeContext)scope, "tern.eclipse.ide.server.nodejs.core");
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            TernCorePlugin.getTernServerTypeManager().refresh();
        }
        return result;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateNodePath(true);
    }

    public void updateNodePath(boolean defaultValue) {
        INodejsInstall install = this.getNodejsInstall(defaultValue);
        if (install != null) {
            if (install.isNative()) {
                this.nodePath.setText(this.nativeNodePath.getStringValue());
            } else {
                this.nodePath.setText(install.getPath().getAbsolutePath());
            }
        }
        this.nativeNodePath.setEnabled(install != null && install.isNative(), this.getFieldEditorParent());
    }

    private INodejsInstall getNodejsInstall(boolean defaultValue) {
        String installId;
        INodejsInstall install = null;
        String string = installId = defaultValue ? super.getPreferenceStore().getDefaultString("nodeJSInstall") : super.getPreferenceStore().getString("nodeJSInstall");
        if (!StringUtils.isEmpty((String)installId)) {
            install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(installId);
        }
        return install;
    }
}

