/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.browser.javafx;

import com.sun.javafx.scene.web.Debugger;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.browsersim.browser.ExtendedCloseWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedOpenWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedVisibilityWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.IBrowserFunction;
import org.jboss.tools.vpe.browsersim.browser.IDisposable;
import org.jboss.tools.vpe.browsersim.browser.javafx.JavaFXBrowserFunctionProxy;

public class JavaFXBrowser
extends FXCanvas
implements IBrowser {
    private WebView webView;
    private List<ExtendedCloseWindowListener> closeWindowListeners = new ArrayList<ExtendedCloseWindowListener>();
    private List<LocationListener> locationListeners = new ArrayList<LocationListener>();
    private List<TitleListener> titleListeners = new ArrayList<TitleListener>();
    private List<StatusTextListener> statusTextListeners = new ArrayList<StatusTextListener>();
    private List<ExtendedOpenWindowListener> openWindowListeners = new ArrayList<ExtendedOpenWindowListener>();
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private List<ExtendedVisibilityWindowListener> visibilityWindowListeners = new ArrayList<ExtendedVisibilityWindowListener>();

    public JavaFXBrowser(Composite parent) {
        super(parent, 0);
        this.webView = new WebView();
        this.setScene(new Scene((Parent)this.webView));
        Debugger debugger = this.getEngine().impl_getDebugger();
        debugger.setEnabled(true);
        debugger.sendMessage("{\"id\" : -1, \"method\" : \"Network.enable\"}");
        this.getEngine().getLoadWorker().progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (oldValue.doubleValue() == 0.0 && newValue.doubleValue() > 0.0) {
                    LocationEvent event = new LocationEvent((Widget)JavaFXBrowser.this);
                    event.widget = JavaFXBrowser.this;
                    event.location = JavaFXBrowser.this.getEngine().getLocation();
                    event.top = true;
                    for (LocationListener locationListener : JavaFXBrowser.this.locationListeners) {
                        locationListener.changed(event);
                    }
                }
            }
        });
        this.getEngine().getLoadWorker().progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ProgressEvent progressEvent = new ProgressEvent((Widget)JavaFXBrowser.this);
                double maximumValue = 1.0;
                progressEvent.total = 100;
                if (maximumValue > 0.0 && newValue.doubleValue() >= maximumValue) {
                    progressEvent.current = progressEvent.total;
                    for (ProgressListener progressListener : JavaFXBrowser.this.progressListeners) {
                        progressListener.completed(progressEvent);
                    }
                } else {
                    progressEvent.current = maximumValue <= 0.0 ? progressEvent.total / 2 : (int)(newValue.doubleValue() / maximumValue * (double)progressEvent.total);
                    for (ProgressListener progressListener : JavaFXBrowser.this.progressListeners) {
                        progressListener.changed(progressEvent);
                    }
                }
            }
        });
        this.getEngine().titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldState, String newState) {
                TitleEvent event = new TitleEvent((Widget)JavaFXBrowser.this);
                event.widget = JavaFXBrowser.this;
                event.title = newState != null ? newState : "";
                for (TitleListener titleListener : JavaFXBrowser.this.titleListeners) {
                    titleListener.changed(event);
                }
            }
        });
        this.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> event) {
                MessageBox messageBox = new MessageBox(JavaFXBrowser.this.getShell());
                messageBox.setMessage((String)event.getData());
                messageBox.open();
            }
        });
        this.getEngine().setConfirmHandler((Callback)new Callback<String, Boolean>(){

            public Boolean call(String message) {
                MessageBox messageBox = new MessageBox(JavaFXBrowser.this.getShell());
                messageBox.setMessage(message);
                if (messageBox.open() == 32) {
                    return true;
                }
                return false;
            }
        });
        this.getEngine().setPromptHandler((Callback)new Callback<PromptData, String>(){

            public String call(PromptData param) {
                return null;
            }
        });
        this.getEngine().setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

            public WebEngine call(PopupFeatures popupFeatures) {
                ExtendedWindowEvent event = new ExtendedWindowEvent((Widget)JavaFXBrowser.this);
                event.widget = JavaFXBrowser.this;
                for (ExtendedOpenWindowListener openWindowListener : JavaFXBrowser.this.openWindowListeners) {
                    openWindowListener.open(event);
                }
                if (event.browser instanceof JavaFXBrowser && !event.browser.isDisposed()) {
                    JavaFXBrowser popupWebViewBrowser = (JavaFXBrowser)event.browser;
                    return popupWebViewBrowser.getEngine();
                }
                return null;
            }
        });
        this.getEngine().setOnVisibilityChanged((EventHandler)new EventHandler<WebEvent<Boolean>>(){

            public void handle(WebEvent<Boolean> event) {
                boolean shown = (Boolean)event.getData();
                ExtendedWindowEvent extendedWindowEvent = new ExtendedWindowEvent((Widget)JavaFXBrowser.this);
                extendedWindowEvent.widget = JavaFXBrowser.this;
                if (shown) {
                    for (ExtendedVisibilityWindowListener visibilityWindowListener : JavaFXBrowser.this.visibilityWindowListeners) {
                        visibilityWindowListener.show(extendedWindowEvent);
                    }
                } else {
                    for (ExtendedCloseWindowListener closeWindowListener : JavaFXBrowser.this.closeWindowListeners) {
                        if (JavaFXBrowser.this.isDisposed()) continue;
                        closeWindowListener.close(extendedWindowEvent);
                    }
                }
            }
        });
    }

    @Override
    public void addCloseWindowListener(ExtendedCloseWindowListener closeWindowListener) {
        this.closeWindowListeners.add(closeWindowListener);
    }

    @Override
    public void removeCloseWindowListener(ExtendedCloseWindowListener closeWindowListener) {
        this.closeWindowListeners.remove(closeWindowListener);
    }

    @Override
    public void addLocationListener(LocationListener locationListener) {
        this.locationListeners.add(locationListener);
    }

    @Override
    public void removeLocationListener(LocationListener locationListener) {
        this.locationListeners.remove(locationListener);
    }

    @Override
    public void addOpenWindowListener(ExtendedOpenWindowListener openWindowListener) {
        this.openWindowListeners.add(openWindowListener);
    }

    @Override
    public void removeOpenWindowListener(ExtendedOpenWindowListener listener) {
        this.openWindowListeners.remove(listener);
    }

    @Override
    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    @Override
    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.statusTextListeners.add(statusTextListener);
    }

    @Override
    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.statusTextListeners.remove(this.statusTextListeners);
    }

    @Override
    public void addTitleListener(TitleListener titleListener) {
        this.titleListeners.add(titleListener);
    }

    @Override
    public void removeTitleListener(TitleListener titleListener) {
        this.titleListeners.remove(titleListener);
    }

    @Override
    public void addVisibilityWindowListener(ExtendedVisibilityWindowListener listener) {
        this.visibilityWindowListeners.add(listener);
    }

    @Override
    public void removeVisibilityWindowListener(ExtendedVisibilityWindowListener listener) {
        this.visibilityWindowListeners.remove(listener);
    }

    @Override
    public boolean back() {
        boolean success = this.isBackEnabled();
        if (success) {
            this.getEngine().getHistory().go(-1);
        }
        return success;
    }

    @Override
    public boolean forward() {
        boolean success = this.isForwardEnabled();
        if (success) {
            this.getEngine().getHistory().go(1);
        }
        return success;
    }

    @Override
    public void refresh() {
        this.getEngine().reload();
    }

    @Override
    public void stop() {
        this.execute("window.stop()");
    }

    @Override
    public Object evaluate(String script) {
        return this.getEngine().executeScript("(function(){" + script + "}())");
    }

    @Override
    public boolean execute(String string) {
        try {
            this.getEngine().executeScript(string);
            return true;
        }
        catch (JSException jSException) {
            return false;
        }
    }

    @Override
    public IDisposable registerBrowserFunction(final String name, IBrowserFunction iBrowserFunction) {
        JSObject window = (JSObject)this.evaluate("return window");
        final String id = "__webViewProxy_" + name;
        window.setMember(id, new JavaFXBrowserFunctionProxy(iBrowserFunction));
        this.evaluate("window['" + name + "'] = function(){return window['" + id + "'].func(arguments)}");
        return new IDisposable(){

            @Override
            public void dispose() {
                JavaFXBrowser.this.evaluate("delete window['" + name + "']; delete window['" + id + "']");
            }

            @Override
            public boolean isDisposed() {
                return (Boolean)JavaFXBrowser.this.evaluate("return window['" + name + "'] === undefined && window['" + id + "'] === undefined");
            }
        };
    }

    public Debugger getDebugger() {
        return this.getEngine().impl_getDebugger();
    }

    @Override
    public String getText() {
        String doctypeScript = "var node = document.doctype;var doctypeText = \"<!DOCTYPE \"+ node.name+ (node.publicId ? ' PUBLIC \"' + node.publicId + '\"' : '')+ (!node.publicId && node.systemId ? ' SYSTEM' : '')+ (node.systemId ? ' \"' + node.systemId + '\"' : '')+ '>';return doctypeText";
        String doctypeText = (String)this.evaluate(doctypeScript);
        String innerHtml = (String)this.evaluate("return window.document.documentElement.innerHTML");
        return String.valueOf(doctypeText) + '\n' + innerHtml;
    }

    @Override
    public String getUrl() {
        return this.getEngine().getLocation();
    }

    @Override
    public boolean isBackEnabled() {
        return this.getEngine().getHistory().getCurrentIndex() > 0;
    }

    @Override
    public boolean isForwardEnabled() {
        return this.getEngine().getHistory().getCurrentIndex() + 1 < this.getEngine().getHistory().getEntries().size();
    }

    @Override
    public void setUserAgent(String userAgent) {
        if (userAgent == null) {
            userAgent = "";
        }
        String escapedUserAgent = userAgent.replace("\\", "\\\\").replace("\"", "\\\"");
        this.getDebugger().sendMessage("{\"id\" : -1, \"method\" : \"Network.setUserAgentOverride\",\"params\" : { \"userAgent\" : \"" + escapedUserAgent + "\"" + "}}");
    }

    @Override
    public boolean setUrl(String location) {
        if (!(location = location.trim()).contains(":")) {
            location = "http://" + location;
        }
        this.getEngine().load(location);
        return true;
    }

    protected WebEngine getEngine() {
        return this.webView.getEngine();
    }
}

