/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.browser;

import org.eclipse.swt.SWT;

public class PlatformUtil {
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_X64 = "x86_64";
    public static final String OS_WIN32 = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_MACOSX = "macosx";
    public static final String CURRENT_PLATFORM;

    static {
        String os = PlatformUtil.getOs();
        String ws = PlatformUtil.getWs();
        String arch = PlatformUtil.getArch();
        CURRENT_PLATFORM = OS_MACOSX.equals(os) && ARCH_X86.equals(arch) ? String.valueOf(ws) + '.' + os : String.valueOf(ws) + '.' + os + '.' + arch;
    }

    public static String getArch() {
        String osArch = System.getProperty("os.arch");
        return PlatformUtil.parseArch(osArch);
    }

    public static String parseArch(String osArch) {
        if (osArch.equals("i386") || osArch.equals("i686")) {
            return ARCH_X86;
        }
        if (osArch.equals("amd64")) {
            return ARCH_X64;
        }
        if (osArch.equals("IA64N")) {
            return "ia64_32";
        }
        if (osArch.equals("IA64W")) {
            return "ia64";
        }
        return osArch;
    }

    public static String getOs() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            return OS_LINUX;
        }
        if (osName.equals("AIX")) {
            return "aix";
        }
        if (osName.equals("Solaris") || osName.equals("SunOS")) {
            return "solaris";
        }
        if (osName.equals("HP-UX")) {
            return "hpux";
        }
        if (osName.equals("Mac OS X")) {
            return OS_MACOSX;
        }
        if (osName.startsWith("Win")) {
            return OS_WIN32;
        }
        return osName;
    }

    private static String getWs() {
        return SWT.getPlatform();
    }
}

