/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.cnd;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public interface CommentedCndElement
extends CndElement {
    public static final String BLOCK_COMMENT_END_CHARS = "*/";
    public static final String BLOCK_COMMENT_INNER_CHARS = " * ";
    public static final String BLOCK_COMMENT_START_CHARS = "/*";
    public static final String LINE_COMMENT_CHARS = "//";

    public String getComment();

    public boolean setComment(String var1);

    public static class Helper {
        private static String BLOCK_COMMENT_INNER_CHARS2 = "* ";

        public static String addCommentCharacters(String text) {
            Utils.verifyIsNotNull(text, "text");
            StringBuilder builder = new StringBuilder(CommentedCndElement.BLOCK_COMMENT_START_CHARS);
            if (!text.startsWith("\n")) {
                builder.append('\n');
            }
            builder.append(CommentedCndElement.BLOCK_COMMENT_INNER_CHARS);
            builder.append(text.replace("\n", "\n * "));
            if (!text.endsWith("\n")) {
                builder.append('\n');
            }
            builder.append(" ").append(CommentedCndElement.BLOCK_COMMENT_END_CHARS).append('\n');
            return builder.toString();
        }

        public static String removeCommentCharacters(String comment) {
            Utils.verifyIsNotNull(comment, "comment");
            if (Utils.isEmpty(comment)) {
                return comment;
            }
            String result = comment.trim();
            if (result.startsWith(CommentedCndElement.BLOCK_COMMENT_START_CHARS)) {
                if (result.length() == CommentedCndElement.BLOCK_COMMENT_START_CHARS.length()) {
                    return comment;
                }
                result = comment.substring(CommentedCndElement.BLOCK_COMMENT_START_CHARS.length());
                if ((result = result.trim()).endsWith(CommentedCndElement.BLOCK_COMMENT_END_CHARS)) {
                    result = result.substring(0, result.length() - CommentedCndElement.BLOCK_COMMENT_END_CHARS.length());
                    if ((result = result.trim()).isEmpty()) {
                        return result;
                    }
                    if (result.startsWith(CommentedCndElement.BLOCK_COMMENT_INNER_CHARS)) {
                        result = result.substring(CommentedCndElement.BLOCK_COMMENT_INNER_CHARS.length());
                    } else if (result.startsWith(BLOCK_COMMENT_INNER_CHARS2)) {
                        result = result.substring(BLOCK_COMMENT_INNER_CHARS2.length());
                    }
                    result = result.replace("\n * ", "\n");
                    return result.trim();
                }
            } else if (comment.startsWith(CommentedCndElement.LINE_COMMENT_CHARS)) {
                if (comment.length() == CommentedCndElement.LINE_COMMENT_CHARS.length()) {
                    return "";
                }
                return comment.substring(CommentedCndElement.LINE_COMMENT_CHARS.length()).trim();
            }
            return comment;
        }
    }
}

