/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.cnd;

import java.math.BigDecimal;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.MultiValidationStatus;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.WorkspaceRegistry;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.PropertyType;
import org.jboss.tools.modeshape.jcr.attributes.QueryOperators;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;

public final class CndValidator {
    public static final String LOCAL_NAME_VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.";
    private static final String PARENT_PATH_SEGMENT = "..";
    private static final String SELF_PATH_SEGMENT = ".";

    public static ValidationStatus isValid(String value, PropertyType propertyType, String propertyName, Collection<String> validNamespacePrefixes) {
        Utils.verifyIsNotNull(propertyType, "propertyType");
        if (Utils.isEmpty(propertyName)) {
            propertyName = Messages.missingName;
        }
        if (Utils.isEmpty(value)) {
            return ValidationStatus.createErrorMessage(100, NLS.bind((String)Messages.emptyValue, (Object)propertyName));
        }
        try {
            if (PropertyType.STRING == propertyType) {
                return ValidationStatus.OK_STATUS;
            }
            if (PropertyType.BINARY == propertyType) {
                return ValidationStatus.OK_STATUS;
            }
            if (PropertyType.BOOLEAN == propertyType) {
                if (!value.equalsIgnoreCase(Boolean.TRUE.toString()) && !value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object[])new Object[]{value, PropertyType.BOOLEAN, propertyName}));
                }
            } else if (PropertyType.DATE == propertyType) {
                try {
                    Date.valueOf(value);
                }
                catch (Exception exception) {
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object[])new Object[]{value, PropertyType.DATE, propertyName}));
                }
            } else if (PropertyType.DECIMAL == propertyType) {
                try {
                    new BigDecimal(value);
                }
                catch (Exception exception) {
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)value, (Object)PropertyType.DECIMAL));
                }
            } else if (PropertyType.DOUBLE == propertyType) {
                try {
                    Double.parseDouble(value);
                }
                catch (Exception exception) {
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)value, (Object)PropertyType.DOUBLE));
                }
            } else if (PropertyType.LONG == propertyType) {
                try {
                    Long.parseLong(value);
                }
                catch (Exception exception) {
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)value, (Object)PropertyType.LONG));
                }
            } else {
                if (PropertyType.NAME == propertyType) {
                    return CndValidator.validateQualifiedName(QualifiedName.parse(value), propertyName, validNamespacePrefixes, null);
                }
                if (PropertyType.PATH == propertyType) {
                    return CndValidator.validatePath(value, propertyName);
                }
                if (PropertyType.REFERENCE == propertyType) {
                    return ValidationStatus.OK_STATUS;
                }
                if (PropertyType.UNDEFINED == propertyType) {
                    return ValidationStatus.OK_STATUS;
                }
                if (PropertyType.URI == propertyType) {
                    return CndValidator.validateUri(value, propertyName);
                }
                if (PropertyType.WEAKREFERENCE == propertyType) {
                    return ValidationStatus.OK_STATUS;
                }
            }
            return ValidationStatus.OK_STATUS;
        }
        catch (Exception exception) {
            return ValidationStatus.createErrorMessage(110, NLS.bind((String)Messages.errorValidatingPropertyValueForType, (Object[])new Object[]{value, propertyType, propertyName}));
        }
    }

    public static void isValid(String value, PropertyType propertyType, String propertyName, Collection<String> validNamespacePrefixes, MultiValidationStatus status) {
        ValidationStatus newStatus = CndValidator.isValid(value, propertyType, propertyName, validNamespacePrefixes);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateChildNodeDefinition(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingChildNodeNames) {
        Utils.verifyIsNotNull(childNodeDefinition, "childNodeDefinition");
        MultiValidationStatus status = new MultiValidationStatus();
        String childNodeName = childNodeDefinition.getName();
        if (Utils.isEmpty(childNodeName)) {
            childNodeName = Messages.missingName;
        }
        CndValidator.validateName(childNodeDefinition, validNamespacePrefixes, existingChildNodeNames, status);
        CndValidator.validateRequiredTypes(childNodeDefinition, validNamespacePrefixes, status);
        CndValidator.validateDefaultType(childNodeDefinition, validNamespacePrefixes, status);
        return status;
    }

    public static void validateChildNodeDefinition(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingChildNodeNames, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateChildNodeDefinition(childNodeDefinition, validNamespacePrefixes, existingChildNodeNames);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateChildNodeDefinitions(String nodeTypeName, Collection<String> validNamespacePrefixes, Collection<ChildNodeDefinition> childNodeDefinitions) {
        Utils.verifyIsNotEmpty(nodeTypeName, "nodeTypeName");
        if (Utils.isEmpty(childNodeDefinitions)) {
            return MultiValidationStatus.OK_STATUS;
        }
        MultiValidationStatus status = new MultiValidationStatus();
        ArrayList<String> childNodeNames = new ArrayList<String>(childNodeDefinitions.size());
        for (ChildNodeDefinition childNodeDefn : childNodeDefinitions) {
            CndValidator.validateChildNodeDefinition(childNodeDefn, validNamespacePrefixes, null, status);
            String childNodeName = childNodeDefn.getName();
            if (Utils.isEmpty(childNodeName) || "*".equals(childNodeName)) continue;
            if (childNodeNames.contains(childNodeName)) {
                status.add(ValidationStatus.createErrorMessage(115, NLS.bind((String)Messages.duplicateChildNodeDefinitionName, (Object)nodeTypeName, (Object)childNodeName)));
                continue;
            }
            childNodeNames.add(childNodeName);
        }
        return status;
    }

    public static void validateChildNodeDefinitions(String nodeTypeName, Collection<String> validNamespacePrefixes, Collection<ChildNodeDefinition> childNodeDefinitions, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateChildNodeDefinitions(nodeTypeName, validNamespacePrefixes, childNodeDefinitions);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateCnd(CompactNodeTypeDefinition cnd) {
        Utils.verifyIsNotNull(cnd, "cnd");
        MultiValidationStatus status = new MultiValidationStatus();
        boolean noNamespaceMappings = false;
        boolean noNodeTypeDefinitions = false;
        List<NamespaceMapping> namespaceMappings = cnd.getNamespaceMappings();
        if (Utils.isEmpty(namespaceMappings)) {
            noNamespaceMappings = true;
        } else {
            CndValidator.validateNamespaceMappings(namespaceMappings, status);
        }
        List<NodeTypeDefinition> nodeTypeDefinitions = cnd.getNodeTypeDefinitions();
        if (Utils.isEmpty(nodeTypeDefinitions)) {
            noNodeTypeDefinitions = true;
        } else {
            CndValidator.validateNodeTypeDefinitions(cnd, true, status);
        }
        if (noNamespaceMappings && noNodeTypeDefinitions) {
            status.add(ValidationStatus.createWarningMessage(120, Messages.cndHasNoNamespacesOrNodeTypeDefinitions));
        }
        return status;
    }

    public static void validateCnd(CompactNodeTypeDefinition cnd, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateCnd(cnd);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateDefaultType(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateDefaultType(childNodeDefinition, validNamespacePrefixes, status);
        return status;
    }

    public static void validateDefaultType(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, MultiValidationStatus status) {
        Utils.verifyIsNotNull(childNodeDefinition, "childNodeDefinition");
        Utils.verifyIsNotNull(status, "status");
        String childNodeName = childNodeDefinition.getName();
        if (Utils.isEmpty(childNodeName)) {
            childNodeName = Messages.missingName;
        }
        String defaultTypeName = childNodeDefinition.getDefaultPrimaryTypeName();
        if (childNodeDefinition.getState(ChildNodeDefinition.PropertyName.DEFAULT_TYPE) == AttributeState.Value.IS) {
            CndValidator.validateQualifiedName(childNodeDefinition.getDefaultType().getDefaultType(), Messages.defaultTypeName, validNamespacePrefixes, null, status);
            if (!"*".equals(childNodeName)) {
                String[] requiredTypes = childNodeDefinition.getRequiredPrimaryTypeNames();
                boolean foundMatch = false;
                if (!Utils.isEmpty(defaultTypeName)) {
                    String[] stringArray = requiredTypes;
                    int n = requiredTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String requiredType = stringArray[n2];
                        if (defaultTypeName.equals(requiredType)) {
                            foundMatch = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!foundMatch) {
                        status.add(ValidationStatus.createErrorMessage(125, NLS.bind((String)Messages.defaultTypeDoesNotMatchRequiredType, (Object)childNodeName, (Object)defaultTypeName)));
                    }
                }
            }
        } else if (!Utils.isEmpty(defaultTypeName)) {
            status.add(ValidationStatus.createErrorMessage(130, NLS.bind((String)Messages.defaultTypeExistsButMarkedAsVariant, (Object)childNodeName)));
        }
    }

    public static MultiValidationStatus validateDefaultValues(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateDefaultValues(propertyDefinition, validNamespacePrefixes, status);
        return status;
    }

    public static void validateDefaultValues(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes, MultiValidationStatus status) {
        List<String> defaultValues;
        Utils.verifyIsNotNull(propertyDefinition, "propertyDefinition");
        Utils.verifyIsNotNull(status, "status");
        String propertyName = propertyDefinition.getName();
        if (Utils.isEmpty(propertyName)) {
            propertyName = Messages.missingName;
        }
        if (Utils.isEmpty(defaultValues = propertyDefinition.getDefaultValuesAsStrings())) {
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.DEFAULT_VALUES) == AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(135, NLS.bind((String)Messages.emptyDefaultValues, (Object)propertyName)));
            }
        } else {
            if (defaultValues.size() > 1 && propertyDefinition.getState(PropertyDefinition.PropertyName.MULTIPLE) == AttributeState.Value.IS_NOT) {
                status.add(ValidationStatus.createErrorMessage(140, NLS.bind((String)Messages.multipleDefaultValuesForSingleValuedProperty, (Object)propertyName)));
            }
            CndValidator.validateDefaultValues(propertyName, propertyDefinition.getType(), defaultValues, validNamespacePrefixes, status);
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.DEFAULT_VALUES) != AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(155, NLS.bind((String)Messages.defaultValuesExistButMarkedAsVariant, (Object)propertyDefinition)));
            }
        }
    }

    public static MultiValidationStatus validateDefaultValues(String propertyName, PropertyType propertyType, Collection<String> defaultValues, Collection<String> validNamespacePrefixes) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateDefaultValues(propertyName, propertyType, defaultValues, validNamespacePrefixes, status);
        return status;
    }

    public static void validateDefaultValues(String propertyName, PropertyType propertyType, Collection<String> defaultValues, Collection<String> validNamespacePrefixes, MultiValidationStatus status) {
        Utils.verifyIsNotNull(propertyType, "propertyType");
        if (propertyName == null) {
            propertyName = Messages.missingName;
        }
        if (!Utils.isEmpty(defaultValues)) {
            ArrayList<String> values = new ArrayList<String>(defaultValues.size());
            for (String defaultValue : defaultValues) {
                Collection<Object> qualifiers;
                CndValidator.isValid(defaultValue, propertyType, Messages.defaultValue, validNamespacePrefixes, status);
                Collection<Object> collection = qualifiers = Utils.isEmpty(validNamespacePrefixes) ? Collections.emptyList() : validNamespacePrefixes;
                if (propertyType == PropertyType.NAME) {
                    QualifiedName qname = QualifiedName.parse(defaultValue);
                    String qualifier = qname.getQualifier();
                    boolean valid = false;
                    if (!Utils.isEmpty(qualifier)) {
                        for (String string : qualifiers) {
                            if (!string.equals(qualifier)) continue;
                            valid = true;
                            break;
                        }
                    }
                    if (!valid) {
                        status.add(ValidationStatus.createErrorMessage(145, NLS.bind((String)Messages.invalidQualifierForDefaultValue, (Object)propertyName, (Object)defaultValue)));
                    }
                }
                if (Utils.isEmpty(defaultValue)) continue;
                if (values.contains(defaultValue)) {
                    status.add(ValidationStatus.createErrorMessage(150, NLS.bind((String)Messages.duplicateDefaultValue, (Object)propertyName, (Object)defaultValue)));
                    continue;
                }
                values.add(defaultValue);
            }
        }
    }

    public static ValidationStatus validateLocalName(String localName, String messagePrefix) {
        Utils.verifyIsNotEmpty(messagePrefix, messagePrefix);
        if (Utils.isEmpty(localName)) {
            return ValidationStatus.createErrorMessage(160, NLS.bind((String)Messages.emptyLocalName, (Object)messagePrefix));
        }
        if (localName.equals(SELF_PATH_SEGMENT) || localName.equals(PARENT_PATH_SEGMENT)) {
            return ValidationStatus.createErrorMessage(165, NLS.bind((String)Messages.localNameEqualToSelfOrParent, (Object)messagePrefix));
        }
        char[] cArray = localName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': 
                case '/': 
                case ':': 
                case '[': 
                case ']': 
                case '|': {
                    return ValidationStatus.createErrorMessage(170, NLS.bind((String)Messages.localNameHasInvalidCharacters, (Object)messagePrefix, (Object)localName));
                }
            }
            ++n2;
        }
        return ValidationStatus.OK_STATUS;
    }

    public static void validateLocalName(String localName, String propertyName, MultiValidationStatus status) {
        ValidationStatus newStatus = CndValidator.validateLocalName(localName, propertyName);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateName(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingChildNodeNames) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateName(childNodeDefinition, validNamespacePrefixes, existingChildNodeNames, status);
        return status;
    }

    public static void validateName(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingChildNodeNames, MultiValidationStatus status) {
        Utils.verifyIsNotNull(childNodeDefinition, "childNodeDefinition");
        if (!"*".equals(childNodeDefinition.getName())) {
            CndValidator.validateQualifiedName(childNodeDefinition.getQualifiedName(), Messages.childNodeDefinitionName, validNamespacePrefixes, existingChildNodeNames, status);
        }
    }

    public static MultiValidationStatus validateName(NodeTypeDefinition nodeTypeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingNodeTypeNames) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateName(nodeTypeDefinition, validNamespacePrefixes, existingNodeTypeNames, status);
        return status;
    }

    public static void validateName(NodeTypeDefinition nodeTypeDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingNodeTypeNames, MultiValidationStatus status) {
        CndValidator.validateQualifiedName(nodeTypeDefinition.getQualifiedName(), Messages.nodeTypeDefinitionName, validNamespacePrefixes, existingNodeTypeNames, status);
    }

    public static MultiValidationStatus validateName(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingPropertyNames) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateName(propertyDefinition, validNamespacePrefixes, existingPropertyNames, status);
        return status;
    }

    public static void validateName(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingPropertyNames, MultiValidationStatus status) {
        Utils.verifyIsNotNull(propertyDefinition, "propertyDefinition");
        if (!"*".equals(propertyDefinition.getName())) {
            CndValidator.validateQualifiedName(propertyDefinition.getQualifiedName(), Messages.propertyDefinitionName, validNamespacePrefixes, existingPropertyNames, status);
        }
    }

    public static MultiValidationStatus validateNamespaceMapping(NamespaceMapping namespaceMapping) {
        Utils.verifyIsNotNull(namespaceMapping, "namespaceMapping");
        MultiValidationStatus status = new MultiValidationStatus();
        String prefix = namespaceMapping.getPrefix();
        String uri = namespaceMapping.getUri();
        CndValidator.validateLocalName(prefix, Messages.namespacePrefix, status);
        ValidationStatus uriStatus = CndValidator.validateUri(uri, Messages.namespaceUri);
        if (!uriStatus.isOk()) {
            status.add(uriStatus);
        }
        try {
            if (!Utils.isEmpty(prefix) && WorkspaceRegistry.get().isBuiltInNamespacePrefix(prefix) && !Utils.equals(uri, WorkspaceRegistry.get().getUri(prefix))) {
                status.add(ValidationStatus.createErrorMessage(175, NLS.bind((String)Messages.invalidUriForBuiltInNamespacePrefix, (Object[])new Object[]{uri, prefix, WorkspaceRegistry.get().getUri(prefix)})));
            }
            if (!Utils.isEmpty(uri) && WorkspaceRegistry.get().isBuiltInNamespaceUri(uri) && !Utils.equals(prefix, WorkspaceRegistry.get().getPrefix(uri))) {
                status.add(ValidationStatus.createErrorMessage(180, NLS.bind((String)Messages.invalidPrefixForBuiltInNamespaceUri, (Object[])new Object[]{prefix, uri, WorkspaceRegistry.get().getPrefix(uri)})));
            }
        }
        catch (Exception e) {
            if (Platform.isRunning()) {
                Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
            }
            System.err.print(e.getMessage());
        }
        return status;
    }

    public static MultiValidationStatus validateNamespaceMapping(NamespaceMapping namespaceMapping, Collection<NamespaceMapping> existingNamespaces) {
        MultiValidationStatus status = CndValidator.validateNamespaceMapping(namespaceMapping);
        if (!Utils.isEmpty(existingNamespaces)) {
            boolean checkPrefix = true;
            boolean checkUri = true;
            for (NamespaceMapping namespace : existingNamespaces) {
                if (checkPrefix && Utils.equivalent(namespaceMapping.getPrefix(), namespace.getPrefix())) {
                    checkPrefix = false;
                    String prefix = namespaceMapping.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    status.add(ValidationStatus.createErrorMessage(185, NLS.bind((String)Messages.duplicateNamespacePrefix, (Object)prefix)));
                }
                if (!checkUri || !Utils.equivalent(namespaceMapping.getUri(), namespace.getUri())) continue;
                checkUri = false;
                String uri = namespaceMapping.getUri();
                if (uri == null) {
                    uri = "";
                }
                status.add(ValidationStatus.createErrorMessage(190, NLS.bind((String)Messages.duplicateNamespaceUri, (Object)uri)));
            }
        }
        return status;
    }

    public static void validateNamespaceMapping(NamespaceMapping namespaceMapping, Collection<NamespaceMapping> existingNamespaces, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateNamespaceMapping(namespaceMapping, existingNamespaces);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static void validateNamespaceMapping(NamespaceMapping namespaceMapping, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateNamespaceMapping(namespaceMapping);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateNamespaceMappings(Collection<NamespaceMapping> namespaceMappings) {
        if (Utils.isEmpty(namespaceMappings)) {
            return MultiValidationStatus.OK_STATUS;
        }
        MultiValidationStatus status = new MultiValidationStatus();
        ArrayList<String> prefixes = new ArrayList<String>(namespaceMappings.size());
        ArrayList<String> uris = new ArrayList<String>(namespaceMappings.size());
        for (NamespaceMapping namespaceMapping : namespaceMappings) {
            String uri;
            CndValidator.validateNamespaceMapping(namespaceMapping, status);
            String prefix = namespaceMapping.getPrefix();
            if (!Utils.isEmpty(prefix)) {
                if (prefixes.contains(prefix)) {
                    status.add(ValidationStatus.createErrorMessage(185, NLS.bind((String)Messages.duplicateNamespacePrefix, (Object)prefix)));
                } else {
                    prefixes.add(prefix);
                }
            }
            if (Utils.isEmpty(uri = namespaceMapping.getUri())) continue;
            if (uris.contains(uri)) {
                status.add(ValidationStatus.createErrorMessage(190, NLS.bind((String)Messages.duplicateNamespaceUri, (Object)uri)));
                continue;
            }
            uris.add(uri);
        }
        return status;
    }

    public static void validateNamespaceMappings(Collection<NamespaceMapping> namespaceMappings, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateNamespaceMappings(namespaceMappings);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateNodeTypeDefinition(NodeTypeDefinition nodeTypeDefinition, CompactNodeTypeDefinition cnd, boolean validateEachPropertyAndChildNode) {
        Utils.verifyIsNotNull(nodeTypeDefinition, "nodeTypeDefinition");
        MultiValidationStatus status = new MultiValidationStatus();
        String nodeTypeDefinitionName = nodeTypeDefinition.getName();
        if (Utils.isEmpty(nodeTypeDefinitionName)) {
            nodeTypeDefinitionName = Messages.missingName;
        }
        Collection<String> validNamespacePrefixes = cnd == null ? null : cnd.getNamespacePrefixes();
        CndValidator.validateName(nodeTypeDefinition, validNamespacePrefixes, null, status);
        List<QualifiedName> superTypeNames = nodeTypeDefinition.getSupertypes();
        if (Utils.isEmpty(superTypeNames)) {
            if (nodeTypeDefinition.getState(NodeTypeDefinition.PropertyName.SUPERTYPES) == AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(195, NLS.bind((String)Messages.emptySuperTypes, (Object)nodeTypeDefinitionName)));
            }
        } else {
            CndValidator.validateSuperTypes(nodeTypeDefinitionName, validNamespacePrefixes, nodeTypeDefinition.getState(NodeTypeDefinition.PropertyName.SUPERTYPES), superTypeNames, status);
            if (cnd != null) {
                for (QualifiedName superType : nodeTypeDefinition.getSupertypes()) {
                    status.add(CndValidator.validateSuperType(nodeTypeDefinition, superType.get(), cnd));
                }
            }
        }
        QualifiedName primaryItemName = nodeTypeDefinition.getPrimaryItem();
        if (nodeTypeDefinition.getState(NodeTypeDefinition.PropertyName.PRIMARY_ITEM) == AttributeState.Value.IS) {
            CndValidator.validateQualifiedName(primaryItemName, Messages.primaryItemName, validNamespacePrefixes, null, status);
        } else if (!Utils.isEmpty(primaryItemName.get())) {
            status.add(ValidationStatus.createErrorMessage(200, NLS.bind((String)Messages.primaryItemExistsButMarkedAsVariant, (Object)nodeTypeDefinitionName)));
        }
        if (validateEachPropertyAndChildNode) {
            List<ChildNodeDefinition> childNodeDefinitions;
            List<PropertyDefinition> propertyDefinitions = nodeTypeDefinition.getPropertyDefinitions();
            if (!Utils.isEmpty(propertyDefinitions)) {
                CndValidator.validatePropertyDefinitions(nodeTypeDefinitionName, validNamespacePrefixes, propertyDefinitions, status);
            }
            if (!Utils.isEmpty(childNodeDefinitions = nodeTypeDefinition.getChildNodeDefinitions())) {
                CndValidator.validateChildNodeDefinitions(nodeTypeDefinitionName, validNamespacePrefixes, childNodeDefinitions, status);
            }
        }
        return status;
    }

    public static MultiValidationStatus validateNodeTypeDefinitions(CompactNodeTypeDefinition cnd, boolean validateEachPropertyAndChildNode) {
        Utils.verifyIsNotNull(cnd, "cnd");
        List<NodeTypeDefinition> nodeTypeDefinitions = cnd.getNodeTypeDefinitions();
        if (Utils.isEmpty(nodeTypeDefinitions)) {
            return MultiValidationStatus.OK_STATUS;
        }
        MultiValidationStatus status = new MultiValidationStatus();
        ArrayList<String> names = new ArrayList<String>(nodeTypeDefinitions.size());
        for (NodeTypeDefinition nodeTypeDefinition : nodeTypeDefinitions) {
            status.add(CndValidator.validateNodeTypeDefinition(nodeTypeDefinition, cnd, validateEachPropertyAndChildNode));
            String name = nodeTypeDefinition.getName();
            if (Utils.isEmpty(name)) continue;
            if (names.contains(name)) {
                status.add(ValidationStatus.createErrorMessage(205, NLS.bind((String)Messages.duplicateNodeTypeDefinitionName, (Object)name)));
                continue;
            }
            names.add(name);
        }
        return status;
    }

    public static void validateNodeTypeDefinitions(CompactNodeTypeDefinition cnd, boolean validateEachPropertyAndChildNode, MultiValidationStatus status) {
        Utils.verifyIsNotNull(cnd, "cnd");
        MultiValidationStatus newStatus = CndValidator.validateNodeTypeDefinitions(cnd, validateEachPropertyAndChildNode);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static ValidationStatus validatePath(String path, String propertyName) {
        Utils.verifyIsNotNull(propertyName, "propertyName");
        if (Utils.isEmpty(propertyName)) {
            propertyName = Messages.missingName;
        }
        if (Utils.isEmpty(path)) {
            return ValidationStatus.createErrorMessage(100, NLS.bind((String)Messages.emptyValue, (Object)propertyName));
        }
        StringTokenizer pathTokenizer = new StringTokenizer(path, "/");
        if (pathTokenizer.hasMoreTokens()) {
            while (pathTokenizer.hasMoreElements()) {
                QualifiedName qname;
                MultiValidationStatus status;
                String segment = pathTokenizer.nextToken();
                if (Utils.isEmpty(segment)) {
                    if (!pathTokenizer.hasMoreTokens()) continue;
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)path, (Object)PropertyType.PATH));
                }
                StringTokenizer segmentTokenizer = new StringTokenizer(segment, "[]");
                if (segmentTokenizer.countTokens() == 2) {
                    String qualifiedName = segmentTokenizer.nextToken();
                    if (Utils.isEmpty(qualifiedName)) {
                        return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)path, (Object)PropertyType.PATH));
                    }
                    if (PARENT_PATH_SEGMENT.equals(qualifiedName) || SELF_PATH_SEGMENT.equals(qualifiedName)) continue;
                    QualifiedName qname2 = QualifiedName.parse(qualifiedName);
                    MultiValidationStatus status2 = CndValidator.validateQualifiedName(qname2, propertyName, null, null);
                    if (status2.isError()) {
                        return status2;
                    }
                    if (segmentTokenizer.countTokens() == 1) {
                        String snsIndex = segmentTokenizer.nextToken();
                        char[] cArray = snsIndex.toCharArray();
                        int n = cArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char c = cArray[n2];
                            if (!Character.isDigit(c)) {
                                return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)path, (Object)PropertyType.PATH));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    return ValidationStatus.createErrorMessage(105, NLS.bind((String)Messages.invalidPropertyValueForType, (Object)path, (Object)PropertyType.PATH));
                }
                if (PARENT_PATH_SEGMENT.equals(segment) || SELF_PATH_SEGMENT.equals(segment) || !(status = CndValidator.validateQualifiedName(qname = QualifiedName.parse(segment), propertyName, null, null)).isError()) continue;
                return status;
            }
        } else {
            QualifiedName qname = QualifiedName.parse(path);
            return CndValidator.validateQualifiedName(qname, propertyName, null, null);
        }
        return ValidationStatus.OK_STATUS;
    }

    public static MultiValidationStatus validatePropertyDefinition(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingPropertyNames) {
        Utils.verifyIsNotNull(propertyDefinition, "propertyDefinition");
        MultiValidationStatus status = new MultiValidationStatus();
        String propertyDefinitionName = propertyDefinition.getName();
        if (Utils.isEmpty(propertyDefinitionName)) {
            propertyDefinitionName = Messages.missingName;
        }
        CndValidator.validateName(propertyDefinition, validNamespacePrefixes, existingPropertyNames, status);
        CndValidator.validateDefaultValues(propertyDefinition, validNamespacePrefixes, status);
        CndValidator.validateValueConstraints(propertyDefinition, status);
        Object[] queryOperators = propertyDefinition.getAvailableQueryOperators();
        if (Utils.isEmpty(queryOperators)) {
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.QUERY_OPS) == AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(210, NLS.bind((String)Messages.emptyQueryOperators, (Object)propertyDefinitionName)));
            }
        } else {
            ArrayList<Object> operators = new ArrayList<Object>(queryOperators.length);
            Object[] objectArray = queryOperators;
            int n = queryOperators.length;
            int n2 = 0;
            while (n2 < n) {
                Object operator = objectArray[n2];
                CndValidator.validateQueryOperator((String)operator, propertyDefinitionName, status);
                if (!Utils.isEmpty((String)operator)) {
                    if (operators.contains(operator)) {
                        status.add(ValidationStatus.createErrorMessage(215, NLS.bind((String)Messages.duplicateQueryOperator, (Object)propertyDefinitionName, (Object)operator)));
                    } else {
                        operators.add(operator);
                    }
                }
                ++n2;
            }
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.QUERY_OPS) != AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(220, NLS.bind((String)Messages.queryOperatorsExistButMarkedAsVariant, (Object)propertyDefinition)));
            }
        }
        return status;
    }

    public static void validatePropertyDefinition(PropertyDefinition propertyDefinition, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingPropertyNames, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validatePropertyDefinition(propertyDefinition, validNamespacePrefixes, existingPropertyNames);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validatePropertyDefinitions(String nodeTypeName, Collection<String> validNamespacePrefixes, Collection<PropertyDefinition> propertyDefinitions) {
        Utils.verifyIsNotEmpty(nodeTypeName, "nodeTypeName");
        if (Utils.isEmpty(propertyDefinitions)) {
            return MultiValidationStatus.OK_STATUS;
        }
        MultiValidationStatus status = new MultiValidationStatus();
        ArrayList<String> propNames = new ArrayList<String>(propertyDefinitions.size());
        for (PropertyDefinition propertyDefn : propertyDefinitions) {
            CndValidator.validatePropertyDefinition(propertyDefn, validNamespacePrefixes, null, status);
            String propName = propertyDefn.getName();
            if (Utils.isEmpty(propName) || "*".equals(propName)) continue;
            if (propNames.contains(propName)) {
                status.add(ValidationStatus.createErrorMessage(225, NLS.bind((String)Messages.duplicatePropertyDefinitionName, (Object)nodeTypeName, (Object)propName)));
                continue;
            }
            propNames.add(propName);
        }
        return status;
    }

    public static void validatePropertyDefinitions(String nodeTypeName, Collection<String> validNamespacePrefixes, Collection<PropertyDefinition> propertyDefinitions, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validatePropertyDefinitions(nodeTypeName, validNamespacePrefixes, propertyDefinitions);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateQualifiedName(QualifiedName qname, String propertyName, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingQNames) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateQualifiedName(qname, propertyName, validNamespacePrefixes, existingQNames, status);
        return status;
    }

    public static void validateQualifiedName(QualifiedName qname, String propertyName, Collection<String> validNamespacePrefixes, Collection<QualifiedName> existingQNames, MultiValidationStatus status) {
        String unqualifiedName;
        String qualifier = qname.getQualifier();
        if (!Utils.isEmpty(qualifier)) {
            ValidationStatus qualifierStatus = CndValidator.validateLocalName(qualifier, propertyName);
            if (!qualifierStatus.isOk()) {
                status.add(qualifierStatus);
            } else if (Utils.isEmpty(validNamespacePrefixes) || !validNamespacePrefixes.contains(qualifier)) {
                ValidationStatus newStatus = ValidationStatus.createErrorMessage(235, NLS.bind((String)Messages.nameQualifierNotFound, (Object)propertyName, (Object)qualifier));
                status.add(newStatus);
            }
        }
        if (Utils.isEmpty(unqualifiedName = qname.getUnqualifiedName())) {
            status.add(ValidationStatus.createErrorMessage(230, NLS.bind((String)Messages.emptyUnqualifiedName, (Object)propertyName)));
        } else {
            ValidationStatus nameStatus = CndValidator.validateLocalName(unqualifiedName, propertyName);
            if (!nameStatus.isOk()) {
                status.add(nameStatus);
            }
        }
        if (!Utils.isEmpty(existingQNames) && existingQNames.contains(qname)) {
            ValidationStatus newStatus = ValidationStatus.createErrorMessage(240, NLS.bind((String)Messages.duplicateQualifiedName, (Object)propertyName, (Object)qname));
            status.add(newStatus);
        }
    }

    public static ValidationStatus validateQueryOperator(String operator, String propertyDefinitionName) {
        if (Utils.isEmpty(operator)) {
            return ValidationStatus.createErrorMessage(245, Messages.emptyQueryOperator);
        }
        try {
            QueryOperators.QueryOperator.find(operator);
        }
        catch (Exception exception) {
            return ValidationStatus.createErrorMessage(250, NLS.bind((String)Messages.invalidQueryOperator, (Object)operator, (Object)propertyDefinitionName));
        }
        return ValidationStatus.OK_STATUS;
    }

    public static void validateQueryOperator(String operator, String propertyDefinitionName, MultiValidationStatus status) {
        ValidationStatus newStatus = CndValidator.validateQueryOperator(operator, propertyDefinitionName);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateRequiredTypes(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateRequiredTypes(childNodeDefinition, validNamespacePrefixes, status);
        return status;
    }

    public static void validateRequiredTypes(ChildNodeDefinition childNodeDefinition, Collection<String> validNamespacePrefixes, MultiValidationStatus status) {
        Utils.verifyIsNotNull(childNodeDefinition, "childNodeDefinition");
        Utils.verifyIsNotNull(status, "status");
        Object[] requiredTypeNames = childNodeDefinition.getRequiredPrimaryTypeNames();
        String childNodeName = childNodeDefinition.getName();
        if (Utils.isEmpty(childNodeName)) {
            childNodeName = Messages.missingName;
        }
        if (Utils.isEmpty(requiredTypeNames)) {
            if (childNodeDefinition.getState(ChildNodeDefinition.PropertyName.REQUIRED_TYPES) == AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(255, NLS.bind((String)Messages.emptyRequiredTypes, (Object)childNodeName)));
            }
        } else {
            ArrayList<QualifiedName> requiredTypes = new ArrayList<QualifiedName>(requiredTypeNames.length);
            for (QualifiedName requiredType : childNodeDefinition.getRequiredTypes()) {
                CndValidator.validateQualifiedName(requiredType, Messages.requiredTypeName, validNamespacePrefixes, null, status);
                if (requiredTypes.contains(requiredType)) {
                    status.add(ValidationStatus.createErrorMessage(260, NLS.bind((String)Messages.duplicateRequiredType, (Object)childNodeName, (Object)requiredType)));
                    continue;
                }
                requiredTypes.add(requiredType);
            }
            if (childNodeDefinition.getState(ChildNodeDefinition.PropertyName.REQUIRED_TYPES) != AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(265, NLS.bind((String)Messages.requiredTypesExistButMarkedAsVariant, (Object)childNodeName)));
            }
        }
    }

    private static ValidationStatus validateSuperType(NodeTypeDefinition nodeTypeDefinition, String superTypeName, CompactNodeTypeDefinition cnd) {
        Utils.verifyIsNotNull(nodeTypeDefinition, "nodeTypeDefinition");
        Utils.verifyIsNotEmpty(superTypeName, "superTypeName");
        Utils.verifyIsNotNull(cnd, "cnd");
        if (nodeTypeDefinition.isMixin()) {
            NodeTypeDefinition superTypeNode = cnd.getNodeTypeDefinition(superTypeName);
            if (superTypeNode == null) {
                try {
                    superTypeNode = WorkspaceRegistry.get().getNodeTypeDefinition(superTypeName);
                }
                catch (Exception exception) {}
            }
            if (superTypeNode != null && !superTypeNode.isMixin()) {
                return ValidationStatus.createErrorMessage(305, NLS.bind((String)Messages.superTypeNotAMixin, (Object)nodeTypeDefinition.getName(), (Object)superTypeName));
            }
        }
        return ValidationStatus.OK_STATUS;
    }

    public static MultiValidationStatus validateSuperTypes(String nodeTypeDefinitionName, Collection<String> validNamespacePrefixes, AttributeState.Value superTypesState, Collection<QualifiedName> superTypeNames) {
        Utils.verifyIsNotEmpty(nodeTypeDefinitionName, "nodeTypeDefinitionName");
        Utils.verifyIsNotNull((Object)superTypesState, "superTypesState");
        if (Utils.isEmpty(superTypeNames)) {
            return MultiValidationStatus.OK_STATUS;
        }
        MultiValidationStatus status = new MultiValidationStatus();
        ArrayList<QualifiedName> names = new ArrayList<QualifiedName>(superTypeNames.size());
        for (QualifiedName superTypeName : superTypeNames) {
            CndValidator.validateQualifiedName(superTypeName, Messages.superTypeName, validNamespacePrefixes, null, status);
            if (nodeTypeDefinitionName.equals(superTypeName.get())) {
                status.add(ValidationStatus.createErrorMessage(310, NLS.bind((String)Messages.nodeTypeCannotBeSuperTypeOfItself, (Object)nodeTypeDefinitionName)));
                continue;
            }
            if (Utils.isEmpty(superTypeName.get())) continue;
            if (names.contains(superTypeName)) {
                status.add(ValidationStatus.createErrorMessage(270, NLS.bind((String)Messages.duplicateSuperType, (Object)nodeTypeDefinitionName, (Object)superTypeName)));
                continue;
            }
            names.add(superTypeName);
        }
        if (superTypesState != AttributeState.Value.IS) {
            status.add(ValidationStatus.createErrorMessage(275, NLS.bind((String)Messages.superTypesExistButMarkedAsVariant, (Object)nodeTypeDefinitionName)));
        }
        return status;
    }

    public static void validateSuperTypes(String nodeTypeDefinitionName, Collection<String> validNamespacePrefixes, AttributeState.Value superTypesState, Collection<QualifiedName> superTypeNames, MultiValidationStatus status) {
        MultiValidationStatus newStatus = CndValidator.validateSuperTypes(nodeTypeDefinitionName, validNamespacePrefixes, superTypesState, superTypeNames);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static ValidationStatus validateUri(String uri, String propertyName) {
        Utils.verifyIsNotEmpty(propertyName, "propertyName");
        if (Utils.isEmpty(uri) || uri.contains(" ")) {
            return ValidationStatus.createErrorMessage(100, NLS.bind((String)Messages.emptyValue, (Object)propertyName));
        }
        try {
            URI.create(uri);
        }
        catch (Exception exception) {
            return ValidationStatus.createErrorMessage(280, NLS.bind((String)Messages.invalidUri, (Object)propertyName));
        }
        return ValidationStatus.OK_STATUS;
    }

    public static ValidationStatus validateValueConstraint(String constraint) {
        try {
            Utils.verifyIsNotEmpty(constraint, "constraint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ValidationStatus.createErrorMessage(300, Messages.emptyValueConstraint);
        }
        return ValidationStatus.OK_STATUS;
    }

    public static void validateValueConstraint(String constraint, MultiValidationStatus status) {
        ValidationStatus newStatus = CndValidator.validateValueConstraint(constraint);
        if (!newStatus.isOk()) {
            status.add(newStatus);
        }
    }

    public static MultiValidationStatus validateValueConstraints(PropertyDefinition propertyDefinition) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateValueConstraints(propertyDefinition, status);
        return status;
    }

    public static void validateValueConstraints(PropertyDefinition propertyDefinition, MultiValidationStatus status) {
        Object[] valueConstraints;
        Utils.verifyIsNotNull(propertyDefinition, "propertyDefinition");
        Utils.verifyIsNotNull(status, "status");
        String propertyName = propertyDefinition.getName();
        if (Utils.isEmpty(propertyName)) {
            propertyName = Messages.missingName;
        }
        if (Utils.isEmpty(valueConstraints = propertyDefinition.getValueConstraints())) {
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.VALUE_CONSTRAINTS) == AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(285, NLS.bind((String)Messages.emptyValueConstraints, (Object)propertyName)));
            }
        } else {
            CndValidator.validateValueConstraints(propertyName, Arrays.asList(valueConstraints), status);
            if (propertyDefinition.getState(PropertyDefinition.PropertyName.VALUE_CONSTRAINTS) != AttributeState.Value.IS) {
                status.add(ValidationStatus.createErrorMessage(295, NLS.bind((String)Messages.valueConstraintsExistButMarkedAsVariant, (Object)propertyDefinition)));
            }
        }
    }

    public static MultiValidationStatus validateValueConstraints(String propertyName, Collection<String> valueConstraints) {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateValueConstraints(propertyName, valueConstraints, status);
        return status;
    }

    public static void validateValueConstraints(String propertyName, Collection<String> valueConstraints, MultiValidationStatus status) {
        if (propertyName == null) {
            propertyName = Messages.missingName;
        }
        if (!Utils.isEmpty(valueConstraints)) {
            ArrayList<String> constraints = new ArrayList<String>(valueConstraints.size());
            for (String constraint : valueConstraints) {
                CndValidator.validateValueConstraint(constraint, status);
                if (Utils.isEmpty(constraint)) continue;
                if (constraints.contains(constraint)) {
                    status.add(ValidationStatus.createErrorMessage(290, NLS.bind((String)Messages.duplicateValueConstraint, (Object)propertyName, (Object)constraint)));
                    continue;
                }
                constraints.add(constraint);
            }
        }
    }

    private CndValidator() {
    }

    public static interface StatusCodes {
        public static final int EMPTY_VALUE = 100;
        public static final int INVALID_PROPERTY_VALUE_FOR_TYPE = 105;
        public static final int ERROR_VALIDATING_PROPERTY_VALUE_FOR_TYPE = 110;
        public static final int DUPLICATE_CHILD_NODE_DEFINITION_NAME = 115;
        public static final int CND_HAS_NO_NAMESPACES_OR_NODE_TYPE_DEFINITIONS = 120;
        public static final int DEFAULT_TYPE_DOES_NOT_MATCH_REQUIRED_TYPE = 125;
        public static final int DEFAULT_TYPE_EXISTS_BUT_MARKED_AS_VARIANT = 130;
        public static final int EMPTY_DEFAULT_VALUES = 135;
        public static final int MULTIPLE_DEFAULT_VALUES_FOR_SINGLE_VALUED_PROPERTY = 140;
        public static final int INVALID_QUALIFIER_FOR_DEFAULT_VALUE = 145;
        public static final int DUPLICATE_DEFAULT_VALUE = 150;
        public static final int DEFAULT_VALUES_EXIST_BUT_MARKED_AS_VARIANT = 155;
        public static final int EMPTY_LOCAL_NAME = 160;
        public static final int LOCAL_NAME_EQUAL_TO_SELF_OR_PARENT = 165;
        public static final int LOCAL_NAME_HAS_INVALID_CHARACTERS = 170;
        public static final int INVALID_URI_FOR_BUILT_IN_NAMESPACE_PREFIX = 175;
        public static final int INVALID_PREFIX_FOR_BUILT_IN_NAMESPACE_URI = 180;
        public static final int DUPLICATE_NAMESPACE_PREFIX = 185;
        public static final int DUPLICATE_NAMESPACE_URI = 190;
        public static final int EMPTY_SUPER_TYPES = 195;
        public static final int PRIMARY_ITEM_EXISTS_BUT_MARKED_AS_VARIANT = 200;
        public static final int DUPLICATE_NODE_TYPE_DEFINITION_NAME = 205;
        public static final int EMPTY_QUERY_OPERATORS = 210;
        public static final int DUPLICATE_QUERY_OPERATOR = 215;
        public static final int QUERY_OPERATORS_EXIST_BUT_MARKED_AS_VARIANT = 220;
        public static final int DUPLICATE_PROPERTY_DEFINITION_NAME = 225;
        public static final int EMPTY_UNQUALIFIED_NAME = 230;
        public static final int NAME_QUALIFIER_NOT_FOUND = 235;
        public static final int DUPLICATE_QUALIFIED_NAME = 240;
        public static final int EMPTY_QUERY_OPERATOR = 245;
        public static final int INVALID_QUERY_OPERATOR = 250;
        public static final int EMPTY_REQUIRED_TYPES = 255;
        public static final int DUPLICATE_REQUIRED_TYPE = 260;
        public static final int REQUIRED_TYPES_EXIST_BUT_MARKED_AS_VARIANT = 265;
        public static final int DUPLICATE_SUPER_TYPE = 270;
        public static final int SUPER_TYPES_EXIST_BUT_MARKED_AS_VARIANT = 275;
        public static final int INVALID_URI = 280;
        public static final int EMPTY_VALUE_CONSTRAINTS = 285;
        public static final int DUPLICATE_VALUE_CONSTRAINT = 290;
        public static final int VALUE_CONSTRAINTS_EXIST_BUT_MARKED_AS_VARIANT = 295;
        public static final int EMPTY_VALUE_CONSTRAINT = 300;
        public static final int SUPER_TYPE_NOT_A_MIXIN = 305;
        public static final int NODE_TYPE_CANNOT_BE_SUPER_TYPE_OF_ITSELF = 310;
    }
}

