/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.cnd;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.text.ParsingException;
import org.jboss.tools.modeshape.jcr.text.Position;
import org.jboss.tools.modeshape.jcr.text.TokenStream;

public class CndTokenizer
implements TokenStream.Tokenizer {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 4;
    public static final int SINGLE_QUOTED_STRING = 8;
    public static final int DOUBLE_QUOTED_STRING = 16;
    public static final int COMMENT = 32;
    public static final int VENDOR_EXTENSION = 64;
    private final boolean useComments = true;
    private final boolean useVendorExtensions = false;

    @Override
    public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
        block8: while (input.hasNext()) {
            char c = input.next();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case ']': {
                    tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                    break;
                }
                case '{': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingBrace = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('}')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '}') continue;
                        foundClosingBrace = true;
                        break;
                    }
                    if (!foundClosingBrace) {
                        String msg = NLS.bind((String)Messages.vendorBlockWasNotClosed, (Object)startingPosition.getLine(), (Object)startingPosition.getColumn());
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    break;
                }
                case '\"': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('\"')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '\"') continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        throw new ParsingException(startingPosition, NLS.bind((String)Messages.noMatchingDoubleQuoteFound, (Object)startingPosition.getLine(), (Object)startingPosition.getColumn()));
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 16);
                    break;
                }
                case '\'': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('\'')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '\'') continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        throw new ParsingException(startingPosition, NLS.bind((String)Messages.noMatchingSingleQuoteFound, (Object)startingPosition.getLine(), (Object)startingPosition.getColumn()));
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 8);
                    break;
                }
                case '/': {
                    int endIndex;
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    if (input.isNext('/')) {
                        boolean foundLineTerminator = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c != '\n' && c != '\r') continue;
                            foundLineTerminator = true;
                            break;
                        }
                        endIndex = input.index();
                        if (!foundLineTerminator) {
                            ++endIndex;
                        }
                        if (c == '\r' && input.isNext('\n')) {
                            input.next();
                        }
                        tokens.addToken(startingPosition, startIndex, endIndex, 32);
                        break;
                    }
                    if (!input.isNext('*')) continue block8;
                    while (input.hasNext() && !input.isNext('*', '/')) {
                        c = input.next();
                    }
                    if (input.hasNext()) {
                        input.next();
                    }
                    if (input.hasNext()) {
                        input.next();
                    }
                    endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 32);
                    break;
                }
                default: {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("[]<>=-+(),\"'/{*|")) {
                        c = input.next();
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 1);
                }
            }
        }
    }
}

