/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public enum PropertyType implements CndElement
{
    BINARY(2),
    BOOLEAN(6),
    DATE(5),
    DECIMAL(12),
    DOUBLE(4),
    LONG(3),
    NAME(7),
    PATH(8),
    REFERENCE(9),
    STRING(1),
    UNDEFINED(0),
    URI(11),
    VARIANT(-1),
    WEAKREFERENCE(10);

    public static final PropertyType DEFAULT_VALUE;
    public static final String NOTATION_PREFIX = "(";
    public static final String NOTATION_SUFFIX = ")";
    public static final String UNDEFINED_ADDITIONAL_NOTATION = "*";
    private final int jcrValue;

    static {
        DEFAULT_VALUE = STRING;
    }

    public static PropertyType find(String cndNotation) {
        Utils.verifyIsNotEmpty(cndNotation, "cndNotation");
        if (UNDEFINED_ADDITIONAL_NOTATION.equals(cndNotation)) {
            return UNDEFINED;
        }
        PropertyType[] propertyTypeArray = PropertyType.values();
        int n = propertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType type = propertyTypeArray[n2];
            if (VARIANT != type && type.toString().equalsIgnoreCase(cndNotation)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindRequest, (Object)cndNotation));
    }

    public static PropertyType findUsingJcrValue(int propertyType) {
        PropertyType[] propertyTypeArray = PropertyType.values();
        int n = propertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType type = propertyTypeArray[n2];
            if (type.asJcrValue() == propertyType) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindUsingJcrValueRequest, (Object)propertyType));
    }

    public static String[] validValues() {
        PropertyType[] allTypes = PropertyType.values();
        String[] result = new String[allTypes.length];
        int i = 0;
        PropertyType[] propertyTypeArray = allTypes;
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType type = propertyTypeArray[n2];
            if (type != VARIANT) {
                result[i++] = type.toString();
            }
            ++n2;
        }
        result[i] = UNDEFINED_ADDITIONAL_NOTATION;
        return result;
    }

    private PropertyType(int propertyType) {
        this.jcrValue = propertyType;
    }

    public int asJcrValue() {
        return this.jcrValue;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder(NOTATION_PREFIX);
        if (this == VARIANT) {
            builder.append('?');
        } else if (this == UNDEFINED && CndElement.NotationType.LONG != notationType) {
            builder.append(UNDEFINED_ADDITIONAL_NOTATION);
        } else {
            builder.append(this.toString());
        }
        return builder.append(NOTATION_SUFFIX).toString();
    }
}

