/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public abstract class ListAttributeState<E extends Comparable>
extends AttributeState {
    public static final String[] ITEM_DELIM_NOTATION = new String[]{", ", ",", ","};
    public static final String[] PREFIX_END_DELIM_NOTATION = new String[]{" ", "", ""};
    private List<E> supported;

    public boolean add(E item) {
        Utils.verifyIsNotNull(item, "item");
        if (this.supported == null) {
            this.supported = new ArrayList();
        }
        boolean added = false;
        if (!this.supported.contains(item)) {
            added = this.supported.add(item);
        }
        if (added && !this.is()) {
            super.set(AttributeState.Value.IS);
        }
        return added;
    }

    public boolean clear() {
        boolean cleared = false;
        if (this.supported != null) {
            cleared = !this.supported.isEmpty();
            this.supported = null;
        }
        if (!this.isNot()) {
            super.set(AttributeState.Value.IS_NOT);
        }
        return cleared;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ListAttributeState that = (ListAttributeState)obj;
        List<E> thatSupportedItems = that.getSupportedItems();
        List<E> thisSupportedItems = this.getSupportedItems();
        if (Utils.isEmpty(thisSupportedItems)) {
            return Utils.isEmpty(thatSupportedItems);
        }
        if (Utils.isEmpty(thatSupportedItems)) {
            return false;
        }
        if (thisSupportedItems.size() != thatSupportedItems.size()) {
            return false;
        }
        return thisSupportedItems.containsAll(thatSupportedItems);
    }

    public boolean exists(E item) {
        Utils.verifyIsNotNull(item, "item");
        return this.getSupportedItems().contains(item);
    }

    protected abstract String getCndNotationPrefix(CndElement.NotationType var1);

    protected String getCndNotationSuffix(CndElement.NotationType notationType) {
        return "";
    }

    @Override
    protected String getCompactCndNotation() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getCompressedCndNotation() {
        throw new UnsupportedOperationException();
    }

    protected String getItemQuoteCharacter() {
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        return prefStore.get(JcrPreferenceConstants.CndPreference.ATTRIBUTE_LIST_ITEM_QUOTE_CHAR);
    }

    @Override
    protected String getLongCndNotation() {
        throw new UnsupportedOperationException();
    }

    protected String getPrefixEndDelimiter(CndElement.NotationType notationType) {
        if (CndElement.NotationType.LONG == notationType) {
            return PREFIX_END_DELIM_NOTATION[0];
        }
        if (CndElement.NotationType.COMPRESSED == notationType) {
            return PREFIX_END_DELIM_NOTATION[1];
        }
        return PREFIX_END_DELIM_NOTATION[2];
    }

    public List<E> getSupportedItems() {
        if (this.supported == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.supported);
    }

    @Override
    protected boolean hasCndNotation() {
        return !this.isNot();
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getSupportedItems());
    }

    public boolean remove(E item) {
        Utils.verifyIsNotNull(item, "item");
        if (this.supported == null) {
            return false;
        }
        boolean removed = this.supported.remove(item);
        if (this.supported.isEmpty()) {
            this.supported = null;
            if (this.is()) {
                super.set(AttributeState.Value.IS_NOT);
            }
        }
        return removed;
    }

    @Override
    public final boolean set(AttributeState.Value newState) {
        if (AttributeState.Value.VARIANT == newState) {
            this.clear();
            return super.set(AttributeState.Value.VARIANT);
        }
        return false;
    }

    protected String supportedItemsCndNotation(CndElement.NotationType notationType) {
        ArrayList<E> items = new ArrayList<E>(this.getSupportedItems());
        Collections.sort(items);
        if (items.isEmpty()) {
            return "";
        }
        String delimiter = null;
        delimiter = CndElement.NotationType.LONG == notationType ? ITEM_DELIM_NOTATION[0] : (CndElement.NotationType.COMPRESSED == notationType ? ITEM_DELIM_NOTATION[1] : ITEM_DELIM_NOTATION[2]);
        String itemQuote = this.getItemQuoteCharacter();
        boolean useQuote = !Utils.isEmpty(itemQuote);
        StringBuilder builder = new StringBuilder();
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            Comparable item = (Comparable)itr.next();
            if (useQuote) {
                builder.append(itemQuote);
            }
            if (item instanceof CndElement) {
                builder.append(((CndElement)((Object)item)).toCndNotation(notationType));
            } else {
                builder.append(item.toString());
            }
            if (useQuote) {
                builder.append(itemQuote);
            }
            if (!itr.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public boolean supports(E item) {
        Utils.verifyIsNotNull(item, "item");
        return this.getSupportedItems().contains(item);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        if (this.hasCndNotation()) {
            StringBuilder builder = new StringBuilder();
            if (!Utils.isEmpty(this.getCndNotationPrefix(notationType))) {
                builder.append(this.getCndNotationPrefix(notationType));
            }
            builder.append(this.getPrefixEndDelimiter(notationType));
            if (this.isVariant()) {
                builder.append('?');
            } else {
                builder.append(this.supportedItemsCndNotation(notationType));
            }
            if (!Utils.isEmpty(this.getCndNotationSuffix(notationType))) {
                builder.append(this.getCndNotationSuffix(notationType));
            }
            return builder.toString();
        }
        return "";
    }
}

