/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public class DefaultType
extends AttributeState {
    public static final String NOTATION = "=";
    private final QualifiedName defaultType = new QualifiedName();

    @Override
    public AttributeState.Value get() {
        AttributeState.Value state = super.get();
        if (state == AttributeState.Value.VARIANT) {
            return AttributeState.Value.VARIANT;
        }
        if (Utils.isEmpty(this.defaultType.get())) {
            return AttributeState.Value.IS_NOT;
        }
        return AttributeState.Value.IS;
    }

    @Override
    protected String getCompactCndNotation() {
        return this.getNotation(CndElement.NotationType.COMPACT);
    }

    @Override
    protected String getCompressedCndNotation() {
        return this.getNotation(CndElement.NotationType.COMPRESSED);
    }

    public QualifiedName getDefaultType() {
        return this.defaultType;
    }

    public String getDefaultTypeName() {
        String defaultTypeName = this.defaultType.get();
        if (Utils.isEmpty(defaultTypeName)) {
            return null;
        }
        return defaultTypeName;
    }

    @Override
    protected String getLongCndNotation() {
        return this.getNotation(CndElement.NotationType.LONG);
    }

    private String getNotation(CndElement.NotationType notationType) {
        if (this.isVariant()) {
            return this.getPrefix(notationType);
        }
        String defaultType = this.getDefaultTypeName();
        if (Utils.isEmpty(defaultType)) {
            return "";
        }
        return String.valueOf(this.getPrefix(notationType)) + defaultType;
    }

    private String getPrefix(CndElement.NotationType notationType) {
        String delim = CndElement.NotationType.LONG == notationType ? " " : "";
        return Utils.isEmpty(delim) ? NOTATION : NOTATION + delim;
    }

    @Override
    public boolean set(AttributeState.Value newState) {
        return newState == AttributeState.Value.VARIANT && super.set(AttributeState.Value.VARIANT);
    }

    public boolean setDefaultType(String newDefaultType) {
        if (this.defaultType.set(newDefaultType)) {
            if (Utils.isEmpty(newDefaultType) && !this.isVariant()) {
                super.set(AttributeState.Value.IS_NOT);
            } else {
                super.set(AttributeState.Value.IS);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String toVariantCndNotation(String cndNotation) {
        return String.valueOf(cndNotation) + '?';
    }
}

