/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public abstract class AttributeState
implements CndElement {
    public static final char VARIANT_CHAR = '?';
    public static final String VARIANT_STRING = Character.toString('?');
    private Value state = Value.IS_NOT;

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AttributeState that = (AttributeState)obj;
        return this.state == that.state;
    }

    public Value get() {
        return this.state;
    }

    protected abstract String getCompactCndNotation();

    protected abstract String getCompressedCndNotation();

    protected abstract String getLongCndNotation();

    protected boolean hasCndNotation() {
        return !this.isNot();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean is() {
        return this.state == Value.IS;
    }

    public boolean isNot() {
        return this.state == Value.IS_NOT;
    }

    public boolean isVariant() {
        return this.state == Value.VARIANT;
    }

    public boolean set(Value newState) {
        Utils.verifyIsNotNull((Object)newState, "newState");
        if (this.state != newState) {
            this.state = newState;
            return true;
        }
        return false;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        if (this.hasCndNotation()) {
            String notation = "";
            if (CndElement.NotationType.LONG == notationType) {
                notation = this.getLongCndNotation();
            } else if (CndElement.NotationType.COMPRESSED == notationType) {
                notation = this.getCompressedCndNotation();
            } else if (CndElement.NotationType.COMPACT == notationType) {
                notation = this.getCompactCndNotation();
            }
            if (this.isVariant()) {
                return this.toVariantCndNotation(notation);
            }
            return notation;
        }
        return "";
    }

    protected String toVariantCndNotation(String cndNotation) {
        if (Utils.isEmpty(cndNotation)) {
            return String.valueOf('?');
        }
        return String.valueOf(cndNotation) + '?';
    }

    public static enum Value {
        IS,
        IS_NOT,
        VARIANT;

    }
}

