/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import org.jboss.tools.modeshape.jcr.LocalName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public class QualifiedName
implements CndElement,
Comparable<QualifiedName> {
    public static final char DELIM = ':';
    public static final String DELIM_STRING = Character.toString(':');
    private final LocalName name;
    private final LocalName qualifier = new LocalName();

    public static QualifiedName parse(String qualifiedName) {
        String qualifier = "";
        String name = "";
        if (!Utils.isEmpty(qualifiedName)) {
            int index = qualifiedName.indexOf(DELIM_STRING);
            if (index == -1 || qualifiedName.length() == 1) {
                name = qualifiedName;
            } else {
                qualifier = qualifiedName.substring(0, index);
                if (index + 1 <= qualifiedName.length()) {
                    name = qualifiedName.substring(index + 1);
                }
            }
        }
        return new QualifiedName(qualifier, name);
    }

    public QualifiedName() {
        this.name = new LocalName();
    }

    public QualifiedName(String initialQualifier, String initialUnqualifiedName) {
        this();
        this.qualifier.set(initialQualifier);
        this.name.set(initialUnqualifiedName);
    }

    @Override
    public int compareTo(QualifiedName that) {
        if (this.equals(that)) {
            return 0;
        }
        int qualifierResult = this.qualifier.compareTo(that.qualifier);
        int nameResult = this.name.compareTo(that.name);
        if (qualifierResult < 0) {
            if (nameResult < 0) {
                return -1000;
            }
            if (nameResult == 0) {
                return -100;
            }
            return -10;
        }
        if (qualifierResult == 0) {
            if (nameResult < 0) {
                return -1;
            }
            if (nameResult == 0) {
                return 0;
            }
            return 1;
        }
        if (nameResult < 0) {
            return 10;
        }
        if (nameResult == 0) {
            return 100;
        }
        return 1000;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        QualifiedName that = (QualifiedName)obj;
        return this.qualifier.equals(that.qualifier) && this.name.equals(that.name);
    }

    public String get() {
        String nameString;
        StringBuilder builder = new StringBuilder();
        String qualifierString = this.getQualifier() == null ? "" : this.getQualifier();
        String string = nameString = this.getUnqualifiedName() == null ? "" : this.getUnqualifiedName();
        if (!Utils.isEmpty(qualifierString)) {
            builder.append(qualifierString);
            builder.append(':');
        }
        if (!Utils.isEmpty(nameString)) {
            builder.append(nameString);
        }
        return builder.toString();
    }

    public String getQualifier() {
        return this.qualifier.get();
    }

    public String getUnqualifiedName() {
        return this.name.get();
    }

    public int hashCode() {
        return Utils.hashCode(this.qualifier, this.name);
    }

    public boolean set(String newQualifiedName) {
        QualifiedName temp = QualifiedName.parse(newQualifiedName);
        boolean qualifierChanged = this.setQualifier(temp.getQualifier());
        boolean nameChanged = this.setUnqualifiedName(temp.getUnqualifiedName());
        return qualifierChanged || nameChanged;
    }

    public boolean setQualifier(String newQualifier) {
        return this.qualifier.set(newQualifier);
    }

    public boolean setUnqualifiedName(String newUnqualifiedName) {
        return this.name.set(newUnqualifiedName);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(this.qualifier.get())) {
            builder.append(this.qualifier.toCndNotation(notationType));
            builder.append(':');
        }
        if (!Utils.isEmpty(this.name.get())) {
            builder.append(this.name.toCndNotation(notationType));
        }
        return builder.toString();
    }

    public String toString() {
        return this.get();
    }
}

