/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.ItemDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.NodeTypeAttributes;
import org.jboss.tools.modeshape.jcr.attributes.SuperTypes;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class NodeTypeDefinition
implements CommentedCndElement,
Comparable<NodeTypeDefinition>,
ItemOwnerProvider,
JcrModelObject,
NodeTypeTemplate {
    public static final String NAME_NOTATION_PREFIX = "[";
    public static final String NAME_NOTATION_SUFFIX = "]";
    private final NodeTypeAttributes attributes = new NodeTypeAttributes();
    private List<CndElement> cndElements;
    private String comment;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private final QualifiedName name = new QualifiedName();
    private final SuperTypes superTypes = new SuperTypes();

    public static NodeTypeDefinition copy(NodeTypeDefinition nodeTypeToCopy) {
        Utils.verifyIsNotNull(nodeTypeToCopy, "nodeTypeToCopy");
        NodeTypeDefinition copy = new NodeTypeDefinition();
        copy.setName(nodeTypeToCopy.getName());
        copy.comment = nodeTypeToCopy.comment;
        copy.attributes.setAbstract(nodeTypeToCopy.attributes.getAbstract().get());
        copy.attributes.setMixin(nodeTypeToCopy.attributes.getMixin().get());
        copy.attributes.setOrderable(nodeTypeToCopy.attributes.getOrderable().get());
        copy.attributes.setQueryable(nodeTypeToCopy.attributes.getQueryable().get());
        copy.attributes.setPrimaryItem(nodeTypeToCopy.getPrimaryItemName());
        copy.attributes.getPrimaryItem().set(nodeTypeToCopy.attributes.getPrimaryItem().get());
        for (ChildNodeDefinition childNode : nodeTypeToCopy.getChildNodeDefinitions()) {
            copy.addChildNodeDefinition(ChildNodeDefinition.copy(childNode, copy));
        }
        for (PropertyDefinition property : nodeTypeToCopy.getPropertyDefinitions()) {
            copy.addPropertyDefinition(PropertyDefinition.copy(property, copy));
        }
        copy.superTypes.set(nodeTypeToCopy.superTypes.get());
        for (QualifiedName supertype : nodeTypeToCopy.getSupertypes()) {
            copy.addSuperType(supertype.get());
        }
        return copy;
    }

    public NodeTypeDefinition() {
        this.listeners = new CopyOnWriteArrayList();
    }

    public boolean addChildNodeDefinition(ChildNodeDefinition childNodeDefinitionBeingAdded) {
        Utils.verifyIsNotNull(childNodeDefinitionBeingAdded, "childNodeDefinitionBeingAdded");
        if (this.cndElements == null) {
            this.cndElements = new ArrayList<CndElement>();
        }
        if (this.cndElements.add(childNodeDefinitionBeingAdded)) {
            this.notifyChangeListeners(PropertyName.CHILD_NODES, null, childNodeDefinitionBeingAdded);
            return true;
        }
        return false;
    }

    public boolean addListener(PropertyChangeListener newListener) {
        Utils.verifyIsNotNull(newListener, "newListener");
        return this.listeners.addIfAbsent(newListener);
    }

    public boolean addPropertyDefinition(PropertyDefinition properyDefinitionBeingAdded) {
        Utils.verifyIsNotNull(properyDefinitionBeingAdded, "properyDefinitionBeingAdded");
        if (this.cndElements == null) {
            this.cndElements = new ArrayList<CndElement>();
        }
        if (this.cndElements.add(properyDefinitionBeingAdded)) {
            this.notifyChangeListeners(PropertyName.PROPERTY_DEFINITIONS, null, properyDefinitionBeingAdded);
            return true;
        }
        return false;
    }

    public boolean addSuperType(String superTypeBeingAdded) {
        Utils.verifyIsNotEmpty(superTypeBeingAdded, "superTypeBeingAdded");
        if (this.superTypes.add(QualifiedName.parse(superTypeBeingAdded))) {
            this.notifyChangeListeners(PropertyName.SUPERTYPES, null, superTypeBeingAdded);
            return true;
        }
        return false;
    }

    public boolean changeState(PropertyName propertyName, AttributeState.Value newState) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        Utils.verifyIsNotNull((Object)newState, "newState");
        AttributeState.Value oldValue = null;
        AttributeState.Value newValue = newState;
        boolean changed = false;
        if (PropertyName.ABSTRACT == propertyName) {
            oldValue = this.attributes.getAbstract().get();
            changed = this.attributes.getAbstract().set(newState);
        } else if (PropertyName.MIXIN == propertyName) {
            oldValue = this.attributes.getMixin().get();
            changed = this.attributes.getMixin().set(newState);
        } else if (PropertyName.ORDERABLE == propertyName) {
            oldValue = this.attributes.getOrderable().get();
            changed = this.attributes.getOrderable().set(newState);
        } else if (PropertyName.PRIMARY_ITEM == propertyName) {
            oldValue = this.attributes.getPrimaryItem().get();
            changed = this.attributes.getPrimaryItem().set(newState);
        } else if (PropertyName.QUERYABLE == propertyName) {
            oldValue = this.attributes.getQueryable().get();
            changed = this.attributes.getQueryable().set(newState);
        } else if (PropertyName.SUPERTYPES == propertyName) {
            oldValue = this.superTypes.get();
            changed = this.superTypes.set(newState);
        }
        if (changed) {
            this.notifyChangeListeners(propertyName, (Object)oldValue, (Object)newValue);
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(NodeTypeDefinition that) {
        String thisName = this.getName();
        String thatName = that.getName();
        if (Utils.isEmpty(thisName)) {
            if (Utils.isEmpty(thatName)) {
                return 0;
            }
            return 1;
        }
        if (Utils.isEmpty(thatName)) {
            return -1;
        }
        return thisName.compareTo(thatName);
    }

    public boolean equals(Object obj) {
        List<PropertyDefinition> thatProps;
        List<ChildNodeDefinition> thatChildNodes;
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        NodeTypeDefinition that = (NodeTypeDefinition)obj;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        List<ChildNodeDefinition> thisChildNodes = this.getChildNodeDefinitions();
        if (!Utils.equivalent(thisChildNodes, thatChildNodes = that.getChildNodeDefinitions())) {
            return false;
        }
        List<PropertyDefinition> thisProps = this.getPropertyDefinitions();
        if (!Utils.equivalent(thisProps, thatProps = that.getPropertyDefinitions())) {
            return false;
        }
        if (!this.superTypes.equals(that.superTypes)) {
            return false;
        }
        return Utils.equals(this.comment, that.comment);
    }

    public List<ChildNodeDefinition> getChildNodeDefinitions() {
        if (this.cndElements == null) {
            return Collections.emptyList();
        }
        ArrayList<ChildNodeDefinition> childNodeDefinitions = new ArrayList<ChildNodeDefinition>();
        for (CndElement element : this.cndElements) {
            if (!(element instanceof ChildNodeDefinition)) continue;
            childNodeDefinitions.add((ChildNodeDefinition)element);
        }
        return childNodeDefinitions;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        List<ChildNodeDefinition> childNodes = this.getChildNodeDefinitions();
        return childNodes.toArray(new NodeDefinition[childNodes.size()]);
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        List<PropertyDefinition> propDefns = this.getPropertyDefinitions();
        return propDefns.toArray(new PropertyDefinition[propDefns.size()]);
    }

    public String[] getDeclaredSupertypeNames() {
        return this.superTypes.toArray();
    }

    private List<CndElement> getElements() {
        if (this.cndElements == null) {
            return Collections.emptyList();
        }
        return this.cndElements;
    }

    public List<ItemDefinition> getItemDefinitions() {
        if (this.cndElements == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        for (CndElement element : this.cndElements) {
            if (!(element instanceof ItemDefinition)) continue;
            itemDefinitions.add((ItemDefinition)element);
        }
        return itemDefinitions;
    }

    public String getName() {
        return this.name.get();
    }

    public List getNodeDefinitionTemplates() {
        return new ArrayList<ChildNodeDefinition>(this.getChildNodeDefinitions());
    }

    @Override
    public QualifiedName getOwnerQualifiedName() {
        return this.getQualifiedName();
    }

    public QualifiedName getPrimaryItem() {
        return this.attributes.getPrimaryItem().getPrimaryItem();
    }

    public String getPrimaryItemName() {
        String primaryItem = this.attributes.getPrimaryItem().getPrimaryItem().get();
        if (Utils.isEmpty(primaryItem)) {
            return null;
        }
        return primaryItem;
    }

    public List<PropertyDefinition> getPropertyDefinitions() {
        if (this.cndElements == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
        for (CndElement element : this.cndElements) {
            if (!(element instanceof PropertyDefinition)) continue;
            propertyDefinitions.add((PropertyDefinition)element);
        }
        return propertyDefinitions;
    }

    public List getPropertyDefinitionTemplates() {
        return new ArrayList<PropertyDefinition>(this.getPropertyDefinitions());
    }

    public QualifiedName getQualifiedName() {
        return this.name;
    }

    public AttributeState.Value getState(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        if (PropertyName.ABSTRACT == propertyName) {
            return this.attributes.getAbstract().get();
        }
        if (PropertyName.MIXIN == propertyName) {
            return this.attributes.getMixin().get();
        }
        if (PropertyName.ORDERABLE == propertyName) {
            return this.attributes.getOrderable().get();
        }
        if (PropertyName.PRIMARY_ITEM == propertyName) {
            return this.attributes.getPrimaryItem().get();
        }
        if (PropertyName.QUERYABLE == propertyName) {
            return this.attributes.getQueryable().get();
        }
        if (PropertyName.SUPERTYPES == propertyName) {
            return this.superTypes.get();
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidGetStateRequest, (Object)((Object)propertyName)));
    }

    public List<QualifiedName> getSupertypes() {
        return this.superTypes.getSupportedItems();
    }

    public boolean hasDeclaredChildNodeDefinition(String name) {
        Utils.verifyIsNotEmpty(name, "name");
        for (ChildNodeDefinition childNode : this.getChildNodeDefinitions()) {
            if (!name.equals(childNode.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredPropertyDefinition(String name) {
        Utils.verifyIsNotEmpty(name, "name");
        for (PropertyDefinition prop : this.getPropertyDefinitions()) {
            if (!name.equals(prop.getName())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result1 = Utils.hashCode(this.name, this.attributes, this.superTypes, this.comment);
        int result2 = Utils.hashCode(this.getElements().toArray());
        return Utils.hashCode(result1, result2);
    }

    public boolean hasOrderableChildNodes() {
        return this.attributes.getOrderable().is();
    }

    public boolean isAbstract() {
        return this.attributes.getAbstract().is();
    }

    public boolean isMixin() {
        return this.attributes.getMixin().is();
    }

    public boolean isQueryable() {
        return this.attributes.getQueryable().is();
    }

    public boolean isVariant(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        return this.getState(propertyName) == AttributeState.Value.VARIANT;
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception exception) {
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeChildNodeDefinition(ChildNodeDefinition childNodeDefinitionBeingRemoved) {
        Utils.verifyIsNotNull(childNodeDefinitionBeingRemoved, "childNodeDefinitionBeingRemoved");
        List<ChildNodeDefinition> childNodeDefinitions = this.getChildNodeDefinitions();
        if (childNodeDefinitions.isEmpty()) {
            return false;
        }
        if (this.cndElements.remove(childNodeDefinitionBeingRemoved)) {
            this.notifyChangeListeners(PropertyName.CHILD_NODES, childNodeDefinitionBeingRemoved, null);
            if (this.cndElements.isEmpty()) {
                this.cndElements = null;
            }
            return true;
        }
        return false;
    }

    public boolean removeListener(PropertyChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        return this.listeners.remove(listener);
    }

    public boolean removePropertyDefinition(PropertyDefinition propertyDefinitionBeingRemoved) {
        Utils.verifyIsNotNull(propertyDefinitionBeingRemoved, "propertyDefinitionBeingRemoved");
        List<PropertyDefinition> propertyDefinitions = this.getPropertyDefinitions();
        if (propertyDefinitions.isEmpty()) {
            return false;
        }
        if (this.cndElements.remove(propertyDefinitionBeingRemoved)) {
            this.notifyChangeListeners(PropertyName.PROPERTY_DEFINITIONS, propertyDefinitionBeingRemoved, null);
            if (this.cndElements.isEmpty()) {
                this.cndElements = null;
            }
            return true;
        }
        return false;
    }

    public boolean removeSuperType(String superTypeBeingRemoved) {
        if (this.superTypes.remove(QualifiedName.parse(superTypeBeingRemoved))) {
            this.notifyChangeListeners(PropertyName.SUPERTYPES, superTypeBeingRemoved, null);
            return true;
        }
        return false;
    }

    public void setAbstract(boolean newAbstract) {
        AttributeState.Value newState = newAbstract ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.ABSTRACT, newState);
    }

    @Override
    public boolean setComment(String newComment) {
        boolean changed;
        if (!Utils.isEmpty(newComment)) {
            newComment = newComment.trim();
        }
        String oldValue = this.comment;
        boolean bl = changed = !Utils.equivalent(this.comment, newComment);
        if (changed) {
            this.comment = newComment;
            this.notifyChangeListeners(PropertyName.COMMENT, oldValue, newComment);
        }
        return changed;
    }

    public void setDeclaredSuperTypeNames(String[] newSuperTypes) {
        List oldValue = this.superTypes.getSupportedItems();
        boolean changed = this.superTypes.clear();
        if (!Utils.isEmpty(newSuperTypes)) {
            String[] stringArray = newSuperTypes;
            int n = newSuperTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String superType = stringArray[n2];
                if (this.superTypes.add(QualifiedName.parse(superType))) {
                    changed = true;
                }
                ++n2;
            }
        }
        if (changed) {
            this.notifyChangeListeners(PropertyName.SUPERTYPES, oldValue, this.superTypes.getSupportedItems());
        }
    }

    public void setMixin(boolean newMixin) {
        AttributeState.Value newState = newMixin ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.MIXIN, newState);
    }

    public void setName(String newName) {
        String oldValue = this.name.get();
        if (this.name.set(newName)) {
            this.notifyChangeListeners(PropertyName.NAME, oldValue, newName);
        }
    }

    public void setOrderableChildNodes(boolean newOrderable) {
        AttributeState.Value newState = newOrderable ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.ORDERABLE, newState);
    }

    public void setPrimaryItemName(String newPrimaryItem) {
        String oldName = this.attributes.getPrimaryItem().getPrimaryItem().get();
        if (this.attributes.getPrimaryItem().setPrimaryItem(newPrimaryItem)) {
            this.notifyChangeListeners(PropertyName.PRIMARY_ITEM, oldName, newPrimaryItem);
        }
    }

    public void setQueryable(boolean newQueryable) {
        AttributeState.Value newState = newQueryable ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.QUERYABLE, newState);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        String notation;
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(this.comment)) {
            String commentNotation = "";
            if (CndElement.NotationType.LONG == notationType) {
                commentNotation = String.valueOf(commentNotation) + '\n';
            }
            commentNotation = String.valueOf(commentNotation) + CommentedCndElement.Helper.addCommentCharacters(this.comment);
            builder.append(commentNotation);
        }
        builder.append(NAME_NOTATION_PREFIX).append(this.name.toCndNotation(notationType)).append(NAME_NOTATION_SUFFIX);
        if (CndElement.NotationType.LONG == notationType) {
            builder.append(prefStore.get(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_NAME_END_DELIMITER));
        }
        if (!Utils.isEmpty(notation = this.superTypes.toCndNotation(notationType))) {
            builder.append(notation).append(prefStore.get(JcrPreferenceConstants.CndPreference.SUPER_TYPES_END_DELIMITER));
        }
        if (!Utils.isEmpty(notation = this.attributes.toCndNotation(notationType))) {
            builder.append(notation);
        }
        builder.append(prefStore.get(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_END_DELIMITER));
        List<CndElement> elements = this.getElements();
        if (!Utils.isEmpty(elements)) {
            String elementDelimiter = prefStore.get(JcrPreferenceConstants.CndPreference.ELEMENT_DELIMITER);
            for (CndElement element : elements) {
                builder.append(element.toCndNotation(notationType));
                builder.append(elementDelimiter);
            }
            if (CndElement.NotationType.COMPACT != notationType) {
                builder.append(prefStore.get(JcrPreferenceConstants.CndPreference.ELEMENTS_END_DELIMITER));
            }
        }
        return builder.toString();
    }

    public static enum PropertyName {
        ABSTRACT,
        CHILD_NODES,
        COMMENT,
        MIXIN,
        NAME,
        ORDERABLE,
        PRIMARY_ITEM,
        PROPERTY_DEFINITIONS,
        QUERYABLE,
        SUPERTYPES;


        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + super.toString();
        }
    }
}

