/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class LocalName
implements CndElement,
Comparable<LocalName> {
    private String value;

    public LocalName() {
        this("");
    }

    public LocalName(String initialValue) {
        this.value = initialValue == null ? "" : initialValue;
    }

    @Override
    public int compareTo(LocalName that) {
        if (this.equals(that) || Utils.equals(this.get(), that.get())) {
            return 0;
        }
        if (Utils.isEmpty(this.value)) {
            return -1;
        }
        if (Utils.isEmpty(that.value)) {
            return 1;
        }
        return this.value.compareTo(that.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LocalName that = (LocalName)obj;
        return Utils.equals(this.value, that.value);
    }

    public String get() {
        return this.value;
    }

    public int hashCode() {
        return Utils.hashCode(this.value);
    }

    public boolean set(String newValue) {
        if (!Utils.isEmpty(newValue)) {
            newValue = newValue.trim();
        }
        if (!Utils.equals(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        if (Utils.isEmpty(this.value)) {
            return "";
        }
        String quoteString = JcrPreferenceStore.get().get(JcrPreferenceConstants.CndPreference.QUOTE_CHAR);
        if (Utils.isEmpty(quoteString) && !Utils.isEmpty(this.value) && this.value.contains(" ")) {
            quoteString = "'";
        }
        builder.append(quoteString);
        builder.append(this.value == null ? "" : this.value);
        builder.append(quoteString);
        return builder.toString();
    }

    public String toString() {
        if (Utils.isEmpty(this.value)) {
            return "";
        }
        return this.value;
    }
}

