/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpConstants;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpSaveParticipantConfigurationModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeFormatingTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeStyleTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.UnnecessaryCodeTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.xml.sax.InputSource;

public class CleanUpRefactoringWizard
extends RefactoringWizard {
    private static final String USE_CUSTOM_PROFILE_KEY = "org.eclipse.wst.jsdt.ui.cleanup.use_dialog_profile";
    private static final String CUSTOM_PROFILE_KEY = "org.eclipse.wst.jsdt.ui.cleanup.custom_profile";

    public CleanUpRefactoringWizard(CleanUpRefactoring refactoring, int flags) {
        super((Refactoring)refactoring, flags);
        this.setDefaultPageTitle(MultiFixMessages.CleanUpRefactoringWizard_PageTitle);
        this.setWindowTitle(MultiFixMessages.CleanUpRefactoringWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_CLEAN_UP);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new CleanUpConfigurationPage((CleanUpRefactoring)this.getRefactoring()));
    }

    private static class CleanUpConfigurationPage
    extends UserInputWizardPage
    implements ModifyDialogTabPage.IModificationListener {
        private static final String ENCODING = "UTF-8";
        private final CleanUpRefactoring fCleanUpRefactoring;
        private Map fCustomSettings;
        private SelectionButtonDialogField fUseCustomField;
        private ControlEnableState fEnableState;

        public CleanUpConfigurationPage(CleanUpRefactoring refactoring) {
            super(MultiFixMessages.CleanUpRefactoringWizard_CleanUpConfigurationPage_title);
            this.fCleanUpRefactoring = refactoring;
            IJavaScriptUnit[] cus = this.fCleanUpRefactoring.getCompilationUnits();
            IJavaScriptProject[] projects = this.fCleanUpRefactoring.getProjects();
            if (cus.length == 1) {
                this.setMessage(MultiFixMessages.CleanUpRefactoringWizard_CleaningUp11_Title);
            } else if (projects.length == 1) {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpN1_Title, new Integer(cus.length)));
            } else {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpNN_Title, new Object[]{new Integer(cus.length), new Integer(projects.length)}));
            }
        }

        public void createControl(Composite parent) {
            boolean isCustom = this.getDialogSettings().getBoolean(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY);
            final Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            SelectionButtonDialogField useProfile = new SelectionButtonDialogField(16);
            useProfile.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_configured_radio);
            useProfile.setSelection(!isCustom);
            useProfile.doFillIntoGrid(composite, 2);
            ProjectProfileLableProvider tableLabelProvider = new ProjectProfileLableProvider();
            ProfileTableAdapter listAdapter = new ProfileTableAdapter(tableLabelProvider, this.getShell());
            String[] buttons = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Configure_Button};
            final ListDialogField settingsField = new ListDialogField(listAdapter, buttons, (ILabelProvider)tableLabelProvider);
            String[] headerNames = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Project_TableHeader, MultiFixMessages.CleanUpRefactoringWizard_Profile_TableHeader};
            ColumnLayoutData[] columns = new ColumnLayoutData[]{new ColumnWeightData(1, 100, true), new ColumnWeightData(2, 20, true)};
            settingsField.setTableColumns(new ListDialogField.ColumnsDescription(columns, headerNames, true));
            settingsField.setViewerComparator(new ViewerComparator());
            settingsField.doFillIntoGrid(composite, 3);
            Table table = settingsField.getTableViewer().getTable();
            GridData data = (GridData)settingsField.getListControl(null).getLayoutData();
            data.horizontalIndent = 15;
            data.grabExcessVerticalSpace = false;
            data.heightHint = SWTUtil.getTableHeightHint(table, Math.min(5, this.fCleanUpRefactoring.getProjects().length + 1));
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1;
            data = (GridData)settingsField.getButtonBox(null).getLayoutData();
            data.grabExcessVerticalSpace = false;
            data.verticalAlignment = 1;
            data = (GridData)settingsField.getLabelControl(null).getLayoutData();
            data.exclude = true;
            settingsField.setElements(Arrays.asList(this.fCleanUpRefactoring.getProjects()));
            settingsField.selectFirstElement();
            this.fUseCustomField = new SelectionButtonDialogField(16);
            this.fUseCustomField.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_custom_radio);
            this.fUseCustomField.setSelection(isCustom);
            this.fUseCustomField.doFillIntoGrid(composite, 2);
            String settings = this.getDialogSettings().get(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY);
            if (settings == null) {
                this.fCustomSettings = CleanUpConstants.getEclipseDefaultSettings();
            } else {
                try {
                    this.fCustomSettings = this.decodeSettings(settings);
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                    this.fCustomSettings = CleanUpConstants.getEclipseDefaultSettings();
                }
            }
            final BulletListBlock bulletListBlock = new BulletListBlock();
            Control bulletList = bulletListBlock.createControl(composite);
            GridData layoutData = (GridData)bulletList.getLayoutData();
            layoutData.horizontalIndent = 15;
            layoutData.grabExcessVerticalSpace = true;
            final Button configure = new Button(composite, 0);
            configure.setText(MultiFixMessages.CleanUpRefactoringWizard_ConfigureCustomProfile_button);
            data = new GridData(128, 16384, false, false);
            data.widthHint = SWTUtil.getButtonWidthHint(configure);
            configure.setLayoutData((Object)data);
            this.showCustomSettings(bulletListBlock);
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanUpSaveParticipantConfigurationModifyDialog dialog = new CleanUpSaveParticipantConfigurationModifyDialog(CleanUpConfigurationPage.this.getShell(), CleanUpConfigurationPage.this.fCustomSettings, MultiFixMessages.CleanUpRefactoringWizard_CustomCleanUpsDialog_title){

                        @Override
                        protected CleanUpTabPage[] createTabPages(Map workingValues) {
                            CleanUpTabPage[] result = new CleanUpTabPage[]{new CodeStyleTabPage(this, workingValues, false), new UnnecessaryCodeTabPage(this, workingValues, false), new CodeFormatingTabPage(this, workingValues, false)};
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_code_style_tab, result[0]);
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_unnecessary_code_tab, result[1]);
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_code_organizing_tab, result[2]);
                            return result;
                        }
                    };
                    dialog.open();
                    CleanUpConfigurationPage.this.showCustomSettings(bulletListBlock);
                }
            });
            this.updateEnableState(isCustom, settingsField, configure, bulletListBlock);
            this.fUseCustomField.setDialogFieldListener(new IDialogFieldListener(){

                @Override
                public void dialogFieldChanged(DialogField field) {
                    CleanUpConfigurationPage.this.updateEnableState(CleanUpConfigurationPage.this.fUseCustomField.isSelected(), settingsField, configure, bulletListBlock);
                }
            });
            Link preferencePageLink = new Link(composite, 64);
            preferencePageLink.setText(MultiFixMessages.CleanUpRefactoringWizard_HideWizard_Link);
            preferencePageLink.setFont(parent.getFont());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(300);
            gridData.horizontalSpan = 2;
            preferencePageLink.setLayoutData((Object)gridData);
            preferencePageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.eclipse.wst.jsdt.ui.preferences.CleanUpPreferencePage", null, null).open();
                }
            });
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private void updateEnableState(boolean isCustom, ListDialogField settingsField, Button configureCustom, BulletListBlock bulletListBlock) {
            settingsField.getListControl(null).setEnabled(!isCustom);
            if (isCustom) {
                this.fEnableState = ControlEnableState.disable((Control)settingsField.getButtonBox(null));
            } else if (this.fEnableState != null) {
                this.fEnableState.restore();
                this.fEnableState = null;
            }
            bulletListBlock.setEnabled(isCustom);
            configureCustom.setEnabled(isCustom);
        }

        private void showCustomSettings(BulletListBlock bulletListBlock) {
            StringBuffer buf = new StringBuffer();
            ICleanUp[] cleanUps = CleanUpRefactoring.createCleanUps(this.fCustomSettings);
            int i = 0;
            while (i < cleanUps.length) {
                String[] descriptions = cleanUps[i].getDescriptions();
                if (descriptions != null) {
                    int j = 0;
                    while (j < descriptions.length) {
                        if (buf.length() > 0) {
                            buf.append('\n');
                        }
                        buf.append(descriptions[j]);
                        ++j;
                    }
                }
                ++i;
            }
            bulletListBlock.setText(buf.toString());
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
            this.getDialogSettings().put(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY, this.fUseCustomField.isSelected());
            try {
                this.getDialogSettings().put(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY, this.encodeSettings(this.fCustomSettings));
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
        }

        private void initializeRefactoring() {
            ICleanUp[] cleanups = this.fUseCustomField.isSelected() ? CleanUpRefactoring.createCleanUps(this.fCustomSettings) : CleanUpRefactoring.createCleanUps();
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            refactoring.clearCleanUps();
            int i = 0;
            while (i < cleanups.length) {
                refactoring.addCleanUp(cleanups[i]);
                ++i;
            }
        }

        /*
         * Loose catch block
         */
        public String encodeSettings(Map settings) throws CoreException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
            CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
            ProfileManager.CustomProfile profile = new ProfileManager.CustomProfile("custom", settings, versioner.getCurrentVersion(), versioner.getProfileKind());
            ArrayList<ProfileManager.CustomProfile> profiles = new ArrayList<ProfileManager.CustomProfile>();
            profiles.add(profile);
            ProfileStore.writeProfilesToStream(profiles, stream, ENCODING, versioner);
            String string = stream.toString(ENCODING);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return string;
            {
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string2;
                    try {
                        string2 = stream.toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return string2;
                }
            }
        }

        public Map decodeSettings(String settings) throws CoreException {
            List res;
            ByteArrayInputStream is;
            block11: {
                Map map;
                byte[] bytes;
                try {
                    bytes = settings.getBytes(ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytes = settings.getBytes();
                }
                is = new ByteArrayInputStream(bytes);
                try {
                    res = ProfileStore.readProfilesFromStream(new InputSource(is));
                    if (res != null && res.size() != 0) break block11;
                    map = CleanUpConstants.getEclipseDefaultSettings();
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                return map;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)res.get(0);
            new CleanUpProfileVersioner().update(profile);
            Map map = profile.getSettings();
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            return map;
        }

        @Override
        public void updateStatus(IStatus status) {
        }

        @Override
        public void valuesModified() {
        }

        private static final class ProfileTableAdapter
        implements IListAdapter {
            private final ProjectProfileLableProvider fProvider;
            private final Shell fShell;

            private ProfileTableAdapter(ProjectProfileLableProvider provider, Shell shell) {
                this.fProvider = provider;
                this.fShell = shell;
            }

            @Override
            public void customButtonPressed(ListDialogField field, int index) {
                this.openPropertyDialog(field);
            }

            @Override
            public void doubleClicked(ListDialogField field) {
                this.openPropertyDialog(field);
            }

            private void openPropertyDialog(ListDialogField field) {
                IJavaScriptProject project = (IJavaScriptProject)field.getSelectedElements().get(0);
                PreferencesUtil.createPropertyDialogOn((Shell)this.fShell, (IAdaptable)project, (String)"org.eclipse.wst.jsdt.ui.propertyPages.CleanUpPreferencePage", null, null).open();
                List selectedElements = field.getSelectedElements();
                this.fProvider.reset();
                field.refresh();
                field.selectElements((ISelection)new StructuredSelection(selectedElements));
            }

            @Override
            public void selectionChanged(ListDialogField field) {
                if (field.getSelectedElements().size() != 1) {
                    field.enableButton(0, false);
                } else {
                    field.enableButton(0, true);
                }
            }
        }
    }

    private static class ProjectProfileLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable fProfileIdsTable;

        private ProjectProfileLableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((IJavaScriptProject)element).getProject().getName();
            }
            if (columnIndex == 1) {
                InstanceScope instanceScope;
                IEclipsePreferences instancePreferences;
                if (this.fProfileIdsTable == null) {
                    this.fProfileIdsTable = this.loadProfiles();
                }
                String workbenchProfileId = (instancePreferences = (instanceScope = new InstanceScope()).getNode("org.eclipse.wst.jsdt.ui")).get("cleanup_profile", null) != null ? instancePreferences.get("cleanup_profile", null) : "org.eclipse.wst.jsdt.ui.default.eclipse_clean_up_profile";
                return this.getProjectProfileName((IJavaScriptProject)element, this.fProfileIdsTable, workbenchProfileId);
            }
            return null;
        }

        private Hashtable loadProfiles() {
            List list = CleanUpPreferenceUtil.loadProfiles((IScopeContext)new InstanceScope());
            Hashtable<String, ProfileManager.Profile> profileIdsTable = new Hashtable<String, ProfileManager.Profile>();
            for (ProfileManager.Profile profile : list) {
                profileIdsTable.put(profile.getID(), profile);
            }
            return profileIdsTable;
        }

        private String getProjectProfileName(IJavaScriptProject project, Hashtable profileIdsTable, String workbenchProfileId) {
            ProjectScope projectScope = new ProjectScope(project.getProject());
            IEclipsePreferences node = projectScope.getNode("org.eclipse.wst.jsdt.ui");
            String id = node.get("cleanup_profile", null);
            if (id == null) {
                ProfileManager.Profile profile = (ProfileManager.Profile)profileIdsTable.get(workbenchProfileId);
                if (profile != null) {
                    return profile.getName();
                }
                return MultiFixMessages.CleanUpRefactoringWizard_unknownProfile_Name;
            }
            ProfileManager.Profile profile = (ProfileManager.Profile)profileIdsTable.get(id);
            if (profile != null) {
                return profile.getName();
            }
            return Messages.format(MultiFixMessages.CleanUpRefactoringWizard_UnmanagedProfileWithName_Name, id.substring("_".length()));
        }

        public void reset() {
            this.fProfileIdsTable = null;
        }
    }
}

