/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal.jobs;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.jboss.tools.maven.conversion.ui.internal.jobs.IdentificationJob;

public class IdentifyProjectJob
extends IdentificationJob {
    private IPath projectPath;
    private IMavenProjectFacade facade;

    public IdentifyProjectJob(String name, IPath projectPath) {
        super(name);
        this.projectPath = projectPath;
    }

    @Override
    protected void identifyDependency(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject(this.projectPath);
        if (project != null) {
            this.facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
            if (this.facade != null && this.facade.getMavenProject() != null && this.facade.getMavenProject().getArtifact() != null) {
                Artifact a = this.facade.getMavenProject().getArtifact();
                this.dependency = new Dependency();
                this.dependency.setArtifactId(a.getArtifactId());
                this.dependency.setGroupId(a.getGroupId());
                this.dependency.setVersion(a.getVersion());
                if (a.getArtifactHandler() != null && a.getArtifactHandler().getPackaging() != null) {
                    String type = a.getArtifactHandler().getPackaging();
                    this.dependency.setType(type);
                }
            }
        }
    }

    @Override
    protected void checkResolution(IProgressMonitor monitor) throws CoreException {
        this.resolvable = this.facade != null && this.facade.getMavenProject() != null && this.facade.getMavenProject().getArtifact() != null && this.facade.getProject() != null && this.facade.getProject().isAccessible();
    }

    private IProject getProject(IPath projectPath) {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.lastSegment());
        return p;
    }
}

