/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser;

import java.util.List;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.Tokenizer;
import org.jboss.tools.common.el.internal.core.model.ELArgumentExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELArgumentImpl;
import org.jboss.tools.common.el.internal.core.model.ELComplexExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELComplexInvocationExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELInstanceImpl;
import org.jboss.tools.common.el.internal.core.model.ELInvocationExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELMethodInvocationImpl;
import org.jboss.tools.common.el.internal.core.model.ELModelImpl;
import org.jboss.tools.common.el.internal.core.model.ELMultiExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELOperatorImpl;
import org.jboss.tools.common.el.internal.core.model.ELParametersImpl;
import org.jboss.tools.common.el.internal.core.model.ELPropertyInvocationImpl;
import org.jboss.tools.common.el.internal.core.model.ELValueExpressionImpl;

public class ELParserImpl {
    LexicalToken current;

    public ELModelImpl parse(LexicalToken start) {
        if (this.current != null) {
            throw new RuntimeException("Cannot reuse parser while it is running.");
        }
        try {
            ELModelImpl model = new ELModelImpl();
            model.setFirstToken(start);
            this.current = start;
            while (this.current != null) {
                if (this.current.getType() == 1) {
                    ELInstanceImpl instance = this.readELInstance();
                    if (instance == null) continue;
                    model.addInstance(instance);
                    continue;
                }
                if (!this.hasNextToken() || this.lookUpNextToken(this.current) == null) break;
                this.setNextToken();
            }
            ELModelImpl eLModelImpl = model;
            return eLModelImpl;
        }
        finally {
            this.current = null;
        }
    }

    protected ELInstanceImpl readELInstance() {
        if (this.current == null || this.current.getType() != 1) {
            return null;
        }
        ELInstanceImpl instance = new ELInstanceImpl();
        instance.setFirstToken(this.current);
        ELExpressionImpl expression = null;
        if (this.lookUpNextToken(this.current) != null) {
            this.setNextToken();
            expression = this.readExpression();
        } else {
            this.current = this.current.getNextToken();
        }
        if (expression == null) {
            expression = new ELPropertyInvocationImpl();
            int p = this.current != null ? this.current.getStart() : instance.getEndPosition();
            LexicalToken t = new LexicalToken(p, 0, "", 3);
            expression.setFirstToken(t);
            expression.setLastToken(t);
        }
        if (expression != null) {
            instance.setExpression(expression);
            instance.setLastToken(expression.getLastToken());
        }
        while (true) {
            if (this.current == null) {
                if (instance.getLastToken() == null) {
                    instance.setLastToken(instance.getFirstToken());
                }
                return instance;
            }
            if (this.current.getType() == 1) {
                instance.setLastToken(this.current.getPreviousToken());
                return instance;
            }
            if (this.current.getType() == 2) {
                instance.setLastToken(this.current);
                this.setNextToken();
                return instance;
            }
            if (!this.hasNextToken()) {
                instance.setLastToken(this.current);
                return instance;
            }
            this.setNextToken();
        }
    }

    protected ELExpressionImpl readExpression() {
        if (this.current == null) {
            return null;
        }
        ELExpressionImpl single = this.readSingleExpression();
        if (single == null) {
            return null;
        }
        if (this.current == null || this.current.getType() != 12) {
            return single;
        }
        ELMultiExpressionImpl multi = new ELMultiExpressionImpl();
        multi.setFirstToken(single.getFirstToken());
        multi.addExpression(single);
        while (this.current != null && this.current.getType() == 12 && this.hasNextToken()) {
            ELOperatorImpl operator = new ELOperatorImpl();
            operator.setFirstToken(this.current);
            operator.setLastToken(this.current);
            multi.addOperator(operator);
            multi.setLastToken(operator.getLastToken());
            this.setNextToken();
            single = this.readSingleExpression();
            if (single == null) continue;
            multi.addExpression(single);
            multi.setLastToken(single.getLastToken());
        }
        return multi;
    }

    protected ELExpressionImpl readSingleExpression() {
        if (this.current == null) {
            return null;
        }
        switch (this.current.getType()) {
            case 13: {
                ELComplexExpressionImpl complex = this.readComplexExpression();
                if (this.current != null && this.current.getType() == 4) {
                    return this.readComplexInvocationExpression(complex);
                }
                return complex;
            }
            case 15: {
                return this.readComplexExpression();
            }
            case 5: {
                LexicalToken f = this.lookUpNextToken(this.current);
                if (f != null && f.getType() == 4) {
                    return this.readInvocationExpression();
                }
            }
            case 6: {
                ELValueExpressionImpl expr = new ELValueExpressionImpl();
                expr.setFirstToken(this.current);
                expr.setLastToken(this.current);
                this.setNextToken();
                return expr;
            }
            case 3: {
                LexicalToken t = this.lookUpNextToken(this.current);
                if (t != null && t.getType() == 12 && t.getText().equals(":")) {
                    LexicalToken t1 = this.lookUpNextToken(t);
                    if (t1 == null || t1.getType() == 2 || t1.getType() == 9 || t1.getType() == 11 || t1.getType() == 14 || t1.getType() == 12) {
                        t.setType(4);
                    } else if (t1 != null && t1.getType() == 3) {
                        LexicalToken t2 = this.lookUpNextToken(t1);
                        if (t2 != null && t2.getType() == 7) {
                            t.setType(4);
                        } else {
                            LexicalToken t_ = this.lookUpPrevToken(this.current);
                            if (t_ == null || !"?".equals(t_.getText())) {
                                t.setType(4);
                            }
                        }
                    }
                }
                return this.readInvocationExpression();
            }
        }
        return null;
    }

    protected ELComplexExpressionImpl readComplexExpression() {
        ELComplexExpressionImpl expr = new ELComplexExpressionImpl();
        expr.setFirstToken(this.current);
        if (!this.hasNextToken()) {
            expr.setLastToken(this.current);
            return expr;
        }
        this.setNextToken();
        ELExpressionImpl child = this.readExpression();
        if (child != null) {
            expr.setExpression(child);
            expr.setLastToken(child.getLastToken());
        }
        if (this.current != null && this.current.getType() == 14) {
            expr.setLastToken(this.current);
            this.setNextToken();
        }
        return expr;
    }

    protected ELComplexInvocationExpressionImpl readComplexInvocationExpression(ELComplexExpressionImpl complex) {
        ELInvocationExpressionImpl left = null;
        List<ELInvocationExpression> is = complex.getInvocations();
        if (is != null && !is.isEmpty()) {
            left = (ELInvocationExpressionImpl)is.get(0);
        } else {
            ELPropertyInvocationImpl fake = new ELPropertyInvocationImpl();
            LexicalToken t = new LexicalToken(this.current.getStart(), 0, "", 5);
            fake.setName(t);
            left = fake;
        }
        ELComplexInvocationExpressionImpl result = new ELComplexInvocationExpressionImpl();
        result.setExpression(complex);
        ELInvocationExpressionImpl right = this.readRightExpression(left, true);
        if (right != left) {
            result.setInvocation(right);
        }
        result.setFirstToken(complex.getFirstToken());
        result.setLastToken(right.getLastToken());
        return result;
    }

    protected ELInvocationExpressionImpl readInvocationExpression() {
        if (this.current == null || this.current.getType() != 3 && this.current.getType() != 5) {
            return null;
        }
        ELPropertyInvocationImpl name = new ELPropertyInvocationImpl();
        name.setName(this.current);
        ELInvocationExpressionImpl result = name;
        this.setNextToken();
        if (this.current != null) {
            switch (this.current.getType()) {
                case 7: {
                    ELParametersImpl params = this.readParameters();
                    ELMethodInvocationImpl method = new ELMethodInvocationImpl();
                    method.setName(name.getName());
                    method.setParameters(params);
                    result = method;
                }
                case 10: {
                    while (this.current != null && this.current.getType() == 10) {
                        ELArgumentImpl arg = this.readArgument();
                        ELArgumentExpressionImpl call = new ELArgumentExpressionImpl();
                        call.setArgument(arg);
                        call.setLeft(result);
                        result = call;
                    }
                    break;
                }
            }
        }
        return this.readRightExpression(result, false);
    }

    ELInvocationExpressionImpl readRightExpression(ELInvocationExpressionImpl result, boolean isLeftFake) {
        if (this.current != null && this.current.getType() == 4) {
            LexicalToken dot = this.current;
            this.setNextToken();
            ELInvocationExpressionImpl right = this.readInvocationExpression();
            if (right != null) {
                ELInvocationExpressionImpl r = right;
                while (r.getLeft() != null) {
                    r = r.getLeft();
                }
                if (r instanceof ELPropertyInvocationImpl) {
                    ((ELPropertyInvocationImpl)r).setSeparator(dot);
                }
                r.setLeft(result);
                r.setLeftIsFake(isLeftFake);
                result = right;
            } else {
                ELPropertyInvocationImpl incompleteProperty = new ELPropertyInvocationImpl();
                incompleteProperty.setSeparator(dot);
                incompleteProperty.setLastToken(dot);
                LexicalToken n = dot.getNextToken();
                if (n != null && n.getType() == 0) {
                    incompleteProperty.setLastToken(n);
                }
                incompleteProperty.setLeft(result);
                incompleteProperty.setLeftIsFake(isLeftFake);
                result = incompleteProperty;
            }
        }
        return result;
    }

    protected ELParametersImpl readParameters() {
        ELParametersImpl parameters = new ELParametersImpl();
        parameters.setFirstToken(this.current);
        if (!this.hasNextToken()) {
            parameters.setLastToken(this.current);
            return parameters;
        }
        this.setNextToken();
        ELExpressionImpl expression = this.readExpression();
        if (expression != null) {
            parameters.addParameter(expression);
            parameters.setLastToken(expression.getLastToken());
        }
        while (this.current != null && this.current.getType() == 8) {
            if (!this.hasNextToken()) {
                parameters.setLastToken(this.current);
                return parameters;
            }
            this.setNextToken();
            expression = this.readExpression();
            if (expression == null) continue;
            parameters.addParameter(expression);
            parameters.setLastToken(expression.getLastToken());
        }
        if (this.current != null && this.current.getType() == 9) {
            parameters.setLastToken(this.current);
            this.setNextToken();
        }
        return parameters;
    }

    protected ELArgumentImpl readArgument() {
        ELArgumentImpl arg = new ELArgumentImpl();
        arg.setFirstToken(this.current);
        arg.setLastToken(this.current);
        if (!this.hasNextToken()) {
            this.setNextToken();
            return arg;
        }
        this.setNextToken();
        ELExpressionImpl expr = this.readExpression();
        if (expr != null) {
            arg.setArgument(expr);
            arg.setLastToken(expr.getLastToken());
        }
        if (this.current != null && this.current.getType() == 11) {
            arg.setLastToken(this.current);
            this.setNextToken();
        }
        return arg;
    }

    private boolean hasNextToken() {
        return this.lookUpNextToken(this.current) != null;
    }

    private LexicalToken lookUpNextToken(LexicalToken token) {
        LexicalToken c = token;
        while (c != null && (c == token || c.getType() == 0 || c.getType() == Tokenizer.LITERAL)) {
            c = c.getNextToken();
        }
        return c;
    }

    private LexicalToken lookUpPrevToken(LexicalToken token) {
        LexicalToken c = token;
        while (c != null && (c == token || c.getType() == 0 || c.getType() == Tokenizer.LITERAL)) {
            c = c.getPreviousToken();
        }
        return c;
    }

    private void setNextToken() {
        this.current = this.lookUpNextToken(this.current);
    }
}

