/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.util.BeanUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class TypeInfoCollector {
    IType fType;
    MemberInfo fMember;
    TypeInfo fTypeInfo;
    boolean fIncludeStaticMethods;
    List<MethodInfo> fMethods;
    List<FieldInfo> fFields;
    private static Caches caches = new Caches();
    public static final MemberPresentationComparator MEMBER_PRESENTATION_COMPARATOR = new MemberPresentationComparator();

    public TypeInfoCollector(MemberInfo member, boolean varIsUsed, boolean includeStaticMethods) {
        this.fMember = member;
        this.fType = member.getMemberType();
        this.fIncludeStaticMethods = includeStaticMethods;
        this.collectInfo(varIsUsed);
    }

    public IType getType() {
        return this.fType;
    }

    public void collectInfo() {
        this.collectInfo(false);
    }

    public void collectInfo(boolean var) {
        if (this.fMethods == null) {
            this.fMethods = new ArrayList<MethodInfo>();
        } else {
            this.fMethods.clear();
        }
        if (this.fFields == null) {
            this.fFields = new ArrayList<FieldInfo>();
        } else {
            this.fFields.clear();
        }
        if (this.fType == null) {
            return;
        }
        try {
            IType binType = this.fType;
            MemberInfo originalParent = this.fMember;
            this.fTypeInfo = this.fMember instanceof TypeInfo ? (TypeInfo)this.fMember : new TypeInfo(binType, this.fMember, this.fMember.isDataModel());
            TypeInfo parent = this.fTypeInfo;
            this.initSuperTypes(binType, var, parent, originalParent, new TreeSet<String>());
            if (this.isDataModelObject(this.fType)) {
                this.addInfoForDataModelObject();
            }
            if (this.fMember.isDataModel) {
                this.addInfoForDataModelVariable();
            }
        }
        catch (JavaModelException e) {
            ELCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void initSuperTypes(IType binType, boolean var, TypeInfo parent, MemberInfo originalParent, Collection<String> allTypes) throws JavaModelException {
        IType superBinType;
        String[] superinterfaceNames;
        IMethod[] binMethods = binType.getMethods();
        int i = 0;
        while (binMethods != null && i < binMethods.length) {
            if (!binMethods[i].isConstructor()) {
                MethodInfo info = new MethodInfo(binMethods[i], this.fTypeInfo, parent, false);
                if (info.getType().isArray() && var) {
                    info.setDataModel(true);
                }
                this.fMethods.add(info);
            }
            ++i;
        }
        String[] stringArray = superinterfaceNames = binType.getSuperInterfaceNames();
        int n = superinterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superinterface = stringArray[n2];
            String fullSuperInterfaceName = EclipseJavaUtil.resolveType((IType)binType, (String)superinterface);
            if (fullSuperInterfaceName != null) {
                if (fullSuperInterfaceName.equals(binType.getFullyQualifiedName())) break;
                IType superBinType2 = binType.getJavaProject().findType(fullSuperInterfaceName);
                if (superBinType2 != null && !allTypes.contains(superBinType2.getFullyQualifiedName())) {
                    this.initType(superBinType2, var, parent, originalParent, allTypes);
                }
            }
            ++n2;
        }
        if ((superBinType = TypeInfoCollector.getSuperclass(binType)) != null && !allTypes.contains(superBinType.getFullyQualifiedName())) {
            this.initType(superBinType, var, parent, originalParent, allTypes);
        }
    }

    private void initType(IType binType, boolean var, TypeInfo parent, MemberInfo originalParent, Collection<String> allTypes) throws JavaModelException {
        TypeInfo superType = new TypeInfo(binType, originalParent, parent.isDataModel());
        parent.setSuperType(superType);
        allTypes.add(binType.getFullyQualifiedName());
        this.initSuperTypes(binType, var, superType, originalParent, allTypes);
    }

    boolean isDataModelObject(IType type) throws JavaModelException {
        return TypeInfoCollector.isInstanceofType(type, "javax.faces.model.DataModel");
    }

    public static boolean isResourceBundle(IType type) {
        try {
            return TypeInfoCollector.isInstanceofType(type, "java.util.ResourceBundle");
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean isNotParameterizedCollection(MemberInfo mbr) {
        block4: {
            try {
                if (mbr.getType().getParameters() == null || mbr.getType().getParameters().length <= 0) break block4;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        IType type = mbr.getMemberType();
        if (type != null) {
            return TypeInfoCollector.isInstanceofType(type, "java.util.Map") || TypeInfoCollector.isInstanceofType(type, "java.lang.Iterable");
        }
        return false;
    }

    public static SuperTypeInfo getSuperTypes(IType type) throws JavaModelException {
        SuperTypeInfo ts;
        if (type == null) {
            return null;
        }
        ProjectCache cache = caches.get((IJavaElement)type);
        SuperTypeInfo superTypeInfo = ts = cache != null ? cache.superTypesCache.get(type) : null;
        if (ts == null) {
            ts = new SuperTypeInfo(type);
        }
        return ts;
    }

    public static boolean isInstanceofType(IType type, String qualifiedTypeName) throws JavaModelException {
        if (qualifiedTypeName == null || type == null) {
            return false;
        }
        boolean isInstanceofType = qualifiedTypeName.equals(type.getFullyQualifiedName());
        if (!isInstanceofType) {
            SuperTypeInfo ts = TypeInfoCollector.getSuperTypes(type);
            return ts != null && ts.getNames().contains(qualifiedTypeName);
        }
        return true;
    }

    void addInfoForDataModelVariable() {
        this.fMethods.add(new MethodInfo(this.fType, this.fType.getFullyQualifiedName(), "getRowCount", 1, new String[0], new String[0], "int", this.fTypeInfo, this.fTypeInfo, false));
    }

    void addInfoForDataModelObject() {
        this.fMethods.add(new MethodInfo(this.fType, this.fType.getFullyQualifiedName(), "size", 1, new String[0], new String[0], "int", this.fTypeInfo, this.fTypeInfo, false));
        this.fMethods.add(new MethodInfo(this.fType, this.fType.getFullyQualifiedName(), "isEmpty", 1, new String[0], new String[0], "boolean", this.fTypeInfo, this.fTypeInfo, false));
    }

    public static IType getSuperclass(IType type) throws JavaModelException {
        String fullySuperclassName;
        String superclassName = type.getSuperclassName();
        if (superclassName != null && (fullySuperclassName = EclipseJavaUtil.resolveType((IType)type, (String)superclassName)) != null && !fullySuperclassName.equals("java.lang.Object")) {
            if (fullySuperclassName.equals(type.getFullyQualifiedName())) {
                return null;
            }
            IType superType = type.getJavaProject().findType(fullySuperclassName);
            return superType;
        }
        return null;
    }

    public MethodInfo[] findMethodInfos(IMethod iMethod) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (MethodInfo info : this.fMethods) {
            if (!info.getName().equals(iMethod.getElementName())) continue;
            methods.add(info);
        }
        if (methods.isEmpty()) {
            return new MethodInfo[0];
        }
        EclipseJavaUtil.getMemberTypeAsString((IMethod)iMethod);
        if (methods.size() == 1) {
            return methods.toArray(new MethodInfo[0]);
        }
        ArrayList<MethodInfo> filteredMethods = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (method.getNumberOfParameters() != iMethod.getNumberOfParameters()) continue;
            filteredMethods.add(method);
        }
        if (filteredMethods.isEmpty()) {
            return new MethodInfo[0];
        }
        if (filteredMethods.size() == 1) {
            return filteredMethods.toArray(new MethodInfo[0]);
        }
        methods = filteredMethods;
        filteredMethods = new ArrayList();
        for (MethodInfo method : methods) {
            String[] methodParameterTypes = TypeInfoCollector.resolveSignatures(iMethod.getDeclaringType(), iMethod.getParameterTypes());
            String[] parameterTypes = method.getParameterTypeQualifiedNames();
            boolean equal = true;
            int i = 0;
            while (equal && parameterTypes != null && i < parameterTypes.length) {
                if (!parameterTypes[i].equals(methodParameterTypes[i]) && parameterTypes[i].indexOf(46) != -1 && methodParameterTypes[i].indexOf(46) == -1) {
                    equal = false;
                }
                ++i;
            }
            if (!equal) continue;
            filteredMethods.add(method);
        }
        return filteredMethods.toArray(new MethodInfo[0]);
    }

    public List<MemberInfo> getMethods() {
        ArrayList<MemberInfo> methods = new ArrayList<MemberInfo>();
        for (MethodInfo info : this.fMethods) {
            try {
                if ((info.getSourceType() == null || !info.getSourceType().isInterface()) && !info.isPublic() || info.isConstructor() || !this.fIncludeStaticMethods && info.isStatic() || info.isJavaLangObject()) continue;
                methods.add(info);
            }
            catch (JavaModelException e) {
                ELCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return methods;
    }

    public Set<String> getMethodPresentationStrings(boolean isValidating) {
        Set<MemberPresentation> set = this.getMethodPresentations(isValidating);
        HashSet<String> result = new HashSet<String>();
        for (MemberPresentation presentation : set) {
            result.add(presentation.getPresentation());
        }
        return result;
    }

    public Set<MemberPresentation> getMethodPresentations(boolean isValidating) {
        TreeSet<MemberPresentation> methods = new TreeSet<MemberPresentation>(MEMBER_PRESENTATION_COMPARATOR);
        List<MemberInfo> mthds = this.getMethods();
        for (MemberInfo info : mthds) {
            boolean enabledNonParenthesesView;
            boolean disabledGettersAndSettersView;
            if (!(info instanceof MethodInfo)) continue;
            MethodInfo method = (MethodInfo)info;
            StringBuffer name = new StringBuffer(method.getName());
            StringBuffer displayName = new StringBuffer(method.getName());
            boolean bl = disabledGettersAndSettersView = !ELCorePlugin.getDefault().getPreferenceStore().getBoolean("showGettersAndSetters") && (method.isGetter() || method.isSetter());
            if (!isValidating && disabledGettersAndSettersView) continue;
            boolean bl2 = enabledNonParenthesesView = !ELCorePlugin.getDefault().getPreferenceStore().getBoolean("showMethodsWithParenthesesOnly");
            if (isValidating || enabledNonParenthesesView) {
                methods.add(new MemberPresentation(name.toString(), displayName.toString(), method));
            }
            name.append('(');
            displayName.append('(');
            String[] mParams = method.getParameterNames();
            String[] mTypes = method.getParameterTypeNames();
            int j = 0;
            while (mParams != null && j < mParams.length) {
                String typeName;
                String string = typeName = mTypes[j] == null ? "" : mTypes[j];
                if (typeName.indexOf(46) != -1) {
                    typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                }
                if (j > 0) {
                    displayName.append(", ");
                }
                displayName.append(typeName).append(' ').append(mParams[j]);
                ++j;
            }
            name.append(')');
            displayName.append(')');
            methods.add(new MemberPresentation(name.toString(), displayName.toString(), method));
        }
        return methods;
    }

    public List<MemberInfo> getProperties() {
        ArrayList<MemberInfo> properties = new ArrayList<MemberInfo>();
        for (MethodInfo info : this.fMethods) {
            try {
                if ((info.getSourceType() == null || !info.getSourceType().isInterface()) && !info.isPublic() || info.isConstructor() || info.isStatic() || info.isJavaLangObject() || !info.isGetter() && !info.isSetter()) continue;
                properties.add(info);
            }
            catch (JavaModelException e) {
                ELCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return properties;
    }

    public Set<MemberPresentation> getPropertyPresentations(boolean isValidating) {
        return this.getPropertyPresentations(null, isValidating);
    }

    public Set<String> getPropertyPresentationStrings(boolean isValidating) {
        return this.getPropertyPresentationStrings(null, isValidating);
    }

    public Set<String> getPropertyPresentationStrings(Map<String, MethodInfo> unpairedGettersOrSetters, boolean isValidating) {
        Set<MemberPresentation> set = this.getPropertyPresentations(unpairedGettersOrSetters, isValidating);
        HashSet<String> result = new HashSet<String>();
        for (MemberPresentation presentation : set) {
            result.add(presentation.getPresentation());
        }
        return result;
    }

    public Set<MemberPresentation> getPropertyPresentations(Map<String, MethodInfo> unpairedGettersOrSetters, boolean isValidating) {
        TreeSet<MemberPresentation> properties = new TreeSet<MemberPresentation>(MEMBER_PRESENTATION_COMPARATOR);
        HashMap<String, MemberPresentation> presentations = new HashMap<String, MemberPresentation>();
        List<MemberInfo> props = this.getProperties();
        HashMap<String, MethodInfo> getters = new HashMap<String, MethodInfo>();
        HashMap<String, MethodInfo> setters = new HashMap<String, MethodInfo>();
        for (MemberInfo info : props) {
            if (info instanceof MethodInfo) {
                String propertyName;
                MethodInfo m = (MethodInfo)info;
                if (!m.isGetter() && !m.isSetter() || (propertyName = BeanUtil.getPropertyName((String)m.getName())) == null) continue;
                MemberPresentation pr = new MemberPresentation(propertyName, propertyName, m);
                if (!properties.contains(pr)) {
                    properties.add(pr);
                    presentations.put(pr.getPresentation(), pr);
                } else {
                    MemberPresentation existingPresentation = (MemberPresentation)presentations.get(pr.getPresentation());
                    existingPresentation.addMember(m);
                }
                pr.setProperty(true);
                if (unpairedGettersOrSetters == null) continue;
                MethodInfo previousGetter = (MethodInfo)getters.get(propertyName);
                MethodInfo previousSetter = (MethodInfo)setters.get(propertyName);
                if (previousGetter != null && m.isSetter() || previousSetter != null && m.isGetter()) {
                    unpairedGettersOrSetters.remove(propertyName);
                    continue;
                }
                if (m.isSetter()) {
                    setters.put(propertyName, m);
                    unpairedGettersOrSetters.put(propertyName, m);
                    continue;
                }
                if (!m.isGetter()) continue;
                getters.put(propertyName, m);
                unpairedGettersOrSetters.put(propertyName, m);
                continue;
            }
            MemberPresentation pr = new MemberPresentation(info.getName(), info.getName(), info);
            properties.add(pr);
            presentations.put(pr.getPresentation(), pr);
        }
        return properties;
    }

    public static void cleanCache() {
        caches = new Caches();
    }

    public static MemberInfo createMemberInfo(IMember member, boolean dataModel) {
        MemberInfo result;
        ProjectCache pcache = caches.get((IJavaElement)member);
        Map<IMember, MemberInfo> cache = null;
        if (pcache != null) {
            cache = dataModel ? pcache.memberInfoCacheTrue : pcache.memberInfoCacheFalse;
        }
        MemberInfo memberInfo = result = cache == null ? null : cache.get(member);
        if (result != null) {
            return result;
        }
        try {
            if (member instanceof IType) {
                result = new TypeInfo((IType)member, null, dataModel);
            } else if (member instanceof IField) {
                IField field = (IField)member;
                TypeInfo declaringType = new TypeInfo(field.getDeclaringType(), null, dataModel);
                result = new FieldInfo(field, declaringType, declaringType, dataModel);
            } else if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                TypeInfo declaringType = new TypeInfo(method.getDeclaringType(), null, dataModel);
                result = new MethodInfo(method, declaringType, declaringType, dataModel);
            }
        }
        catch (JavaModelException e) {
            ELCorePlugin.getPluginLog().logError((Throwable)e);
        }
        if (result != null && cache != null) {
            cache.put(member, result);
        }
        return result;
    }

    public static MemberInfo createMemberInfo(IMember member) {
        return TypeInfoCollector.createMemberInfo(member, false);
    }

    static String[] resolveSignatures(IType type, String[] signatures) {
        if (signatures == null || signatures.length == 0) {
            return new String[0];
        }
        String[] resolvedSignatures = new String[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            resolvedSignatures[i] = EclipseJavaUtil.resolveTypeAsString((IType)type, (String)signatures[i]);
            ++i;
        }
        return resolvedSignatures;
    }

    static String[] convertToStringArray(char[][] names) {
        if (names == null || names.length == 0) {
            return new String[0];
        }
        String[] sNames = new String[names.length];
        int i = 0;
        while (i < sNames.length) {
            sNames[i] = String.valueOf(names[i]);
            ++i;
        }
        return sNames;
    }

    static String[] getTypeErasureFromSignatureArray(String[] signatures) {
        if (signatures == null || signatures.length == 0) {
            return new String[0];
        }
        String[] result = new String[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            result[i] = Signature.getTypeErasure((String)signatures[i]);
            ++i;
        }
        return result;
    }

    static String getParameterNameFromType(String typeSignatures) {
        if (typeSignatures == null) {
            return null;
        }
        return Signature.getTypeVariable((String)typeSignatures);
    }

    public static class ArtificialTypeInfo
    extends TypeInfo {
        private IType fType;
        private IMethod fMethod;
        private String fMethodName;

        public ArtificialTypeInfo(IType type, IMethod method, String methodName) throws JavaModelException {
            super(type, null, false);
            this.fType = type;
            this.fMethod = method;
            this.fMethodName = methodName;
        }

        @Override
        public IJavaElement getJavaElement() {
            return this.fType;
        }

        @Override
        public TypeInfoCollector getTypeCollector(boolean varIsUsed, boolean includeStaticMethods) {
            return new TypeInfoCollector(this, varIsUsed, true){

                @Override
                public List<MemberInfo> getMethods() {
                    ArrayList<MemberInfo> methods = new ArrayList<MemberInfo>();
                    methods.addAll(this.fMethods);
                    return methods;
                }

                @Override
                public List<MemberInfo> getProperties() {
                    return new ArrayList<MemberInfo>();
                }

                @Override
                public void collectInfo(boolean var) {
                    if (this.fMethods == null) {
                        this.fMethods = new ArrayList();
                    } else {
                        this.fMethods.clear();
                    }
                    if (this.fFields == null) {
                        this.fFields = new ArrayList();
                    } else {
                        this.fFields.clear();
                    }
                    if (this.fType == null) {
                        return;
                    }
                    try {
                        IType binType = this.fType;
                        this.fTypeInfo = this.fMember instanceof TypeInfo ? (TypeInfo)this.fMember : new TypeInfo(binType, this.fMember, this.fMember.isDataModel());
                        TypeInfo parent = this.fTypeInfo;
                        MethodInfo info = new MethodInfo(ArtificialTypeInfo.this.fMethod, ArtificialTypeInfo.this.fMethodName, this.fTypeInfo, parent, false);
                        this.fMethods.add(info);
                    }
                    catch (JavaModelException e) {
                        ELCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            };
        }
    }

    private static class Caches {
        ProjectCache common = new ProjectCache();

        private Caches() {
        }

        public boolean contains(IProject p) {
            return true;
        }

        public void clean(IProject p) {
            this.common = new ProjectCache();
        }

        public ProjectCache get(IProject p) {
            if (p == null || !p.isAccessible()) {
                return null;
            }
            return this.common;
        }

        public ProjectCache get(IJavaElement element) {
            if (element == null) {
                return null;
            }
            IJavaProject jp = element.getJavaProject();
            IProject p = jp == null ? null : jp.getProject();
            return this.get(p);
        }
    }

    public static class FieldInfo
    extends TypeMemberInfo {
        private IJavaElement fJavaElement;

        public FieldInfo(IField field, TypeInfo parentMember, TypeInfo declaratedType, boolean dataModel) throws JavaModelException {
            super(field.getDeclaringType(), field.getDeclaringType() == null ? null : field.getDeclaringType().getFullyQualifiedName(), field.getElementName(), field.getFlags(), parentMember, declaratedType, dataModel, new Type(field.getTypeSignature(), field.getDeclaringType()));
            this.fJavaElement = field;
            this.setParametersNamesOfDeclaringType(TypeInfoCollector.getTypeErasureFromSignatureArray(field.getDeclaringType().getTypeParameterSignatures()));
        }

        @Override
        public IJavaElement getJavaElement() {
            if (this.fJavaElement == null) {
                block4: {
                    if (this.getDeclaringTypeQualifiedName() != null) break block4;
                    return null;
                }
                try {
                    IType declType = this.getSourceType().getJavaProject().findType(this.getDeclaringTypeQualifiedName());
                    this.fJavaElement = declType == null ? null : declType.getField(this.getName());
                }
                catch (JavaModelException e) {
                    ELCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            return this.fJavaElement;
        }
    }

    public static abstract class MemberInfo {
        private String fDeclaringTypeQualifiedName;
        private String fName;
        private int fModifiers;
        private IType fSourceType;
        private MemberInfo fParentMember;
        private IType fMemberType;
        private boolean isDataModel;
        private Type fType;

        protected MemberInfo(IType sourceType, String declaringTypeQualifiedName, String name, int modifiers, MemberInfo parentMember, boolean dataModel, Type type) {
            this.setSourceType(sourceType);
            this.setDeclaringTypeQualifiedName(declaringTypeQualifiedName);
            this.setName(name);
            this.setModifiers(modifiers);
            this.setParentMember(parentMember);
            this.setDataModel(dataModel);
            this.setType(type);
        }

        abstract void initializeParameters();

        protected void setType(Type type) {
            this.fType = type;
        }

        public Type getType() {
            return this.fType;
        }

        public String getMemberTypeName() {
            return this.fType.getName();
        }

        public void setSourceType(IType sourceType) {
            this.fSourceType = sourceType;
        }

        public IType getSourceType() {
            return this.fSourceType;
        }

        protected void setName(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        protected void setDeclaringTypeQualifiedName(String declaringTypeQualifiedName) {
            this.fDeclaringTypeQualifiedName = declaringTypeQualifiedName;
        }

        public String getDeclaringTypeQualifiedName() {
            return this.fDeclaringTypeQualifiedName;
        }

        protected void setModifiers(int modifiers) {
            this.fModifiers = modifiers;
        }

        public int getModifiers() {
            return this.fModifiers;
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.fModifiers);
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.fModifiers);
        }

        public boolean isJavaLangObject() {
            return "java.lang.Object".equals(this.getDeclaringTypeQualifiedName());
        }

        public MemberInfo getParentMember() {
            return this.fParentMember;
        }

        protected void setParentMember(MemberInfo parentMember) {
            this.fParentMember = parentMember;
        }

        public IType getMemberType() {
            if (this.fMemberType == null) {
                this.initializeParameters();
                try {
                    if (this.isDataModel() && this.getType().isArray()) {
                        this.fMemberType = this.getType().getSource().getJavaProject().findType(this.getType().getQualifiedTypeNameOfArrayElement());
                    } else if (this.getType().getQualifiedName() != null) {
                        this.fMemberType = this.getType().getSource().getJavaProject().findType(this.getType().getQualifiedName());
                    }
                }
                catch (JavaModelException e) {
                    ELCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            return this.fMemberType;
        }

        public boolean isDataModel() {
            return this.isDataModel;
        }

        public void setDataModel(boolean isDataModel) {
            this.isDataModel = isDataModel;
        }

        public TypeInfoCollector getTypeCollector(boolean varIsUsed, boolean includeStaticMethods) {
            return new TypeInfoCollector(this, varIsUsed, includeStaticMethods);
        }

        public abstract IJavaElement getJavaElement();
    }

    public static class MemberPresentation {
        private boolean property;
        private String presentation;
        private String displayName;
        private MemberInfo member;
        private Set<MemberInfo> allMembers = new HashSet<MemberInfo>();

        public MemberPresentation(String presentation, String displayName, MemberInfo member) {
            this.presentation = presentation;
            this.displayName = displayName;
            this.member = member;
            this.addMember(member);
        }

        public String getPresentation() {
            return this.presentation;
        }

        public String getPresentationDisplayName() {
            return this.displayName;
        }

        public MemberInfo getMember() {
            return this.member;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberPresentation) {
                return this.presentation.equals(((MemberPresentation)obj).getPresentation());
            }
            return false;
        }

        public int hashCode() {
            return this.presentation.hashCode();
        }

        public String toString() {
            return this.presentation;
        }

        public void addMember(MemberInfo pair) {
            this.allMembers.add(pair);
        }

        public Set<MemberInfo> getAllMembers() {
            return this.allMembers;
        }

        public boolean isProperty() {
            return this.property;
        }

        public void setProperty(boolean property) {
            this.property = property;
        }
    }

    private static class MemberPresentationComparator
    implements Comparator<MemberPresentation> {
        private MemberPresentationComparator() {
        }

        @Override
        public int compare(MemberPresentation m1, MemberPresentation m2) {
            return m1.getPresentation().compareTo(m2.getPresentation());
        }
    }

    public static class MethodInfo
    extends TypeMemberInfo {
        private String[] fParameterTypeNames;
        private String[] fParameterTypeQualifiedNames;
        private String[] fParameterNames;
        private IMethod fJavaElement;

        public MethodInfo(IType sourceType, String declaringTypeQualifiedName, String name, int modifiers, String[] parameterTypeQualifiedNames, String[] parameterNames, String returnTypeQualifiedName, TypeInfo parentMember, TypeInfo declaratedType, boolean dataModel) {
            super(sourceType, declaringTypeQualifiedName, name, modifiers, parentMember, declaratedType, dataModel, Type.valueOf(name));
            this.setParameterTypeNames(parameterTypeQualifiedNames);
            this.setParameterNames(parameterNames);
        }

        public MethodInfo(IMethod method, String name, TypeInfo parentMember, TypeInfo declaratedType, boolean dataModel) throws JavaModelException {
            super(method.getDeclaringType(), method.getDeclaringType() == null ? null : method.getDeclaringType().getFullyQualifiedName(), name, method.getFlags(), parentMember, declaratedType, dataModel, new Type(method.getReturnType(), method.getDeclaringType()));
            this.fJavaElement = method;
            this.setParameterNames(method.getParameterNames());
            this.setParameterTypeNames(TypeInfoCollector.resolveSignatures(method.getDeclaringType(), method.getParameterTypes()));
            this.setParametersNamesOfDeclaringType(TypeInfoCollector.getTypeErasureFromSignatureArray(method.getDeclaringType().getTypeParameterSignatures()));
        }

        public MethodInfo(IMethod method, TypeInfo parentMember, TypeInfo declaratedType, boolean dataModel) throws JavaModelException {
            super(method.getDeclaringType(), method.getDeclaringType() == null ? null : method.getDeclaringType().getFullyQualifiedName(), method.getElementName(), method.getFlags(), parentMember, declaratedType, dataModel, new Type(method.getReturnType(), method.getDeclaringType()));
            this.fJavaElement = method;
            this.setParameterNames(method.getParameterNames());
            this.setParameterTypeNames(TypeInfoCollector.resolveSignatures(method.getDeclaringType(), method.getParameterTypes()));
            this.setParametersNamesOfDeclaringType(TypeInfoCollector.getTypeErasureFromSignatureArray(method.getDeclaringType().getTypeParameterSignatures()));
        }

        protected void setParameterTypeNames(String[] parameterTypeNames) {
            this.fParameterTypeNames = parameterTypeNames == null ? new String[]{} : parameterTypeNames;
        }

        public String[] getParameterTypeQualifiedNames() {
            if (this.fParameterTypeQualifiedNames == null) {
                this.fParameterTypeQualifiedNames = new String[this.fParameterTypeNames.length];
                int i = 0;
                while (i < this.fParameterTypeQualifiedNames.length) {
                    this.fParameterTypeQualifiedNames[i] = EclipseJavaUtil.resolveType((IType)this.getSourceType(), (String)this.fParameterTypeNames[i]);
                    ++i;
                }
            }
            return this.fParameterTypeQualifiedNames;
        }

        public String[] getParameterTypeNames() {
            return this.fParameterTypeNames;
        }

        protected void setParameterNames(String[] parameterNames) {
            this.fParameterNames = parameterNames == null ? new String[]{} : parameterNames;
        }

        public String[] getParameterNames() {
            return this.fParameterNames;
        }

        public int getNumberOfParameters() {
            return this.getParameterNames() == null ? 0 : this.getParameterNames().length;
        }

        public IType getReturnType() {
            return this.getMemberType();
        }

        public boolean isConstructor() {
            return this.getDeclaringTypeQualifiedName() != null && this.getDeclaringTypeQualifiedName().equals(this.getName());
        }

        public boolean isGetter() {
            return this.getType() != null && BeanUtil.isGetter((String)this.getName(), (int)this.getNumberOfParameters()) && BeanUtil.checkPropertyReturnType((String)this.getType().getName(), (String)this.getName());
        }

        public boolean isSetter() {
            return BeanUtil.isSetter((String)this.getName(), (int)this.getNumberOfParameters());
        }

        public List<String> getAsPresentedStrings() {
            ArrayList<String> list = new ArrayList<String>(2);
            StringBuffer name = new StringBuffer(this.getName());
            list.add(name.toString());
            name.append('(');
            String[] mParams = this.getParameterNames();
            int j = 0;
            while (mParams != null && j < mParams.length) {
                if (j > 0) {
                    name.append(", ");
                }
                name.append(mParams[j]);
                ++j;
            }
            name.append(')');
            list.add(name.toString());
            return list;
        }

        @Override
        public String getMemberTypeName() {
            if (this.isSetter()) {
                return this.getParameterTypeNames()[0];
            }
            return super.getMemberTypeName();
        }

        @Override
        public IJavaElement getJavaElement() {
            if (this.fJavaElement == null) {
                IType declType;
                block16: {
                    declType = this.getSourceType().getJavaProject().findType(this.getDeclaringTypeQualifiedName());
                    if (declType != null) break block16;
                    return null;
                }
                try {
                    IMethod[] allMethods = declType.getMethods();
                    ArrayList<IMethod> methods = new ArrayList<IMethod>();
                    int i = 0;
                    while (allMethods != null && i < allMethods.length) {
                        if (allMethods[i].getElementName().equals(this.getName())) {
                            methods.add(allMethods[i]);
                        }
                        ++i;
                    }
                    if (!methods.isEmpty()) {
                        if (methods.size() == 1) {
                            this.fJavaElement = (IMethod)methods.get(0);
                        } else {
                            ArrayList<IMethod> filteredMethods = new ArrayList<IMethod>();
                            for (IMethod method : methods) {
                                if (method.getNumberOfParameters() != this.getNumberOfParameters()) continue;
                                filteredMethods.add(method);
                            }
                            if (!filteredMethods.isEmpty()) {
                                if (filteredMethods.size() == 1) {
                                    this.fJavaElement = (IMethod)filteredMethods.get(0);
                                } else {
                                    methods = filteredMethods;
                                    for (IMethod method : methods) {
                                        String[] methodParameterTypes = TypeInfoCollector.resolveSignatures(method.getDeclaringType(), method.getParameterTypes());
                                        String[] parameterTypes = this.getParameterTypeQualifiedNames();
                                        boolean equal = true;
                                        int i2 = 0;
                                        while (parameterTypes != null && i2 < parameterTypes.length) {
                                            if (!parameterTypes[i2].equals(methodParameterTypes[i2]) && parameterTypes[i2].indexOf(46) == -1 && methodParameterTypes[i2].indexOf(46) == -1) {
                                                equal = false;
                                                break;
                                            }
                                            ++i2;
                                        }
                                        if (!equal) continue;
                                        this.fJavaElement = method;
                                    }
                                }
                            }
                        }
                    }
                }
                catch (JavaModelException e) {
                    ELCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            return this.fJavaElement;
        }
    }

    private static class ProjectCache {
        Map<IMember, MemberInfo> memberInfoCacheFalse = new HashMap<IMember, MemberInfo>();
        Map<IMember, MemberInfo> memberInfoCacheTrue = new HashMap<IMember, MemberInfo>();
        Map<IType, SuperTypeInfo> superTypesCache = new HashMap<IType, SuperTypeInfo>();

        private ProjectCache() {
        }
    }

    public static class SuperTypeInfo {
        IType type;
        Set<String> names = new HashSet<String>();
        IType[] superTypes = new IType[0];

        SuperTypeInfo(IType type) throws JavaModelException {
            ITypeHierarchy typeHierarchy;
            this.type = type;
            ProjectCache cache = caches.get((IJavaElement)type);
            if (cache != null) {
                cache.superTypesCache.put(type, this);
            }
            IType[] iTypeArray = this.superTypes = (typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())) == null ? null : typeHierarchy.getAllSupertypes(type);
            if (this.superTypes != null) {
                int i = 0;
                while (i < this.superTypes.length) {
                    this.names.add(this.superTypes[i].getFullyQualifiedName());
                    ++i;
                }
            }
            if (this.superTypes == null) {
                this.superTypes = new IType[0];
            }
        }

        public Set<String> getNames() {
            return this.names;
        }

        public IType[] getSuperTypes() {
            return this.superTypes;
        }
    }

    public static class Type {
        private String fName;
        private String fQualifiedName;
        private Type[] fParameters;
        private IType fSource;
        private String fSignature;
        private boolean fIsArray;
        private Type fTypeOfArrayElement;
        private String fQualifiedTypeNameOfArrayElement;

        private Type() {
        }

        public static Type valueOf(String name) {
            Type instance = new Type();
            instance.setName(name);
            instance.setParameters(new Type[0]);
            return instance;
        }

        public Type(String signature, IType source) {
            if (signature != null) {
                String erasureSignature = Signature.getTypeErasure((String)signature);
                String typeOfArraySiganture = Signature.getElementType((String)erasureSignature);
                this.fName = String.valueOf(Signature.toString((String)erasureSignature));
                if (!erasureSignature.equals(typeOfArraySiganture)) {
                    this.fIsArray = true;
                    this.fTypeOfArrayElement = new Type(typeOfArraySiganture, source);
                }
                String[] signaturesOfParametersOfType = Signature.getTypeArguments((String)signature);
                this.fParameters = new Type[signaturesOfParametersOfType.length];
                int i = 0;
                while (i < signaturesOfParametersOfType.length) {
                    this.fParameters[i] = new Type(signaturesOfParametersOfType[i], source);
                    ++i;
                }
            } else {
                this.fName = source.getFullyQualifiedName();
                this.setParameters(new Type[0]);
            }
            this.fSource = source;
        }

        public void initializeParameters(Map<String, Type> parameters) {
            Type type = parameters.get(this.fName);
            if (type != null) {
                this.fName = type.getName();
                this.fParameters = type.getParameters();
                this.fSource = type.getSource();
                this.fIsArray = type.isArray();
                this.fTypeOfArrayElement = type.getTypeOfArrayElement();
            }
            int i = 0;
            while (i < this.fParameters.length) {
                if (this.fName == null || !this.fName.equals(this.fParameters[i].getName())) {
                    this.fParameters[i].initializeParameters(parameters);
                }
                ++i;
            }
        }

        public Type getParameter(int index) {
            if (this.fParameters.length > index) {
                return this.fParameters[index];
            }
            return null;
        }

        public String getQualifiedTypeNameOfArrayElement() {
            if (this.fQualifiedTypeNameOfArrayElement == null && this.fSource != null) {
                this.fQualifiedTypeNameOfArrayElement = EclipseJavaUtil.resolveType((IType)this.fSource, (String)this.fTypeOfArrayElement.getName());
            }
            return this.fQualifiedTypeNameOfArrayElement;
        }

        public String getQualifiedName() {
            if (this.fQualifiedName == null && this.fSource != null) {
                this.fQualifiedName = EclipseJavaUtil.resolveType((IType)this.fSource, (String)this.fName);
            }
            return this.fQualifiedName;
        }

        public boolean isArray() {
            return this.fIsArray;
        }

        public void setArray(boolean array) {
            this.fIsArray = array;
        }

        public Type getTypeOfArrayElement() {
            return this.fTypeOfArrayElement;
        }

        public void setTypeOfArrayElement(Type typeOfArrayElement) {
            this.fTypeOfArrayElement = typeOfArrayElement;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public Type[] getParameters() {
            return this.fParameters;
        }

        public void setParameters(Type[] parameters) {
            this.fParameters = parameters;
        }

        public IType getSource() {
            return this.fSource;
        }

        public void setSource(IType source) {
            this.fSource = source;
        }

        public String getSignature() {
            return this.fSignature;
        }

        public void setSignature(String signature) {
            this.fSignature = signature;
        }
    }

    public static class TypeInfo
    extends MemberInfo {
        private IType fType;
        private TypeInfo superType;
        private Map<String, Type> params = new HashMap<String, Type>();

        public TypeInfo(IType type, MemberInfo parentMember, boolean dataModel) throws JavaModelException {
            super(type.getDeclaringType(), type.getDeclaringType() == null ? null : type.getDeclaringType().getFullyQualifiedName(), type.getFullyQualifiedName(), type.getFlags(), parentMember, dataModel, Type.valueOf(type.getFullyQualifiedName()));
            this.fType = type;
        }

        public Type getParameterType(String name) {
            return this.params.get(name);
        }

        @Override
        public IType getMemberType() {
            return this.fType;
        }

        @Override
        public IJavaElement getJavaElement() {
            return this.fType;
        }

        @Override
        void initializeParameters() {
            try {
                MemberInfo parent = this.getParentMember();
                if (parent instanceof TypeMemberInfo) {
                    ITypeParameter[] parameters = this.fType.getTypeParameters();
                    int i = 0;
                    while (i < parameters.length) {
                        Type type = parent.getType().getParameter(i);
                        if (type != null) {
                            this.params.put(parameters[i].getElementName(), type);
                        }
                        ++i;
                    }
                }
                if (this.superType != null) {
                    this.superType.initializeParameters(this);
                }
            }
            catch (JavaModelException e) {
                ELCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }

        private void initializeParameters(TypeInfo inheritedType) throws JavaModelException {
            ITypeParameter[] parameters = this.fType.getTypeParameters();
            String signature = inheritedType.fType.getSuperclassTypeSignature();
            Type classType = new Type(signature, inheritedType.fType);
            int i = 0;
            while (i < parameters.length) {
                Type paramType = classType.getParameter(i);
                if (paramType != null) {
                    Type resolvedType = inheritedType.getParameterType(paramType.getName());
                    if (resolvedType != null) {
                        paramType = resolvedType;
                    }
                    this.params.put(parameters[i].getElementName(), paramType);
                }
                ++i;
            }
            if (this.superType != null) {
                this.superType.initializeParameters(this);
            }
        }

        public TypeInfo getSuperType() {
            return this.superType;
        }

        public void setSuperType(TypeInfo superType) {
            this.superType = superType;
        }
    }

    public static abstract class TypeMemberInfo
    extends MemberInfo {
        private String[] fParametersNamesOfDeclaringType;
        private TypeInfo declaratedType;

        protected TypeMemberInfo(IType sourceType, String declaringTypeQualifiedName, String name, int modifiers, TypeInfo parentMember, TypeInfo declaratedType, boolean dataModel, Type type) {
            super(sourceType, declaringTypeQualifiedName, name, modifiers, parentMember, dataModel, type);
            this.declaratedType = declaratedType;
        }

        public String[] getParametersNamesOfDeclaringType() {
            return this.fParametersNamesOfDeclaringType;
        }

        void setParametersNamesOfDeclaringType(String[] parametersNamesOfDeclaringType) {
            this.fParametersNamesOfDeclaringType = parametersNamesOfDeclaringType;
        }

        @Override
        protected void initializeParameters() {
            if (this.fParametersNamesOfDeclaringType != null && this.fParametersNamesOfDeclaringType.length > 0 && this.getParentMember() != null) {
                HashMap<String, Type> parametersOfDeclaringType = new HashMap<String, Type>();
                TypeInfo parentTypeInfo = (TypeInfo)this.getParentMember();
                parentTypeInfo.initializeParameters();
                this.declaratedType.initializeParameters();
                int i = 0;
                while (i < this.fParametersNamesOfDeclaringType.length) {
                    String parameterName = TypeInfoCollector.getParameterNameFromType(this.fParametersNamesOfDeclaringType[i]);
                    Type paramType = this.declaratedType.getParameterType(parameterName);
                    if (paramType != null) {
                        parametersOfDeclaringType.put(parameterName, paramType);
                    }
                    ++i;
                }
                this.getType().initializeParameters(parametersOfDeclaringType);
            }
        }

        public TypeInfo getDeclaratedType() {
            return this.declaratedType;
        }

        protected void setDeclaratedType(TypeInfo declaratedType) {
            this.declaratedType = declaratedType;
        }
    }
}

