/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.util;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.w3c.dom.Document;

public class StructuredModelWrapper {
    IStructuredModel model = null;

    public void init(IDocument id) {
        this.model = this.getModelManager().getExistingModelForRead(id);
    }

    public void init(IFile file) throws IOException, CoreException {
        this.model = this.getModelManager().getModelForRead(file);
    }

    public Document getDocument() {
        return this.model instanceof IDOMModel ? ((IDOMModel)this.model).getDocument() : null;
    }

    public XModel getXModel() {
        return AbstractHyperlink.getXModel(this.model);
    }

    public IFile getFile() {
        return AbstractHyperlink.getFile(this.model);
    }

    public String getBaseLocation() {
        return AbstractHyperlink.getBaseLocation(this.model);
    }

    public void dispose() {
        if (this.model != null) {
            this.model.releaseFromRead();
            this.model = null;
        }
    }

    protected IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public String getContentTypeIdentifier() {
        return this.model.getContentTypeIdentifier();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execute(IFile file, ICommand command) {
        IStructuredModel model = null;
        try {
            try {
                IDOMDocument xmlDocument;
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (!(model instanceof IDOMModel) || (xmlDocument = ((IDOMModel)model).getDocument()) == null) return;
                command.execute(xmlDocument);
                return;
            }
            catch (IOException e) {
                ExtensionsPlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                ExtensionsPlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static interface ICommand {
        public void execute(IDOMDocument var1);
    }
}

