/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.Utils;

public class XMLXmlNsHyperlink
extends AbstractHyperlink {
    protected final String JAR_FILE_PROTOCOL = "jar:file:/";
    protected final String JAR_FILE = "jar:file:";
    private int taglibLength;
    private int taglibOffset;

    @Override
    protected void doHyperlink(IRegion region) {
        try {
            String mappedSystemId = this.getMappedSystemIdFromCatalog(this.getPublicId(region), this.getSystemId(region));
            String filename = this.getFilenameFromMappedSystemId(mappedSystemId);
            IEditorPart part = null;
            if (filename != null) {
                part = this.openExternalFile(filename);
                if (part == null) {
                    this.openFileFailed();
                }
            } else if (mappedSystemId != null) {
                this.openFileInEditor(mappedSystemId);
            } else {
                String uri = this.getURI(region);
                if (uri != null && uri.toLowerCase().startsWith("http:")) {
                    URL url = null;
                    url = new URL(uri);
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    browser.openURL(url);
                } else {
                    this.openFileFailed();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.openFileFailed();
        }
        catch (PartInitException partInitException) {
            this.openFileFailed();
        }
    }

    @Override
    protected IEditorPart openExternalFile(String fileString) {
        File file = new File(fileString);
        if (!file.exists()) {
            return null;
        }
        StorageEditorInput input = new StorageEditorInput(file);
        String editorId = this.getEditorId(fileString);
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)input, editorId, true);
        }
        catch (PartInitException pie) {
            ExtensionsPlugin.getPluginLog().logError((Throwable)pie);
            return null;
        }
    }

    @Override
    protected void openFileInEditor(String fileString) {
        if (fileString.startsWith("jar:file:/")) {
            IEditorInput jarEditorInput = this.createEditorInput(fileString = fileString.substring("jar:file:/".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else if (fileString.startsWith("jar:file:")) {
            IEditorInput jarEditorInput = this.createEditorInputAlternate(fileString = fileString.substring("jar:file:".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            super.openFileInEditor(fileString);
        }
    }

    protected IEditorInput createEditorInputAlternate(String fileString) {
        String jarName = fileString.substring(0, fileString.indexOf("!"));
        String entryName = fileString.substring(fileString.indexOf("!") + 2, fileString.length());
        ZipFile jarFile = null;
        try {
            jarFile = new ZipFile(jarName);
        }
        catch (IOException iOException) {
            return null;
        }
        JarEntryFile jarEntryFile = new JarEntryFile(jarFile, entryName);
        JarEntryEditorInput jarEditorInput = new JarEntryEditorInput((IStorage)jarEntryFile){

            public boolean equals(Object arg) {
                return ((Object)((Object)this)).toString().equals(arg.toString());
            }
        };
        return jarEditorInput;
    }

    String getURI(IRegion region) {
        try {
            return Utils.trimQuotes(this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String getPublicId(IRegion region) {
        String text = this.getURI(region);
        if (text == null) {
            return null;
        }
        int spacer = text.indexOf(" ");
        if (spacer == -1) {
            spacer = text.indexOf("\t");
        }
        return spacer == -1 ? text : text.substring(0, spacer);
    }

    protected String getSystemId(IRegion region) {
        String text = this.getURI(region);
        if (text == null) {
            return null;
        }
        int spacer = text.indexOf(" ");
        if (spacer == -1) {
            spacer = text.indexOf("\t");
        }
        if (spacer == -1) {
            spacer = 0;
        }
        return text.substring(spacer).trim();
    }

    private String getMappedSystemIdFromCatalog(String publicId, String systemId) {
        String mappedSystemId = null;
        try {
            if (publicId != null) {
                mappedSystemId = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolvePublic(publicId, systemId);
            }
            if (mappedSystemId == null) {
                mappedSystemId = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveSystem(systemId);
            }
            if (mappedSystemId == null && systemId != null) {
                mappedSystemId = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveURI(systemId);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return mappedSystemId;
    }

    private String getFilenameFromMappedSystemId(String mappedSystemId) {
        String fileName = null;
        try {
            File file;
            if (mappedSystemId != null && (file = new File(new URL(mappedSystemId).getFile())).isFile()) {
                fileName = file.getAbsolutePath();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return fileName;
    }

    @Override
    public String getHyperlinkText() {
        String uri = this.getURI(this.getHyperlinkRegion());
        if (uri == null) {
            return MessageFormat.format(Messages.NotFound, "URI");
        }
        return MessageFormat.format(Messages.Open, uri);
    }

    class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput,
    IStorage,
    ILocationProvider {
        private File fFile;

        public StorageEditorInput(File file) {
            this.fFile = file;
        }

        public IStorage getStorage() {
            return this.fFile == null ? null : this;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fFile.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.getFullPath().toOSString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof StorageEditorInput) {
                StorageEditorInput input = (StorageEditorInput)((Object)o);
                return this.fFile.equals(input.fFile);
            }
            return false;
        }

        public int hashCode() {
            return this.fFile.hashCode();
        }

        public boolean exists() {
            return this.fFile.exists();
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(this.fFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public IPath getFullPath() {
            return new Path(this.fFile.getAbsolutePath());
        }

        public boolean isReadOnly() {
            return !this.fFile.canWrite();
        }

        public IPath getPath(Object element) {
            if (element instanceof StorageEditorInput) {
                return new Path(((StorageEditorInput)((Object)element)).fFile.getAbsolutePath());
            }
            return null;
        }
    }
}

