/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;

public abstract class LinkHyperlink
extends AbstractHyperlink {
    @Override
    protected void doHyperlink(IRegion region) {
        String fileName = this.getFilePath(region);
        IFile fileToOpen = this.getFileFromProject(fileName);
        if (fileToOpen != null && fileToOpen.exists()) {
            IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)fileToOpen, (boolean)true);
            }
            catch (CoreException coreException) {
                this.openFileFailed();
            }
            return;
        }
        try {
            URL url = new URL(fileName);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            this.openFileFailed();
        }
        catch (PartInitException partInitException) {
            this.openFileFailed();
        }
    }

    protected String getFilePath(IRegion region) {
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String updateFilenameForModel(String filename, IProject project) {
        return filename;
    }

    @Override
    public String getHyperlinkText() {
        String filePath = this.getFilePath(this.getHyperlinkRegion());
        if (filePath == null) {
            return MessageFormat.format(Messages.OpenA, Messages.File);
        }
        return MessageFormat.format(Messages.OpenFile, filePath);
    }
}

