/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkPartitionerDefinition;
import org.jboss.tools.common.text.ext.util.xpl.RegistryReader;

public class HyperlinkPartitionerBuilder
extends RegistryReader {
    public static final String PL_HYPERLINK_PARTITIONER = "hyperlinkPartitioner";
    public static final String PLUGIN_ID = "org.jboss.tools.common.text.ext";
    public static final String TAG_HYPERLINK_PARTITIONER = "hyperlinkPartitioner";
    public static final String TAG_CONTENT_TYPE_SYNONYM = "contentTypeSynonym";
    public static final String TAG_CONTENT_TYPE = "contentType";
    public static final String TAG_PARTITION_TYPE = "partitionType";
    public static final String TAG_AXIS = "axis";
    public static final String ATT_ID = "id";
    public static final String ATT_TYPE = "type";
    public static final String ATT_BASE = "base";
    public static final String ATT_CLASS = "class";
    public static final String ATT_PATH = "path";
    public static final String ATT_IGNORE_CASE = "ignoreCase";
    private static HyperlinkPartitionerBuilder fInstance;
    private ArrayList fPartitionerDefs;
    private HyperlinkPartitionerDefinition fCurrentHyperlinkPartitionerDefinition = null;
    private String fCurrentContentType;
    private String fCurrentPartitionType;
    protected String targetContributionTag;
    private Map<String, String> fContentTypeSynonyms = new HashMap<String, String>();

    public static synchronized HyperlinkPartitionerBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new HyperlinkPartitionerBuilder();
        }
        return fInstance;
    }

    private HyperlinkPartitionerBuilder() {
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            this.processHyperlinkPartitionerTag(element);
            if (this.fCurrentHyperlinkPartitionerDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_CONTENT_TYPE_SYNONYM)) {
            this.processContentTypeSynonymTag(element);
            return true;
        }
        if (tag.equals(TAG_CONTENT_TYPE)) {
            this.processContentTypeTag(element);
            if (this.fCurrentContentType != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_PARTITION_TYPE)) {
            this.processPartitionTypeTag(element);
            if (this.fCurrentPartitionType != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_AXIS)) {
            this.processAxisTag(element);
            return true;
        }
        return false;
    }

    private void processHyperlinkPartitionerTag(IConfigurationElement element) {
        String theId = this.getId(element);
        String theClass = this.getHyperlinkPartitionerClass(element);
        if (theId != null && theClass != null) {
            this.fCurrentHyperlinkPartitionerDefinition = new HyperlinkPartitionerDefinition(theId, theClass, element);
            if (this.fPartitionerDefs == null) {
                this.fPartitionerDefs = new ArrayList();
            }
            this.fPartitionerDefs.add(this.fCurrentHyperlinkPartitionerDefinition);
        } else {
            this.fCurrentHyperlinkPartitionerDefinition = null;
        }
    }

    private void processContentTypeSynonymTag(IConfigurationElement element) {
        String theType = this.getType(element);
        String theBase = this.getBase(element);
        if (theType != null && theBase != null) {
            this.fContentTypeSynonyms.put(theType.trim(), theBase.trim());
        }
    }

    private void processContentTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentContentType = theId;
            this.fCurrentHyperlinkPartitionerDefinition.addContentTypeId(this.fCurrentContentType);
        } else {
            this.fCurrentContentType = null;
        }
    }

    private void processPartitionTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentPartitionType = theId;
            this.fCurrentHyperlinkPartitionerDefinition.addPartitionType(this.fCurrentContentType, theId);
        } else {
            this.fCurrentPartitionType = null;
        }
    }

    private void processAxisTag(IConfigurationElement element) {
        String thePath = this.getPath(element);
        boolean ignoreCase = this.isIgnoreCase(element);
        if (thePath != null) {
            this.fCurrentHyperlinkPartitionerDefinition.addAxis(this.fCurrentContentType, this.fCurrentPartitionType, thePath, ignoreCase);
        }
    }

    protected String getId(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value;
    }

    protected String getPath(IConfigurationElement element) {
        String value = element.getAttribute(ATT_PATH);
        return value;
    }

    protected String getType(IConfigurationElement element) {
        String value = element.getAttribute(ATT_TYPE);
        return value;
    }

    protected String getBase(IConfigurationElement element) {
        String value = element.getAttribute(ATT_BASE);
        return value;
    }

    protected boolean isIgnoreCase(IConfigurationElement element) {
        String value = element.getAttribute(ATT_IGNORE_CASE);
        return "true".equals(value);
    }

    protected String getHyperlinkPartitionerClass(IConfigurationElement element) {
        String value = element.getAttribute(ATT_CLASS);
        return value;
    }

    private void initCache() {
        if (this.fPartitionerDefs == null) {
            this.readContributions("hyperlinkPartitioner", "hyperlinkPartitioner");
        }
    }

    protected void readContributions(String tag, String extensionPoint) {
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    public HyperlinkPartitionerDefinition[] getHyperlinkPartitionerDefinitions() {
        this.initCache();
        if (this.fPartitionerDefs == null) {
            return new HyperlinkPartitionerDefinition[0];
        }
        return this.fPartitionerDefs.toArray(new HyperlinkPartitionerDefinition[this.fPartitionerDefs.size()]);
    }

    public String getBaseContentType(String contentType) {
        this.initCache();
        if (contentType == null) {
            return null;
        }
        String baseContentType = contentType.trim();
        while (this.fContentTypeSynonyms.get(baseContentType) != null && !baseContentType.equalsIgnoreCase(this.fContentTypeSynonyms.get(baseContentType))) {
            baseContentType = this.fContentTypeSynonyms.get(baseContentType);
        }
        return baseContentType;
    }

    public HyperlinkPartitionerDefinition[] getHyperlinkPartitionerDefinitions(String contentType, String partitionType, String axis) {
        if (contentType == null || partitionType == null) {
            return null;
        }
        String baseContentType = this.getBaseContentType(contentType);
        HyperlinkPartitionerDefinition[] allDefs = this.getHyperlinkPartitionerDefinitions();
        ArrayList<HyperlinkPartitionerDefinition> defs = new ArrayList<HyperlinkPartitionerDefinition>();
        int i = 0;
        while (i < allDefs.length) {
            List contentTypes = allDefs[i].getContentTypes();
            int j = 0;
            while (j < contentTypes.size()) {
                HyperlinkPartitionerDefinition.PartitionType pType;
                HyperlinkPartitionerDefinition.ContentType cType = (HyperlinkPartitionerDefinition.ContentType)contentTypes.get(j);
                if ((contentType.equals(cType.getId()) || baseContentType.equals(cType.getId())) && (pType = cType.getPartitionType(partitionType)) != null && pType.containtsAxis(axis)) {
                    defs.add(allDefs[i]);
                }
                ++j;
            }
            ++i;
        }
        return defs.toArray(new HyperlinkPartitionerDefinition[defs.size()]);
    }
}

