/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.util.DirtyEditorTracker;
import org.jboss.tools.common.util.IEditorWrapper;

public class EclipseUIUtil {
    public static boolean isActiveEditorDirty() {
        SafeRunnableForActivePage sr = new SafeRunnableForActivePage();
        SafeRunnable.run((ISafeRunnable)sr);
        IEditorPart editor = sr.activeEditor;
        if (editor != null) {
            return editor.isDirty();
        }
        return false;
    }

    public static ITextEditor getActiveEditor() {
        SafeRunnableForActivePage sr = new SafeRunnableForActivePage();
        SafeRunnable.run((ISafeRunnable)sr);
        return sr.activeTextEditor;
    }

    public static boolean isOpenInActiveEditor(IFile file) {
        IEditorInput editorInput;
        if (file == null) {
            return false;
        }
        ITextEditor editor = EclipseUIUtil.getActiveEditor();
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            return file.equals((Object)fileInput.getFile());
        }
        return false;
    }

    public static Set<IFile> getDirtyFiles() {
        return DirtyEditorTracker.getInstance().getDirtyFiles();
    }

    private static class SafeRunnableForActivePage
    extends SafeRunnable {
        public ITextEditor activeTextEditor;
        public IEditorPart activeEditor;

        private SafeRunnableForActivePage() {
        }

        public void run() throws Exception {
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                this.activeEditor = page.getActiveEditor();
                if (this.activeEditor instanceof IEditorWrapper) {
                    this.activeEditor = ((IEditorWrapper)this.activeEditor).getEditor();
                }
                this.activeTextEditor = this.activeEditor instanceof ITextEditor ? (ITextEditor)this.activeEditor : (this.activeEditor == null ? null : (ITextEditor)this.activeEditor.getAdapter(ITextEditor.class));
            }
        }

        public void handleException(Throwable e) {
            CommonPlugin.getDefault().logError(e);
        }
    }
}

