/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wst.sse.ui.StructuredTextInvocationContext;
import org.eclipse.wst.sse.ui.internal.correction.CompoundQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistry;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.common.quickfix.IBaseMarkerResolution;
import org.jboss.tools.common.quickfix.QuickFixManager;
import org.jboss.tools.common.quickfix.QuickFixProposal;

public class MarkerAnnotationInfo {
    public final List<AnnotationInfo> infos;
    public final ISourceViewer viewer;
    private CompoundQuickAssistProcessor fCompoundQuickAssistProcessor = new CompoundQuickAssistProcessor();

    public MarkerAnnotationInfo(List<AnnotationInfo> infos, ISourceViewer textViewer) {
        this.infos = infos;
        this.viewer = textViewer;
    }

    public List<ICompletionProposal> getCompletionProposals(AnnotationInfo info) {
        if (info.isTop()) {
            return this.getMarkerProposals(info);
        }
        return this.getProposals(info);
    }

    public List<ICompletionProposal> getMarkerProposals(AnnotationInfo info) {
        IMarkerResolution[] resolutions;
        SimpleMarkerAnnotation annotation = (SimpleMarkerAnnotation)info.annotation;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] iMarkerResolutionArray = resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution resolution = iMarkerResolutionArray[n2];
            if (!MarkerAnnotationInfo.isDirty() || !(resolution instanceof IBaseMarkerResolution)) {
                proposals.add(new QuickFixProposal(resolution, marker));
            }
            ++n2;
        }
        TextInvocationContext sseContext = new TextInvocationContext(this.viewer, info.position.getOffset(), info.position.getLength());
        ICompletionProposal[] compoundQuickAssistProcessorProposals = this.fCompoundQuickAssistProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)sseContext);
        if (compoundQuickAssistProcessorProposals != null) {
            ICompletionProposal[] iCompletionProposalArray = compoundQuickAssistProcessorProposals;
            int n3 = compoundQuickAssistProcessorProposals.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompletionProposal p = iCompletionProposalArray[n4];
                proposals.add(p);
                ++n4;
            }
        }
        return proposals;
    }

    public List<ICompletionProposal> getProposals(AnnotationInfo info) {
        TemporaryAnnotation annotation = (TemporaryAnnotation)info.annotation;
        ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
        ArrayList<IQuickAssistProcessor> processors = new ArrayList<IQuickAssistProcessor>();
        if (this.canFix((Annotation)annotation)) {
            Object o = annotation.getAdditionalFixInfo();
            if (o instanceof IQuickAssistProcessor) {
                processors.add((IQuickAssistProcessor)o);
            }
            if (MarkerAnnotationInfo.isDirty() && QuickFixManager.getInstance().hasProposals((Annotation)annotation, info.position)) {
                annotation.setAdditionalFixInfo((Object)this.viewer.getDocument());
                List<IJavaCompletionProposal> proposals = QuickFixManager.getInstance().getProposals((Annotation)annotation, info.position);
                allProposals.addAll(proposals);
            }
            QuickFixRegistry registry = QuickFixRegistry.getInstance();
            processors.addAll(Arrays.asList(registry.getQuickFixProcessors((Annotation)annotation)));
            Map attributes = annotation.getAttributes();
            StructuredTextInvocationContext sseContext = new StructuredTextInvocationContext(this.viewer, info.position.getOffset(), info.position.getLength(), attributes);
            ICompletionProposal[] compoundQuickAssistProcessorProposals = this.fCompoundQuickAssistProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)sseContext);
            if (compoundQuickAssistProcessorProposals != null) {
                ICompletionProposal[] iCompletionProposalArray = compoundQuickAssistProcessorProposals;
                int n = compoundQuickAssistProcessorProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal p = iCompletionProposalArray[n2];
                    allProposals.add(p);
                    ++n2;
                }
            }
            int i = 0;
            while (i < processors.size()) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                this.collectProposals((IQuickAssistProcessor)processors.get(i), (Annotation)annotation, (IQuickAssistInvocationContext)sseContext, proposals);
                if (proposals.size() > 0) {
                    allProposals.addAll(proposals);
                }
                ++i;
            }
        }
        return allProposals;
    }

    private static boolean isDirty() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            return editor.isDirty();
        }
        return true;
    }

    private void collectProposals(IQuickAssistProcessor processor, Annotation annotation, IQuickAssistInvocationContext invocationContext, List<ICompletionProposal> proposalsList) {
        ICompletionProposal[] proposals = processor.computeQuickAssistProposals(invocationContext);
        if (proposals != null && proposals.length > 0) {
            proposalsList.addAll(Arrays.asList(proposals));
        }
    }

    public boolean canFix(Annotation annotation) {
        if (annotation instanceof IQuickFixableAnnotation) {
            if (((IQuickFixableAnnotation)annotation).isQuickFixableStateSet()) {
                return ((IQuickFixableAnnotation)annotation).isQuickFixable();
            }
        } else if (annotation instanceof TemporaryAnnotation && ((TemporaryAnnotation)annotation).isQuickFixableStateSet()) {
            return ((TemporaryAnnotation)annotation).isQuickFixable();
        }
        return false;
    }

    public String toString() {
        return null;
    }

    public static class AnnotationInfo {
        public Annotation annotation;
        public Position position;

        public AnnotationInfo(Annotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }

        public boolean isTop() {
            return this.annotation instanceof SimpleMarkerAnnotation;
        }
    }
}

