/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model.helpers;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.tld.model.TLDUtil;

public class TLDToPaletteHelper {
    public static final String START_TEXT = "start text";
    public static final String END_TEXT = "end text";
    public static final String REFORMAT = "automatically reformat tag body";
    public static final String DESCRIPTION = "description";
    public static final String URI = "library uri";
    public static final String DEFAULT_PREFIX = "default prefix";
    public static final String ADD_TAGLIB = "add taglib";

    public XModelObject createMacroByTag(XModelObject tag, XModel model) {
        Properties p = new Properties();
        String parentname = TLDToPaletteHelper.getTldName(tag.getParent());
        String prefix = parentname.length() == 0 ? "" : String.valueOf(parentname) + ":";
        String shortname = tag.getAttributeValue("name");
        String name = String.valueOf(prefix) + shortname;
        String tagname = shortname;
        p.setProperty("name", shortname);
        boolean empty = "empty".equals(tag.getAttributeValue("bodycontent"));
        if (!empty) {
            p.setProperty(END_TEXT, "</" + tagname + ">");
        }
        p.setProperty(START_TEXT, this.getStartText(tag, empty, tagname));
        p.setProperty(DESCRIPTION, this.getTagDescription(tag, empty, name));
        if (!empty) {
            p.setProperty(REFORMAT, "yes");
        }
        return model.createModelObject("SharableMacroHTML", p);
    }

    public static String getTldName(XModelObject tld) {
        int s;
        int q;
        if (tld == null) {
            return "";
        }
        String n = tld.getAttributeValue("shortname");
        if (n == null) {
            return "";
        }
        if (n.length() == 0 && (q = (n = tld.getAttributeValue("name")).lastIndexOf(45)) >= 0) {
            n = n.substring(q + 1);
        }
        if ((s = n.lastIndexOf(32)) >= 0) {
            n = n.substring(s + 1);
        }
        return n.toLowerCase();
    }

    private String getStartText(XModelObject tag, boolean empty, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(name);
        XModelObject[] as = tag.getChildren();
        boolean found = false;
        int i = 0;
        while (i < as.length) {
            String required;
            if (TLDUtil.isAttribute(as[i]) && ("true".equals(required = as[i].getAttributeValue("required")) || "yes".equals(required))) {
                sb.append(' ').append(as[i].getAttributeValue("name")).append("=\"");
                if (!found) {
                    sb.append('|');
                    found = true;
                }
                sb.append('\"');
            }
            ++i;
        }
        if (empty) {
            sb.append("/");
        }
        sb.append(">");
        return sb.toString();
    }

    private String getTagDescription(XModelObject tag, boolean empty, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>Syntax:</b><br><code>");
        if (empty) {
            sb.append("&lt;" + name + " /&gt;");
        } else {
            sb.append("&lt;" + name + "&gt;</code><br><code>&lt;/" + name + "&gt;");
        }
        sb.append("</code><br>");
        sb.append("<b>Attributes:</b><br><code>");
        int k = 0;
        XModelObject[] as = tag.getChildren();
        int i = 0;
        while (i < as.length) {
            if (TLDUtil.isAttribute(as[i]) && this.isRequired(as[i])) {
                sb.append("<b>").append(as[i].getAttributeValue("name")).append("</b>");
                if (++k < as.length) {
                    sb.append(", ");
                }
            }
            ++i;
        }
        i = 0;
        while (i < as.length) {
            if (TLDUtil.isAttribute(as[i]) && !this.isRequired(as[i])) {
                sb.append(as[i].getAttributeValue("name"));
                if (++k < as.length) {
                    sb.append(", ");
                }
            }
            ++i;
        }
        sb.append("</code>");
        return sb.toString();
    }

    public XModelObject createMacroByFaceletTag(XModelObject tag, XModel model) {
        Properties p = new Properties();
        String parentname = TLDToPaletteHelper.getFaceletTldName(tag.getParent());
        String prefix = parentname.length() == 0 ? "" : String.valueOf(parentname) + ":";
        String shortname = tag.getAttributeValue("tag-name");
        String name = String.valueOf(prefix) + shortname;
        String tagname = shortname;
        p.setProperty("name", shortname);
        boolean empty = false;
        if (!empty) {
            p.setProperty(END_TEXT, "</" + tagname + ">");
        }
        p.setProperty(START_TEXT, this.getStartText(tag, empty, tagname));
        p.setProperty(DESCRIPTION, this.getTagDescription(tag, empty, name));
        if (!empty) {
            p.setProperty(REFORMAT, "yes");
        }
        return model.createModelObject("SharableMacroHTML", p);
    }

    public static String getFaceletTldName(XModelObject tld) {
        int s;
        String p;
        String suff;
        if (tld == null) {
            return "";
        }
        String n = tld.getAttributeValue("name");
        if (n.endsWith(suff = ".taglib") && !"jsp".equals(p = n.substring(0, n.length() - suff.length()).toLowerCase())) {
            return p;
        }
        String u = tld.getAttributeValue("uri");
        if (u != null) {
            int q = u.lastIndexOf(47);
            if (q >= 0) {
                u = u.substring(q + 1);
            }
            n = u;
        }
        if ((s = n.lastIndexOf(32)) >= 0) {
            n = n.substring(s + 1);
        }
        return n.toLowerCase();
    }

    private boolean isRequired(XModelObject attr) {
        String required = attr.getAttributeValue("required");
        return "true".equals(required) || "true".equals(required);
    }

    public XModelObject createTabByTLD(XModelObject tld, XModel model) {
        return this.createGroupByTLD(tld, model, "SharablePageTabHTML");
    }

    public XModelObject createGroupByTLD(XModelObject tld, XModel model) {
        return this.createGroupByTLD(tld, model, "SharableGroupHTML");
    }

    private XModelObject createGroupByTLD(XModelObject tld, XModel model, String entity) {
        Properties p = new Properties();
        p.setProperty("name", this.capitalize(TLDToPaletteHelper.getTldName(tld)));
        p.setProperty(DESCRIPTION, TLDUtil.getTagDescription(tld));
        p.setProperty(DEFAULT_PREFIX, TLDToPaletteHelper.getTldName(tld));
        p.setProperty(URI, tld.getAttributeValue("uri"));
        XModelObject tab = model.createModelObject(entity, p);
        XModelObject[] tags = tld.getChildren();
        int i = 0;
        while (i < tags.length) {
            if (TLDUtil.isTag(tags[i])) {
                tab.addChild(this.createMacroByTag(tags[i], model));
            }
            if (TLDUtil.isFaceletTag(tags[i])) {
                tab.addChild(this.createMacroByFaceletTag(tags[i], model));
            }
            ++i;
        }
        XModelObject f = tld.getChildByPath("Functions");
        if (f != null) {
            XModelObject[] fs = f.getChildren();
            int i2 = 0;
            while (i2 < fs.length) {
                tab.addChild(this.createMacroByFunction(fs[i2], model));
                ++i2;
            }
        }
        return tab;
    }

    private String capitalize(String s) {
        return s.length() == 0 ? s : String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public XModelObject createMacroByFunction(XModelObject tag, XModel model) {
        Properties p = new Properties();
        String shortname = tag.getAttributeValue("name");
        p.setProperty("name", shortname);
        String signature = tag.getAttributeValue("function-signature");
        int i = signature.indexOf("(");
        int j = signature.indexOf(")");
        ArrayList<String> paramTypes = new ArrayList<String>();
        if (i >= 0 && j > i) {
            String params = signature.substring(i + 1, j);
            StringTokenizer st = new StringTokenizer(params, ",");
            while (st.hasMoreTokens()) {
                String param = st.nextToken().trim();
                paramTypes.add(param);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        sb.append(shortname);
        sb.append("(");
        int k = 0;
        while (k < paramTypes.size()) {
            if (k > 0) {
                sb.append(", ");
            }
            sb.append("''");
            ++k;
        }
        sb.append(")");
        sb.append("}");
        p.setProperty(START_TEXT, sb.toString());
        sb = new StringBuffer();
        sb.append("<b>").append(shortname).append("</b><br>");
        sb.append(signature);
        p.setProperty(DESCRIPTION, sb.toString());
        return model.createModelObject("SharableMacroHTML", p);
    }
}

