/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.io.File;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.LibrarySet;

public class AddJarToLibrarySetSupport
extends SpecialWizardSupport {
    LibrarySet librarySet;
    protected DefaultWizardDataValidator validator = new JarValidator();

    public static String run(LibrarySet librarySet) {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        String entity = "LibrarySet";
        String actionPath = "CreateActions.AddJar";
        Properties p = new Properties();
        p.put("librarySet", librarySet);
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("jarname");
    }

    public void reset() {
        this.librarySet = (LibrarySet)this.getProperties().get("librarySet");
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        String location = this.extractStepData(0).getProperty("location");
        String jarname = this.librarySet.addJar(location);
        this.getProperties().setProperty("jarname", jarname);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    class JarValidator
    extends DefaultWizardDataValidator {
        JarValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String location = data.getProperty("location").replace('\\', '/');
            if (!new File(location).isFile()) {
                this.message = NLS.bind((String)WebUIMessages.FILE_DOESNOT_EXIST, (Object)location);
            }
        }
    }
}

