/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.collections;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.Properties;

public class CollectionsUtils {
    public static <T> T[] reverse(T[] array) {
        if (array == null) {
            return array;
        }
        int s = 0;
        for (int e = array.length - 1; s < e; ++s, --e) {
            T tmp = array[e];
            array[e] = array[s];
            array[s] = tmp;
        }
        return array;
    }

    public static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> clazz, T ... ts) {
        if (ts == null) {
            return null;
        }
        EnumSet<T> res = EnumSet.noneOf(clazz);
        for (T t : ts) {
            res.add(t);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        if (file == null) {
            return null;
        }
        FileReader reader = new FileReader(file);
        try {
            Properties properties = CollectionsUtils.loadProperties(reader);
            return properties;
        }
        finally {
            reader.close();
        }
    }

    public static Properties loadProperties(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }
}

