/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.jms;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.jms.JMSVendor;
import org.apache.qpid.proton.jms.OutboundTransformer;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.apache.qpid.proton.message.impl.MessageFactoryImpl;

public class JMSMappingOutboundTransformer
extends OutboundTransformer {
    private static final MessageFactoryImpl MESSAGE_FACTORY = new MessageFactoryImpl();
    String prefixDeliveryAnnotations = "DA_";
    String prefixMessageAnnotations = "MA_";
    String prefixFooter = "FT_";

    public JMSMappingOutboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    @Override
    public EncodedMessage transform(Message msg) throws Exception {
        if (msg == null) {
            return null;
        }
        try {
            if (msg.getBooleanProperty(this.prefixVendor + "NATIVE")) {
                return null;
            }
        }
        catch (MessageFormatException e) {
            return null;
        }
        return JMSMappingOutboundTransformer.transform(this, msg);
    }

    static EncodedMessage transform(JMSMappingOutboundTransformer options, Message msg) throws JMSException, UnsupportedEncodingException {
        String key;
        MapMessage m;
        long messageFormat;
        JMSVendor vendor = options.vendor;
        String messageFormatKey = options.prefixVendor + "MESSAGE_FORMAT";
        String nativeKey = options.prefixVendor + "NATIVE";
        String firstAcquirerKey = options.prefixVendor + "FirstAcquirer";
        String prefixDeliveryAnnotationsKey = options.prefixVendor + options.prefixDeliveryAnnotations;
        String prefixMessageAnnotationsKey = options.prefixVendor + options.prefixMessageAnnotations;
        String subjectKey = options.prefixVendor + "Subject";
        String contentTypeKey = options.prefixVendor + "ContentType";
        String contentEncodingKey = options.prefixVendor + "ContentEncoding";
        String replyToGroupIDKey = options.prefixVendor + "ReplyToGroupID";
        String prefixFooterKey = options.prefixVendor + options.prefixFooter;
        try {
            messageFormat = msg.getLongProperty(messageFormatKey);
        }
        catch (MessageFormatException e) {
            return null;
        }
        Header header = new Header();
        Properties props = new Properties();
        HashMap<String, Object> daMap = null;
        HashMap<String, String> maMap = null;
        HashMap<String, Object> apMap = null;
        Section body = null;
        HashMap<String, Object> footerMap = null;
        if (msg instanceof BytesMessage) {
            BytesMessage m2 = (BytesMessage)msg;
            byte[] data = new byte[(int)m2.getBodyLength()];
            m2.readBytes(data);
            body = new Data(new Binary(data));
        }
        if (msg instanceof TextMessage) {
            body = new AmqpValue(((TextMessage)msg).getText());
        }
        if (msg instanceof MapMessage) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            m = (MapMessage)msg;
            Enumeration names = m.getMapNames();
            while (names.hasMoreElements()) {
                key = (String)names.nextElement();
                map2.put(key, m.getObject(key));
            }
            body = new AmqpValue(map2);
        }
        if (msg instanceof StreamMessage) {
            ArrayList<Object> list = new ArrayList<Object>();
            m = (StreamMessage)msg;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException e) {
                body = new AmqpSequence(list);
            }
        }
        if (msg instanceof ObjectMessage) {
            body = new AmqpValue(((ObjectMessage)msg).getObject());
        }
        header.setDurable(msg.getJMSDeliveryMode() == 2);
        header.setPriority(new UnsignedByte((byte)msg.getJMSPriority()));
        if (msg.getJMSType() != null) {
            if (maMap == null) {
                maMap = new HashMap<String, String>();
            }
            maMap.put("x-opt-jms-type", msg.getJMSType());
        }
        if (msg.getJMSMessageID() != null) {
            props.setMessageId(msg.getJMSMessageID());
        }
        if (msg.getJMSDestination() != null) {
            props.setTo(vendor.toAddress(msg.getJMSDestination()));
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put("x-opt-to-type", JMSMappingOutboundTransformer.destinationAttributes(msg.getJMSDestination()));
        }
        if (msg.getJMSReplyTo() != null) {
            props.setReplyTo(vendor.toAddress(msg.getJMSReplyTo()));
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put("x-opt-reply-type", JMSMappingOutboundTransformer.destinationAttributes(msg.getJMSReplyTo()));
        }
        if (msg.getJMSCorrelationID() != null) {
            props.setCorrelationId(msg.getJMSCorrelationID());
        }
        long now = msg.getJMSTimestamp();
        if (msg.getJMSExpiration() != 0L) {
            if (now == 0L) {
                now = System.currentTimeMillis();
            }
            props.setAbsoluteExpiryTime(new Date(msg.getJMSExpiration()));
            header.setTtl(new UnsignedInteger((int)(msg.getJMSExpiration() - now)));
        }
        if (now != 0L) {
            props.setCreationTime(new Date(now));
        }
        Enumeration keys = msg.getPropertyNames();
        while (keys.hasMoreElements()) {
            String name;
            Object value;
            key = (String)keys.nextElement();
            if (key.equals(messageFormatKey) || key.equals(nativeKey)) continue;
            if (key.equals(firstAcquirerKey)) {
                header.setFirstAcquirer(msg.getBooleanProperty(key));
                continue;
            }
            if (key.startsWith("JMSXDeliveryCount")) {
                header.setDeliveryCount(new UnsignedInteger(msg.getIntProperty(key)));
                continue;
            }
            if (key.startsWith("JMSXUserID")) {
                value = msg.getStringProperty(key);
                props.setUserId(new Binary(((String)value).getBytes("UTF-8")));
                continue;
            }
            if (key.startsWith("JMSXGroupID")) {
                value = msg.getStringProperty(key);
                props.setGroupId((String)value);
                if (apMap == null) {
                    apMap = new HashMap<String, Object>();
                }
                apMap.put(key, value);
                continue;
            }
            if (key.startsWith("JMSXGroupSeq")) {
                value = new UnsignedInteger(msg.getIntProperty(key));
                props.setGroupSequence((UnsignedInteger)value);
                if (apMap == null) {
                    apMap = new HashMap();
                }
                apMap.put(key, value);
                continue;
            }
            if (key.startsWith(prefixDeliveryAnnotationsKey)) {
                if (daMap == null) {
                    daMap = new HashMap<String, Object>();
                }
                name = key.substring(prefixDeliveryAnnotationsKey.length());
                daMap.put(name, msg.getObjectProperty(key));
                continue;
            }
            if (key.startsWith(prefixMessageAnnotationsKey)) {
                if (maMap == null) {
                    maMap = new HashMap();
                }
                name = key.substring(prefixMessageAnnotationsKey.length());
                maMap.put(name, (String)msg.getObjectProperty(key));
                continue;
            }
            if (key.equals(subjectKey)) {
                props.setSubject(msg.getStringProperty(key));
                continue;
            }
            if (key.equals(contentTypeKey)) {
                props.setContentType(Symbol.getSymbol(msg.getStringProperty(key)));
                continue;
            }
            if (key.equals(contentEncodingKey)) {
                props.setContentEncoding(Symbol.getSymbol(msg.getStringProperty(key)));
                continue;
            }
            if (key.equals(replyToGroupIDKey)) {
                props.setReplyToGroupId(msg.getStringProperty(key));
                continue;
            }
            if (key.startsWith(prefixFooterKey)) {
                if (footerMap == null) {
                    footerMap = new HashMap<String, Object>();
                }
                name = key.substring(prefixFooterKey.length());
                footerMap.put(name, msg.getObjectProperty(key));
                continue;
            }
            if (apMap == null) {
                apMap = new HashMap();
            }
            apMap.put(key, msg.getObjectProperty(key));
        }
        MessageAnnotations ma = null;
        if (maMap != null) {
            ma = new MessageAnnotations(maMap);
        }
        DeliveryAnnotations da = null;
        if (daMap != null) {
            da = new DeliveryAnnotations(daMap);
        }
        ApplicationProperties ap = null;
        if (apMap != null) {
            ap = new ApplicationProperties(apMap);
        }
        Footer footer = null;
        if (footerMap != null) {
            footer = new Footer(footerMap);
        }
        ProtonJMessage amqp = MESSAGE_FACTORY.createMessage(header, da, ma, props, ap, body, footer);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4096]);
        DroppingWritableBuffer overflow = new DroppingWritableBuffer();
        int c = amqp.encode(new CompositeWritableBuffer(new WritableBuffer.ByteBufferWrapper(buffer), overflow));
        if (overflow.position() > 0) {
            buffer = ByteBuffer.wrap(new byte[4096 + overflow.position()]);
            c = amqp.encode(new WritableBuffer.ByteBufferWrapper(buffer));
        }
        return new EncodedMessage(messageFormat, buffer.array(), 0, c);
    }

    private static String destinationAttributes(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return "temporary,queue";
            }
            return "queue";
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return "temporary,topic";
            }
            return "topic";
        }
        return "";
    }
}

