/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.servers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.OverlaySelfComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;

public class OverlayResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers.length == 0) {
            return;
        }
        IResourceDelta[] projectDeltas = delta.getAffectedChildren();
        if (projectDeltas == null || projectDeltas.length == 0) {
            return;
        }
        boolean buildOccurred = this.hasBuildOccurred(event);
        Set<IProject> changedProjects = this.getChangedProjects(projectDeltas);
        if (changedProjects.isEmpty()) {
            return;
        }
        HashMap<IServer, ArrayList<IModule>> republishableServers = new HashMap<IServer, ArrayList<IModule>>(servers.length);
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IModule[] iModuleArray = server.getModules();
            int n3 = iModuleArray.length;
            int n4 = 0;
            block1: while (n4 < n3) {
                IModule module = iModuleArray[n4];
                IProject moduleProject = module.getProject();
                for (IProject changedProject : changedProjects) {
                    if (!this.hasOverlayChanged(changedProject, moduleProject, delta)) continue;
                    ArrayList<IModule> republishableModules = (ArrayList<IModule>)republishableServers.get(server);
                    if (republishableModules == null) {
                        republishableModules = new ArrayList<IModule>(server.getModules().length);
                        republishableServers.put(server, republishableModules);
                    }
                    republishableModules.add(module);
                    break block1;
                }
                ++n4;
            }
            ++n2;
        }
        if (republishableServers.isEmpty()) {
            return;
        }
        boolean isPublishOverlaysEnabled = this.isPublishOverlaysEnabled();
        for (Map.Entry entries : republishableServers.entrySet()) {
            IServer iserver = (IServer)entries.getKey();
            boolean shouldPublish = isPublishOverlaysEnabled;
            if (iserver instanceof Server) {
                Server server = (Server)iserver;
                List modules = (List)entries.getValue();
                IModule[] mod = new IModule[modules.size()];
                modules.toArray(mod);
                server.setModulePublishState(mod, 2);
                int autoPublishSetting = server.getAutoPublishSetting();
                boolean bl = shouldPublish = shouldPublish && (autoPublishSetting == 2 || autoPublishSetting == 3 && buildOccurred);
            }
            if (!shouldPublish || iserver.getServerState() != 2) continue;
            iserver.publish(1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean isPublishOverlaysEnabled() {
        boolean isEnabled = new InstanceScope().getNode("org.eclipse.m2e.wtp.overlay").getBoolean("republishOnProjectChange", true);
        return isEnabled;
    }

    private Set<IProject> getChangedProjects(IResourceDelta[] projectDeltas) {
        HashSet<IProject> projects = new HashSet<IProject>();
        if (projectDeltas != null) {
            IResourceDelta[] iResourceDeltaArray = projectDeltas;
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IResource resource = delta.getResource();
                if (resource != null && resource instanceof IProject) {
                    projects.add((IProject)resource);
                }
                ++n2;
            }
        }
        return projects;
    }

    private boolean hasOverlayChanged(IProject changedProject, IProject projectDeployedOnServer, IResourceDelta delta) {
        if (!ModuleCoreNature.isFlexibleProject((IProject)projectDeployedOnServer)) {
            return false;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)projectDeployedOnServer);
        if (component == null) {
            return false;
        }
        IVirtualReference[] references = component.getReferences();
        if (references == null || references.length == 0) {
            return false;
        }
        IVirtualReference[] iVirtualReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference reference = iVirtualReferenceArray[n2];
            IVirtualComponent vc = reference.getReferencedComponent();
            if (vc instanceof IOverlayVirtualComponent) {
                IPath componentFilePath;
                IProject overlaidProject = vc.getProject();
                if (vc instanceof OverlaySelfComponent ? delta.findMember(componentFilePath = overlaidProject.getFile(".settings/org.eclipse.wst.common.component").getFullPath()) != null : !vc.isBinary() && overlaidProject.equals((Object)changedProject)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean hasBuildOccurred(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        int kind = event.getBuildKind();
        return kind == 10 || kind == 6 || kind == 9 && ResourcesPlugin.getWorkspace().isAutoBuilding();
    }
}

