/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.livereload.ui.JBossLiveReloadUIActivator;

public final class Logger {
    private static final String INFO = "org.jboss.tools.livereload.ui/info";
    private static final String DEBUG = "org.jboss.tools.livereload.ui/debug";
    private static final String TRACE = "org.jboss.tools.livereload.ui/trace";
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private Logger() {
    }

    public static void error(String message, Throwable t) {
        if (JBossLiveReloadUIActivator.getDefault() != null) {
            JBossLiveReloadUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.livereload.ui", message, t));
        } else {
            t.printStackTrace();
        }
    }

    public static void error(String message) {
        JBossLiveReloadUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.livereload.ui", message));
    }

    public static void warn(String message, Throwable t) {
        JBossLiveReloadUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.livereload.ui", message, t));
    }

    public static void warn(String message) {
        JBossLiveReloadUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.livereload.ui", message));
    }

    public static void info(String message) {
        if (Logger.isOptionEnabled(INFO)) {
            JBossLiveReloadUIActivator.getDefault().getLog().log((IStatus)new Status(1, "org.jboss.tools.livereload.ui", message));
        }
    }

    public static void info(String message, Object ... items) {
        Logger.log(INFO, message, items);
    }

    public static void debug(String message) {
        Logger.debug(message, null);
    }

    public static void debug(String message, Object ... items) {
        Logger.log(DEBUG, message, items);
    }

    public static void trace(String message, Object ... items) {
        Logger.log(TRACE, message, items);
    }

    /*
     * Unable to fully structure code
     */
    private static void log(String level, String message, Object ... items) {
        block5: {
            try {
                if (!Logger.isOptionEnabled(level)) break block5;
                valuedMessage = message;
                if (items != null) {
                    var7_5 = items;
                    var6_6 = items.length;
                    var5_8 = 0;
                    while (var5_8 < var6_6) {
                        item = var7_5[var5_8];
                        valuedMessage = valuedMessage.replaceFirst("\\{\\}", item != null ? item.toString().replaceAll("\\$", ".") : "null");
                        ++var5_8;
                    }
                }
                System.out.println(String.valueOf(Logger.dateFormatter.get().format(new Date())) + " [" + Thread.currentThread().getName() + "] " + level.substring(level.indexOf("/") + 1).toUpperCase() + " " + valuedMessage);
                break block5;
            }
            catch (RuntimeException v0) {
                System.err.println("Failed to write proper debug message with template:\n " + message + "\n and items:");
                var6_7 = items;
                var5_9 = items.length;
                var4_11 = 0;
                ** while (var4_11 < var5_9)
            }
lbl-1000:
            // 1 sources

            {
                item = var6_7[var4_11];
                System.err.println(" " + item);
                ++var4_11;
                continue;
            }
        }
    }

    private static boolean isOptionEnabled(String level) {
        String debugOption = Platform.getDebugOption((String)level);
        return JBossLiveReloadUIActivator.getDefault() != null && JBossLiveReloadUIActivator.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }

    public static boolean isDebugEnabled() {
        return Logger.isOptionEnabled(DEBUG);
    }
}

