/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.OpenInWebBrowserViaLiveReloadUtils;
import org.jboss.tools.livereload.ui.internal.util.Logger;
import org.jboss.tools.livereload.ui.internal.util.Pair;

public class OpenInWebBrowserWithLiveReloadLauncher
implements IEditorLauncher {
    public void open(final IPath file) {
        try {
            Pair<IServer, Boolean> result = OpenInWebBrowserViaLiveReloadUtils.openWithLiveReloadServer(file, true, false);
            if (result != null) {
                final IServer liveReloadServer = (IServer)result.left;
                boolean needsStartOrRestart = (Boolean)result.right;
                if (needsStartOrRestart) {
                    Job startOrRestartJob = WSTUtils.startOrRestartServer((IServer)liveReloadServer, (int)30, (TimeUnit)TimeUnit.SECONDS);
                    startOrRestartJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                OpenInWebBrowserWithLiveReloadLauncher.this.openInWebBrowser(file, liveReloadServer);
                            }
                        }
                    });
                    startOrRestartJob.schedule();
                } else {
                    this.openInWebBrowser(file, liveReloadServer);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Failed to Open in Web Browser via LiveReload", e);
        }
    }

    private void openInWebBrowser(final IPath file, final IServer liveReloadServer) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    OpenInWebBrowserViaLiveReloadUtils.openInBrowser(file, liveReloadServer);
                }
                catch (Exception exception) {
                    Logger.error("Failed to open selected Server Module in external Web Browser...");
                }
            }
        });
    }
}

