/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import org.eclipse.compare.Splitter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.StorageRevisionEditorInputAdapter;
import org.jboss.tools.jst.web.ui.internal.editor.selection.bar.SelectionBar;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.IVisualEditor2;
import org.jboss.tools.vpe.editor.mozilla.listener.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.xpl.CustomSashForm;
import org.jboss.tools.vpe.editor.xpl.EditorSettings;
import org.jboss.tools.vpe.editor.xpl.SashSetting;
import org.jboss.tools.vpe.preview.editor.Messages;
import org.jboss.tools.vpe.preview.editor.VpvEditor;
import org.jboss.tools.vpe.preview.editor.VpvEditorController;
import org.jboss.tools.vpe.preview.editor.VpvPreview;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;

public class VpvEditorPart
extends EditorPart
implements IVisualEditor2 {
    public static final String ID = "org.jboss.tools.vpe.vpv.views.VpvView";
    protected EditorSettings editorSettings;
    private SelectionBar selectionBar;
    private StructuredTextEditor sourceEditor;
    private int visualMode;
    private CustomSashForm container;
    private EditorPart multiPageEditor;
    private BundleMap bundleMap;
    private Composite cmpEd;
    private Composite cmpEdTl;
    private ControlListener controlListener;
    private ActivationListener activationListener = new ActivationListener();
    private Composite sourceContent = null;
    private Composite visualContent = null;
    private Composite previewContent = null;
    private Splitter verticalToolbarSplitter = null;
    private Composite verticalToolbarEmpty = null;
    private ToolBar toolBar = null;
    IEditorPart activeEditor;
    private VpvEditor visualEditor;
    private VpvPreview vpvPreview;

    public VpvEditorPart(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        this.sourceEditor = textEditor;
        this.visualMode = visualMode;
        this.multiPageEditor = multiPageEditor;
        this.bundleMap = bundleMap;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.addRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.removeRulerContextMenuListener(listener);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        this.sourceEditor.setStatusField(field, category);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.sourceEditor != null) {
            this.sourceEditor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.sourceEditor != null) {
            this.sourceEditor.doSaveAs();
            this.setInput(this.sourceEditor.getEditorInput());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (this.editorSettings == null) {
            this.editorSettings = EditorSettings.getEditorSetting((IEditorPart)this);
        } else if (input instanceof FileEditorInput) {
            this.editorSettings.setInput((FileEditorInput)input);
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    public boolean isDirty() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isSaveAsAllowed();
        }
        return false;
    }

    public void setVisualMode(int type) {
        switch (type) {
            case 0: {
                VpePlugin.getDefault().countVpvTabEvent();
                this.setVerticalToolbarVisible(WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show VPE Toolbar"));
                this.container.setMaximizedControl(null);
                if (this.sourceContent != null) {
                    this.sourceContent.setVisible(true);
                    if (this.sourceEditor != null) {
                        this.activeEditor = this.sourceEditor;
                    }
                }
                if (this.visualContent != null) {
                    this.visualContent.setVisible(true);
                }
                if (this.previewContent == null) break;
                this.previewContent.setVisible(false);
                break;
            }
            case 1: {
                VpePlugin.getDefault().countSourceTabEvent();
                this.setVerticalToolbarVisible(false);
                if (this.sourceContent == null) break;
                this.sourceContent.setVisible(true);
                if (this.sourceEditor != null) {
                    this.activeEditor = this.sourceEditor;
                }
                this.container.setMaximizedControl((Control)this.sourceContent);
                break;
            }
            case 2: {
                VpePlugin.getDefault().countVpvTabEvent();
                this.setVerticalToolbarVisible(false);
                if (this.previewContent == null) break;
                this.previewContent.setVisible(true);
                if (this.vpvPreview != null) {
                    this.activeEditor = this.vpvPreview;
                }
                this.container.setMaximizedControl((Control)this.previewContent);
            }
        }
        if (this.visualEditor != null && this.visualEditor.getController() != null) {
            this.visualEditor.getController().refreshCommands();
        }
        this.container.layout();
        if (this.visualMode == 1 && type != 1) {
            this.visualMode = type;
            if (this.visualEditor != null && this.visualEditor.getController() != null) {
                this.visualEditor.getController().visualRefresh();
                if (type != 2) {
                    this.visualEditor.getController().sourceSelectionChanged();
                }
            }
        }
        this.visualMode = type;
    }

    public int getVisualMode() {
        return this.visualMode;
    }

    public void setVerticalToolbarVisible(boolean visible) {
        if (this.verticalToolbarSplitter == null || this.verticalToolbarEmpty == null || this.toolBar == null) {
            return;
        }
        if (visible) {
            this.verticalToolbarSplitter.setVisible((Control)this.toolBar, true);
            this.verticalToolbarSplitter.setVisible((Control)this.verticalToolbarEmpty, false);
        } else {
            this.verticalToolbarSplitter.setVisible((Control)this.toolBar, false);
            this.verticalToolbarSplitter.setVisible((Control)this.verticalToolbarEmpty, true);
        }
        this.verticalToolbarSplitter.getParent().layout(true, true);
    }

    public void createPartControl(final Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.vpe.visual_page_editor");
        this.cmpEdTl = parent;
        GridLayout layoutEdTl = new GridLayout(2, false);
        layoutEdTl.verticalSpacing = 0;
        layoutEdTl.marginHeight = 0;
        layoutEdTl.marginBottom = 3;
        layoutEdTl.marginWidth = 0;
        this.cmpEdTl.setLayout((Layout)layoutEdTl);
        this.cmpEdTl.setLayoutData((Object)new GridData(1808));
        this.verticalToolbarSplitter = new Splitter(this.cmpEdTl, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.verticalToolbarSplitter.setLayout((Layout)layout);
        this.verticalToolbarSplitter.setLayoutData((Object)new GridData(0x1000000, 132, false, true, 1, 2));
        this.verticalToolbarEmpty = new Composite((Composite)this.verticalToolbarSplitter, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point point = super.computeSize(wHint, hHint, changed);
                point.x = 1;
                return point;
            }
        };
        this.verticalToolbarEmpty.setLayoutData((Object)new GridData(1040));
        this.verticalToolbarEmpty.setVisible(true);
        this.cmpEd = new Composite(this.cmpEdTl, 2048);
        GridLayout layoutEd = new GridLayout(1, false);
        layoutEd.marginBottom = 0;
        layoutEd.marginHeight = 1;
        layoutEd.marginWidth = 0;
        layoutEd.marginRight = 0;
        layoutEd.marginLeft = 1;
        layoutEd.verticalSpacing = 0;
        layoutEd.horizontalSpacing = 0;
        this.cmpEd.setLayout((Layout)layoutEd);
        this.cmpEd.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container = new CustomSashForm(this.cmpEd, CustomSashForm.getSplittingDirection((String)WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting")));
        if (this.editorSettings != null) {
            this.editorSettings.addSetting((EditorSettings.ISetting)new SashSetting(this.container));
        }
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        if (CustomSashForm.isSourceEditorFirst((String)WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
            this.sourceContent = new Composite((Composite)this.container, 0);
            this.visualContent = new Composite((Composite)this.container, 0);
        } else {
            this.visualContent = new Composite((Composite)this.container, 0);
            this.sourceContent = new Composite((Composite)this.container, 0);
        }
        this.sourceContent.setLayout((Layout)new FillLayout());
        this.visualContent.setLayout((Layout)new FillLayout());
        this.previewContent = new Composite((Composite)this.container, 0);
        this.previewContent.setLayout((Layout)new GridLayout());
        if (this.sourceEditor == null) {
            this.sourceEditor = new StructuredTextEditor(){

                public void safelySanityCheckState(IEditorInput input) {
                    super.safelySanityCheckState(input);
                }
            };
        }
        this.container.setSashBorders(new boolean[]{true, true, true});
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpvEditorPart.this.container.layout();
            }
        };
        parent.addControlListener(this.controlListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parent.removeControlListener(VpvEditorPart.this.controlListener);
                parent.removeDisposeListener((DisposeListener)this);
            }
        });
        final ControlListener visualContentControlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpvEditorPart.this.updateVisualEditorVisibility();
            }
        };
        this.visualContent.addControlListener(visualContentControlListener);
        this.visualContent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VpvEditorPart.this.visualContent.removeControlListener(visualContentControlListener);
                VpvEditorPart.this.visualContent.removeDisposeListener((DisposeListener)this);
            }
        });
        try {
            this.sourceEditor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 1) {
                        VpvEditorPart.this.setPartName(VpvEditorPart.this.sourceEditor.getTitle());
                    }
                    VpvEditorPart.this.firePropertyChange(propId);
                }
            });
            IEditorInput input = this.getEditorInput();
            if (!(input instanceof IModelObjectEditorInput) && input instanceof IStorageEditorInput) {
                input = new StorageRevisionEditorInputAdapter((IStorageEditorInput)input);
            }
            this.sourceEditor.init(this.getEditorSite(), input);
            if (this.sourceContent != null) {
                this.sourceEditor.createPartControl(this.sourceContent);
                this.sourceContent.addListener(26, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.type == 26 && VpvEditorPart.this.activeEditor != VpvEditorPart.this.sourceEditor) {
                            VpvEditorPart.this.activeEditor = VpvEditorPart.this.sourceEditor;
                            VpvEditorPart.this.setFocus();
                        }
                    }
                });
            }
            this.activeEditor = this.sourceEditor;
            this.visualContent.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26 && VpvEditorPart.this.visualEditor != null && VpvEditorPart.this.activeEditor != VpvEditorPart.this.visualEditor) {
                        VpvEditorPart.this.activeEditor = VpvEditorPart.this.visualEditor;
                        VpvEditorPart.this.setFocus();
                    }
                }
            });
            this.previewContent.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26 && VpvEditorPart.this.vpvPreview != null && VpvEditorPart.this.activeEditor != VpvEditorPart.this.vpvPreview) {
                        VpvEditorPart.this.activeEditor = VpvEditorPart.this.vpvPreview;
                        VpvEditorPart.this.setFocus();
                    }
                }
            });
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener((IPartListener)this.activationListener);
        }
        catch (CoreException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        if (this.editorSettings != null) {
            this.editorSettings.apply();
        }
        this.cmpEd.layout();
        this.container.addCustomSashFormListener(new CustomSashForm.ICustomSashFormListener(){

            public void dividerMoved(int firstControlWeight, int secondControlWeight) {
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Size of Visual Editor Pane 0-100%", secondControlWeight);
            }
        });
    }

    public void fillContainer(boolean useCurrentEditorSettings, String currentOrientation) {
        String splitting = useCurrentEditorSettings ? currentOrientation : WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        CustomSashForm newContainer = new CustomSashForm(this.cmpEd, CustomSashForm.getSplittingDirection((String)splitting));
        if (this.editorSettings != null) {
            this.editorSettings.clearOldSettings();
            this.editorSettings.addSetting((EditorSettings.ISetting)new SashSetting(newContainer));
        }
        newContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        if (CustomSashForm.isSourceEditorFirst((String)splitting)) {
            this.sourceContent.setParent((Composite)newContainer);
            this.visualContent.setParent((Composite)newContainer);
        } else {
            this.visualContent.setParent((Composite)newContainer);
            this.sourceContent.setParent((Composite)newContainer);
        }
        this.previewContent.setParent((Composite)newContainer);
        if (this.container.getMaximizedControl() != null) {
            newContainer.setMaximizedControl(this.container.getMaximizedControl());
        }
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = newContainer;
        int defaultWeight = WebUiPlugin.getDefault().getPreferenceStore().getInt("Size of Visual Editor Pane 0-100%");
        int[] weights = this.container.getWeights();
        if (useCurrentEditorSettings) {
            newContainer.setWeights(weights);
        } else if (defaultWeight == 0) {
            if (CustomSashForm.isSourceEditorFirst((String)splitting)) {
                this.container.maxDown();
            } else {
                this.container.maxUp();
            }
        } else if (defaultWeight == 1000) {
            if (CustomSashForm.isSourceEditorFirst((String)splitting)) {
                this.container.maxUp();
            } else {
                this.container.maxDown();
            }
        } else {
            if (CustomSashForm.isSourceEditorFirst((String)splitting)) {
                weights[0] = 1000 - defaultWeight;
                weights[1] = defaultWeight;
            } else {
                weights[0] = defaultWeight;
                weights[1] = 1000 - defaultWeight;
            }
            if (weights != null && !this.container.isDisposed()) {
                this.container.setWeights(weights);
            }
        }
        this.container.setSashBorders(new boolean[]{true, true, true});
        if (this.controlListener != null && this.cmpEdTl != null && !this.cmpEdTl.isDisposed()) {
            this.cmpEdTl.getParent().removeControlListener(this.controlListener);
        }
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpvEditorPart.this.container.layout();
            }
        };
        if (this.cmpEdTl != null && !this.cmpEdTl.isDisposed()) {
            this.cmpEdTl.getParent().addControlListener(this.controlListener);
        }
        this.cmpEdTl.layout(true, true);
    }

    public void createVisualEditor() {
        this.visualEditor = new VpvEditor((IEditorPart)this.sourceEditor);
        try {
            this.visualEditor.init(this.getEditorSite(), this.getEditorInput());
        }
        catch (PartInitException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        this.visualEditor.setEditorLoadWindowListener(new EditorLoadWindowListener(){

            public void load() {
                VpvEditorPart.this.visualEditor.setEditorLoadWindowListener(null);
                VpvEditorController vpeController = new VpvEditorController(VpvEditorPart.this);
                vpeController.init(VpvEditorPart.this.sourceEditor, VpvEditorPart.this.visualEditor, VpvEditorPart.this.bundleMap);
            }
        });
        this.toolBar = this.visualEditor.createVisualToolbar((Composite)this.verticalToolbarSplitter);
        this.visualEditor.createPartControl(this.visualContent);
        this.visualEditor.addPreviewToolbarItems();
        if (this.multiPageEditor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jspMultiPageEditor = (JSPMultiPageEditor)this.multiPageEditor;
            this.selectionBar = jspMultiPageEditor.getSelectionBar();
            if (!XulRunnerBrowser.isCurrentPlatformOfficiallySupported()) {
                jspMultiPageEditor.setXulRunnerBrowserIsNotSupported(true);
            }
        }
    }

    public void createPreviewBrowser() {
        this.vpvPreview = new VpvPreview((IEditorPart)this.sourceEditor);
        try {
            this.vpvPreview.init(this.getEditorSite(), this.getEditorInput());
            this.vpvPreview.setEditorLoadWindowListener(new EditorLoadWindowListener(){

                public void load() {
                    VpvEditorPart.this.vpvPreview.setEditorLoadWindowListener(null);
                    VpvEditorPart.this.vpvPreview.load();
                }
            });
            this.vpvPreview.createPartControl(this.previewContent);
        }
        catch (PartInitException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        if (!XulRunnerBrowser.isCurrentPlatformOfficiallySupported() && this.multiPageEditor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jspMultiPageEditor = (JSPMultiPageEditor)this.multiPageEditor;
            jspMultiPageEditor.setXulRunnerBrowserIsNotSupported(true);
        }
    }

    public void setFocus() {
        if (this.activeEditor != null) {
            this.activeEditor.setFocus();
        }
    }

    public void dispose() {
        if (this.verticalToolbarEmpty != null) {
            if (!this.verticalToolbarEmpty.isDisposed()) {
                this.verticalToolbarEmpty.dispose();
            }
            this.verticalToolbarEmpty = null;
        }
        if (this.editorSettings != null) {
            this.editorSettings.dispose();
            this.editorSettings = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.dispose();
            this.sourceEditor = null;
        }
        if (this.visualEditor != null) {
            this.visualEditor.dispose();
            this.visualEditor = null;
        }
        if (this.vpvPreview != null) {
            this.vpvPreview.dispose();
            this.vpvPreview = null;
        }
        if (this.previewContent != null) {
            this.previewContent.dispose();
            this.previewContent = null;
        }
        if (this.selectionBar != null) {
            this.selectionBar.dispose();
            this.selectionBar = null;
        }
        this.activeEditor = null;
        this.multiPageEditor = null;
        super.dispose();
    }

    public void maximizeSource() {
        if (this.container != null) {
            if (CustomSashForm.isSourceEditorFirst((String)WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
                this.container.maxDown();
            } else {
                this.container.maxUp();
            }
            this.updateVisualEditorVisibility();
        }
    }

    public void maximizeVisual() {
        if (this.container != null) {
            if (CustomSashForm.isSourceEditorFirst((String)WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
                this.container.maxUp();
            } else {
                this.container.maxDown();
            }
            this.updateVisualEditorVisibility();
        }
    }

    protected void updateVisualEditorVisibility() {
        Point point = this.visualContent.getSize();
        if (point.x == 0 || point.y == 0) {
            VpvEditorController controller = this.getController();
            if (controller != null) {
                controller.setVisualEditorVisible(false);
            }
        } else {
            VpvEditorController controller = this.getController();
            if (controller != null && !controller.isVisualEditorVisible()) {
                controller.setVisualEditorVisible(true);
            }
            this.visualEditor.reload();
        }
    }

    public void updateSelectionBar(boolean isSelectionBarVisible) {
        if (this.selectionBar != null) {
            this.selectionBar.setVisible(isSelectionBarVisible);
        } else {
            VpePlugin.getDefault().logError(Messages.VpvEditorPart_SELECTION_BAR_NOT_INITIALIZED);
        }
    }

    public VpvEditorController getController() {
        return this.visualEditor != null ? this.visualEditor.getController() : null;
    }

    public Object getPreviewWebBrowser() {
        return this.vpvPreview;
    }

    public Object getVisualEditor() {
        return this.visualEditor;
    }

    public void updatePartAccordingToPreferences() {
        if (this.visualEditor != null) {
            this.visualEditor.updateToolbarItemsAccordingToPreferences();
        }
        if (this.getController() != null) {
            boolean prefsShowVPEToolBar = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show VPE Toolbar");
            this.setVerticalToolbarVisible(prefsShowVPEToolBar);
            this.fillContainer(false, null);
        }
    }

    public CustomSashForm getContainer() {
        return this.container;
    }

    private class ActivationListener
    implements IPartListener {
        private IWorkbenchPart fActivePart;

        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void handleActivation() {
            if (VpvEditorPart.this.visualEditor != null && VpvEditorPart.this.visualEditor.getController() != null) {
                VpvEditorPart.this.visualEditor.getController().refreshCommands();
            }
            if (this.fActivePart == VpvEditorPart.this.multiPageEditor && VpvEditorPart.this.sourceEditor != null && VpvEditorPart.this.visualEditor != null) {
                if (this.isVisualEditorVisible()) {
                    VpvEditorPart.this.visualEditor.getController().visualRefresh();
                }
                VpvEditorPart.this.sourceEditor.safelySanityCheckState(VpvEditorPart.this.getEditorInput());
            }
        }

        private boolean isVisualEditorVisible() {
            return VpvEditorPart.this.visualEditor.getController() != null && VpvEditorPart.this.visualEditor.getController().isVisualEditorVisible();
        }
    }
}

