/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.vpe.editor.VisualController;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.listener.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.preferences.VpeEditorPreferencesPage;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBarManager;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.preview.core.exceptions.BrowserErrorWrapper;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.util.ActionBarUtil;
import org.jboss.tools.vpe.preview.core.util.EditorUtil;
import org.jboss.tools.vpe.preview.core.util.NavigationUtil;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;
import org.jboss.tools.vpe.preview.editor.Activator;
import org.jboss.tools.vpe.preview.editor.VpvEditorController;

public class VpvEditor
extends EditorPart
implements VpvVisualModelHolder,
IReusableEditor {
    public static final String ICON_PREFERENCE = "icons/preference.gif";
    public static final String ICON_PREFERENCE_DISABLED = "icons/preference_disabled.gif";
    public static final String ICON_REFRESH = "icons/refresh.gif";
    public static final String ICON_REFRESH_DISABLED = "icons/refresh_disabled.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS = "icons/point_to_css.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS_DISABLED = "icons/point_to_css_disabled.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT = "icons/source_left.gif";
    public static final String ICON_ORIENTATION_SOURCE_TOP = "icons/source_top.gif";
    public static final String ICON_ORIENTATION_VISUAL_LEFT = "icons/visual_left.gif";
    public static final String ICON_ORIENTATION_VISUAI_TOP = "icons/visual_top.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT_DISABLED = "icons/source_left_disabled.gif";
    public static final String ICON_SELECTION_BAR = "icons/selbar.gif";
    public static final String ICON_TEXT_FORMATTING = "icons/text-formatting.gif";
    public static final String ICON_SCROLL_LOCK = "icons/scroll_lock.gif";
    private static Map<String, String> layoutIcons = new HashMap<String, String>();
    private static Map<String, String> layoutNames;
    private static List<String> layoutValues;
    private int currentOrientationIndex = 1;
    private Action openVPEPreferencesAction;
    private Action rotateEditorsAction;
    private Action showSelectionBarAction;
    private final ToolBarManager toolBarManager = new ToolBarManager(0x800200);
    private FormatControllerManager formatControllerManager = new FormatControllerManager();
    private VpvEditorController controller;
    private ToolBar verBar = null;
    private IPropertyChangeListener selectionBarCloseListener;
    private IVpeToolBarManager vpeToolBarManager;
    private EditorLoadWindowListener editorLoadWindowListener;
    private Browser browser;
    private VpvVisualModel visualModel;
    private int modelHolderId;
    private SelectionListener selectionListener;
    private IEditorPart sourceEditor;
    private Job currentJob;
    private ActionBarUtil actionBarUtil;
    protected BrowserErrorWrapper errorWrapper = new BrowserErrorWrapper();

    static {
        layoutIcons.put("3", ICON_ORIENTATION_SOURCE_LEFT);
        layoutIcons.put("1", ICON_ORIENTATION_SOURCE_TOP);
        layoutIcons.put("4", ICON_ORIENTATION_VISUAL_LEFT);
        layoutIcons.put("2", ICON_ORIENTATION_VISUAI_TOP);
        layoutNames = new HashMap<String, String>();
        layoutNames.put("3", VpeUIMessages.SPLITTING_HORIZ_LEFT_SOURCE_TOOLTIP);
        layoutNames.put("1", VpeUIMessages.SPLITTING_VERT_TOP_SOURCE_TOOLTIP);
        layoutNames.put("4", VpeUIMessages.SPLITTING_HORIZ_LEFT_VISUAL_TOOLTIP);
        layoutNames.put("2", VpeUIMessages.SPLITTING_VERT_TOP_VISUAL_TOOLTIP);
        layoutValues = new ArrayList<String>();
        layoutValues.add("3");
        layoutValues.add("1");
        layoutValues.add("4");
        layoutValues.add("2");
    }

    public VpvEditor() {
    }

    public VpvEditor(IEditorPart sourceEditor) {
        this.setModelHolderId(Activator.getDefault().getVisualModelHolderRegistry().registerHolder((VpvVisualModelHolder)this));
        this.sourceEditor = sourceEditor;
        IDocument document = (IDocument)this.sourceEditor.getAdapter(IDocument.class);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (VpvEditor.this.actionBarUtil.isAutomaticRefreshEnabled() && VpvEditor.this.controller.isVisualEditorVisible()) {
                    VpvEditor.this.updatePreview();
                }
            }
        });
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public void setInput(IEditorInput input) {
        boolean isVisualRefreshRequired = this.getEditorInput() != null && this.getEditorInput() != input && this.controller != null;
        super.setInput(input);
        if (isVisualRefreshRequired) {
            this.controller.visualRefresh();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setController(VpvEditorController controller) {
        this.controller = controller;
        this.formatControllerManager.setVpeController((VisualController)controller);
        controller.setToolbarFormatControllerManager(this.formatControllerManager);
    }

    public ToolBar createVisualToolbar(Composite parent) {
        this.verBar = this.toolBarManager.createControl(parent);
        this.openVPEPreferencesAction = new Action(VpeUIMessages.PREFERENCES, 1){

            public void run() {
                VpeEditorPreferencesPage.openPreferenceDialog();
            }
        };
        this.openVPEPreferencesAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_PREFERENCE));
        this.openVPEPreferencesAction.setToolTipText(VpeUIMessages.PREFERENCES);
        this.toolBarManager.add((IAction)this.openVPEPreferencesAction);
        String newOrientation = WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        this.currentOrientationIndex = layoutValues.indexOf(newOrientation);
        this.rotateEditorsAction = new Action(VpeUIMessages.VISUAL_SOURCE_EDITORS_SPLITTING, 1){

            public void run() {
                VpvEditor vpvEditor = VpvEditor.this;
                vpvEditor.currentOrientationIndex = vpvEditor.currentOrientationIndex + 1;
                if (VpvEditor.this.currentOrientationIndex >= layoutValues.size()) {
                    VpvEditor vpvEditor2 = VpvEditor.this;
                    vpvEditor2.currentOrientationIndex = vpvEditor2.currentOrientationIndex % layoutValues.size();
                }
                String newOrientation = (String)layoutValues.get(VpvEditor.this.currentOrientationIndex);
                this.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)((String)layoutIcons.get(newOrientation))));
                this.setToolTipText((String)layoutNames.get(newOrientation));
                VpvEditor.this.getController().getPageContext().getEditPart().fillContainer(true, newOrientation);
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Visual/Source Editors Splitting", newOrientation);
            }
        };
        this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(newOrientation)));
        this.rotateEditorsAction.setToolTipText(layoutNames.get(newOrientation));
        this.toolBarManager.add((IAction)this.rotateEditorsAction);
        this.showSelectionBarAction = new Action(VpeUIMessages.SHOW_SELECTION_BAR, 2){

            public void run() {
                VpvEditor.this.controller.getPageContext().getEditPart().updateSelectionBar(this.isChecked());
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Selection Tag Bar", this.isChecked());
            }
        };
        this.selectionBarCloseListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Show Selection Tag Bar".equalsIgnoreCase(event.getProperty())) {
                    boolean newValue = (Boolean)event.getNewValue();
                    if (VpvEditor.this.showSelectionBarAction.isChecked() != newValue) {
                        VpvEditor.this.showSelectionBarAction.setChecked(newValue);
                    }
                }
            }
        };
        WebUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.selectionBarCloseListener);
        this.showSelectionBarAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SELECTION_BAR));
        this.showSelectionBarAction.setToolTipText(VpeUIMessages.SHOW_SELECTION_BAR);
        this.toolBarManager.add((IAction)this.showSelectionBarAction);
        this.updateToolbarItemsAccordingToPreferences();
        this.toolBarManager.update(true);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VpvEditor.this.toolBarManager.dispose();
                VpvEditor.this.toolBarManager.removeAll();
                VpvEditor.this.openVPEPreferencesAction = null;
                VpvEditor.this.rotateEditorsAction = null;
                VpvEditor.this.showSelectionBarAction = null;
            }
        });
        return this.verBar;
    }

    public void addPreviewToolbarItems() {
        this.actionBarUtil = new ActionBarUtil(this.browser);
        this.actionBarUtil.fillLocalToolBar((IToolBarManager)this.toolBarManager);
        this.toolBarManager.update(true);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginBottom = 0;
        parent.setLayout((Layout)layout);
        Composite cmpEdTl = new Composite(parent, 0);
        GridLayout layoutEdTl = new GridLayout(1, false);
        layoutEdTl.verticalSpacing = 0;
        layoutEdTl.marginHeight = 0;
        layoutEdTl.marginBottom = 3;
        layoutEdTl.marginWidth = 0;
        cmpEdTl.setLayout((Layout)layoutEdTl);
        cmpEdTl.setLayoutData((Object)new GridData(1808));
        Composite cmpEd = new Composite(cmpEdTl, 8);
        GridLayout layoutEd = new GridLayout(1, false);
        layoutEd.marginBottom = 0;
        layoutEd.marginHeight = 1;
        layoutEd.marginWidth = 0;
        layoutEd.marginRight = 0;
        layoutEd.marginLeft = 1;
        layoutEd.verticalSpacing = 0;
        layoutEd.horizontalSpacing = 0;
        cmpEd.setLayout((Layout)layoutEd);
        cmpEd.setLayoutData((Object)new GridData(1808));
        Color buttonDarker = parent.getDisplay().getSystemColor(18);
        cmpEd.setBackground(buttonDarker);
        try {
            this.browser = new Browser(cmpEd, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    NavigationUtil.disableAlert((Browser)VpvEditor.this.browser);
                    NavigationUtil.disableLinks((Browser)VpvEditor.this.browser);
                    NavigationUtil.disableInputs((Browser)VpvEditor.this.browser);
                    ISelection currentSelection = VpvEditor.this.getCurrentSelection();
                    NavigationUtil.updateSelectionAndScrollToIt((ISelection)currentSelection, (Browser)VpvEditor.this.browser, (VpvVisualModel)VpvEditor.this.visualModel);
                }
            });
            this.browser.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    NavigationUtil.navigateToVisual((IEditorPart)VpvEditor.this.sourceEditor, (Browser)VpvEditor.this.browser, (VpvVisualModel)VpvEditor.this.visualModel, (int)event.x, (int)event.y);
                }
            });
            if (this.editorLoadWindowListener != null) {
                this.editorLoadWindowListener.load();
            }
            this.inizializeSelectionListener();
        }
        catch (Throwable t) {
            if (this.verBar != null) {
                this.verBar.setEnabled(false);
            }
            this.errorWrapper.showError(cmpEd, t);
        }
    }

    private void inizializeSelectionListener() {
        this.selectionListener = new SelectionListener();
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.selectionListener);
    }

    private ISelection getCurrentSelection() {
        Activator activator = Activator.getDefault();
        IWorkbench workbench = activator.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        return selection;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void dispose() {
        if (this.selectionBarCloseListener != null) {
            WebUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.selectionBarCloseListener);
        }
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this.selectionListener);
        }
        Activator.getDefault().getVisualModelHolderRegistry().unregisterHolder((VpvVisualModelHolder)this);
        if (this.vpeToolBarManager != null) {
            this.vpeToolBarManager.dispose();
            this.vpeToolBarManager = null;
        }
        if (this.controller != null) {
            this.controller.dispose();
            this.controller = null;
        }
        if (this.browser != null) {
            this.browser.dispose();
            this.browser = null;
        }
        this.formatControllerManager.setVpeController(null);
        this.formatControllerManager = null;
        super.dispose();
    }

    public void updateToolbarItemsAccordingToPreferences() {
        String prefsOrientation = WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        int prefsOrientationIndex = layoutValues.indexOf(prefsOrientation);
        boolean prefsShowSelectionBar = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
        if (this.showSelectionBarAction != null) {
            this.showSelectionBarAction.setChecked(prefsShowSelectionBar);
        }
        if (this.rotateEditorsAction != null) {
            this.currentOrientationIndex = prefsOrientationIndex;
            this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(prefsOrientation)));
            this.rotateEditorsAction.setToolTipText(layoutNames.get(prefsOrientation));
        }
    }

    public void reload() {
        if (this.browser != null) {
            this.formRequestToServer();
        }
    }

    private void formRequestToServer() {
        IFile ifile = EditorUtil.getFileOpenedInEditor((IEditorPart)this.sourceEditor);
        if (ifile != null && SuitableFileExtensions.contains((String)ifile.getFileExtension().toString())) {
            try {
                String url = EditorUtil.formUrl((IFile)ifile, (int)this.modelHolderId, (String)("" + Activator.getDefault().getServer().getPort()));
                this.browser.setUrl(url);
            }
            catch (UnsupportedEncodingException e) {
                Activator.logError(e);
            }
        } else {
            this.browser.setUrl("about:blank");
        }
    }

    private void updatePreview() {
        if (this.currentJob == null || this.currentJob.getState() != 2) {
            if (this.currentJob != null && this.currentJob.getState() == 1) {
                this.currentJob.cancel();
            }
            this.currentJob = this.createPreviewUpdateJob();
        }
        this.currentJob.schedule(500L);
    }

    private Job createPreviewUpdateJob() {
        UIJob job = new UIJob("Preview Update"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!VpvEditor.this.browser.isDisposed()) {
                    VpvEditor.this.browser.setUrl(VpvEditor.this.browser.getUrl());
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    public VpvEditorController getController() {
        return this.controller;
    }

    public void setVisualModel(VpvVisualModel visualModel) {
        this.visualModel = visualModel;
    }

    public void setModelHolderId(int modelHolderId) {
        this.modelHolderId = modelHolderId;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setEditorLoadWindowListener(EditorLoadWindowListener listener) {
        this.editorLoadWindowListener = listener;
    }

    protected void setSourceEditor(IEditorPart sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    private class SelectionListener
    implements ISelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection && EditorUtil.isInCurrentEditor((IStructuredSelection)((IStructuredSelection)selection), (IEditorPart)VpvEditor.this.sourceEditor)) {
                NavigationUtil.updateSelectionAndScrollToIt((ISelection)selection, (Browser)VpvEditor.this.browser, (VpvVisualModel)VpvEditor.this.visualModel);
            }
        }
    }
}

